/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.pocket;

import dan200.computercraft.api.pocket.IPocketUpgrade;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.common.util.NonNullSupplier;

public abstract class AbstractPocketUpgrade
implements IPocketUpgrade {
    private final ResourceLocation id;
    private final String adjective;
    private final NonNullSupplier<ItemStack> stack;

    protected AbstractPocketUpgrade(ResourceLocation id, String adjective, NonNullSupplier<ItemStack> stack) {
        this.id = id;
        this.adjective = adjective;
        this.stack = stack;
    }

    protected AbstractPocketUpgrade(ResourceLocation id, NonNullSupplier<ItemStack> item) {
        this(id, Util.func_200697_a((String)"upgrade", (ResourceLocation)id) + ".adjective", item);
    }

    protected AbstractPocketUpgrade(ResourceLocation id, String adjective, ItemStack stack) {
        this(id, adjective, (NonNullSupplier<ItemStack>)((NonNullSupplier)() -> stack));
    }

    protected AbstractPocketUpgrade(ResourceLocation id, ItemStack stack) {
        this(id, (NonNullSupplier<ItemStack>)((NonNullSupplier)() -> stack));
    }

    protected AbstractPocketUpgrade(ResourceLocation id, String adjective, IItemProvider item) {
        this(id, adjective, new CachedStack(() -> item));
    }

    protected AbstractPocketUpgrade(ResourceLocation id, IItemProvider item) {
        this(id, new CachedStack(() -> item));
    }

    protected AbstractPocketUpgrade(ResourceLocation id, String adjective, Supplier<? extends IItemProvider> item) {
        this(id, adjective, new CachedStack(item));
    }

    protected AbstractPocketUpgrade(ResourceLocation id, Supplier<? extends IItemProvider> item) {
        this(id, new CachedStack(item));
    }

    @Override
    @Nonnull
    public final ResourceLocation getUpgradeID() {
        return this.id;
    }

    @Override
    @Nonnull
    public final String getUnlocalisedAdjective() {
        return this.adjective;
    }

    @Override
    @Nonnull
    public final ItemStack getCraftingItem() {
        return (ItemStack)this.stack.get();
    }

    private static final class CachedStack
    implements NonNullSupplier<ItemStack> {
        private final Supplier<? extends IItemProvider> provider;
        private Item item;
        private ItemStack stack;

        CachedStack(Supplier<? extends IItemProvider> provider) {
            this.provider = provider;
        }

        @Nonnull
        public ItemStack get() {
            Item item = this.provider.get().func_199767_j();
            if (item == this.item && this.stack != null) {
                return this.stack;
            }
            this.item = item;
            this.stack = new ItemStack((IItemProvider)this.item);
            return this.stack;
        }
    }
}

