/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.computer;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.filesystem.IWritableMount;
import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.lua.ILuaAPIFactory;
import dan200.computercraft.core.apis.ApiFactories;
import dan200.computercraft.core.apis.FSAPI;
import dan200.computercraft.core.apis.HTTPAPI;
import dan200.computercraft.core.apis.OSAPI;
import dan200.computercraft.core.apis.PeripheralAPI;
import dan200.computercraft.core.apis.RedstoneAPI;
import dan200.computercraft.core.apis.TermAPI;
import dan200.computercraft.core.computer.ApiWrapper;
import dan200.computercraft.core.computer.Computer;
import dan200.computercraft.core.computer.ComputerSystem;
import dan200.computercraft.core.computer.ComputerThread;
import dan200.computercraft.core.computer.Environment;
import dan200.computercraft.core.computer.TimeoutState;
import dan200.computercraft.core.filesystem.FileSystem;
import dan200.computercraft.core.filesystem.FileSystemException;
import dan200.computercraft.core.lua.CobaltLuaMachine;
import dan200.computercraft.core.lua.ILuaMachine;
import dan200.computercraft.core.lua.MachineResult;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.core.tracking.Tracking;
import dan200.computercraft.shared.util.Colour;
import dan200.computercraft.shared.util.IoUtil;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class ComputerExecutor {
    private static final int QUEUE_LIMIT = 256;
    private final Computer computer;
    private final List<ILuaAPI> apis = new ArrayList<ILuaAPI>();
    final TimeoutState timeout = new TimeoutState();
    private FileSystem fileSystem;
    private ILuaMachine machine;
    private volatile boolean isOn = false;
    private final ReentrantLock isOnLock = new ReentrantLock();
    private final Object queueLock = new Object();
    volatile boolean onComputerQueue = false;
    long virtualRuntime = 0L;
    long vRuntimeStart;
    private volatile StateCommand command;
    private final Queue<Event> eventQueue = new ArrayDeque<Event>(4);
    private boolean interruptedEvent = false;
    private boolean closed;
    private IWritableMount rootMount;
    final AtomicReference<Thread> executingThread = new AtomicReference();

    ComputerExecutor(Computer computer) {
        ComputerThread.start();
        this.computer = computer;
        Environment environment = computer.getEnvironment();
        this.apis.add(new TermAPI(environment));
        this.apis.add(new RedstoneAPI(environment));
        this.apis.add(new FSAPI(environment));
        this.apis.add(new PeripheralAPI(environment));
        this.apis.add(new OSAPI(environment));
        if (ComputerCraft.httpEnabled) {
            this.apis.add(new HTTPAPI(environment));
        }
        for (ILuaAPIFactory factory : ApiFactories.getAll()) {
            ComputerSystem system;
            ILuaAPI api = factory.create(system = new ComputerSystem(environment));
            if (api == null) continue;
            this.apis.add(new ApiWrapper(api, system));
        }
    }

    boolean isOn() {
        return this.isOn;
    }

    FileSystem getFileSystem() {
        return this.fileSystem;
    }

    Computer getComputer() {
        return this.computer;
    }

    void addApi(ILuaAPI api) {
        this.apis.add(api);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queueStart() {
        Object object = this.queueLock;
        synchronized (object) {
            if (this.closed || this.isOn || this.command != null) {
                return;
            }
            this.command = StateCommand.TURN_ON;
            this.enqueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queueStop(boolean reboot, boolean close) {
        Object object = this.queueLock;
        synchronized (object) {
            StateCommand newCommand;
            if (this.closed) {
                return;
            }
            this.closed = close;
            StateCommand stateCommand = newCommand = reboot ? StateCommand.REBOOT : StateCommand.SHUTDOWN;
            if (!this.isOn || this.command != null) {
                if (close) {
                    this.command = newCommand;
                }
                return;
            }
            this.command = newCommand;
            this.enqueue();
        }
    }

    void abort() {
        this.immediateFail(StateCommand.ABORT);
    }

    void fastFail() {
        this.immediateFail(StateCommand.ERROR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void immediateFail(StateCommand command) {
        ILuaMachine machine = this.machine;
        if (machine != null) {
            machine.close();
        }
        Object object = this.queueLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.command = command;
            if (this.isOn) {
                this.enqueue();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queueEvent(@Nonnull String event, @Nullable Object[] args) {
        if (!this.isOn) {
            return;
        }
        Object object = this.queueLock;
        synchronized (object) {
            if (this.closed || this.command != null || this.eventQueue.size() >= 256) {
                return;
            }
            this.eventQueue.offer(new Event(event, args));
            this.enqueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueue() {
        Object object = this.queueLock;
        synchronized (object) {
            if (!this.onComputerQueue) {
                ComputerThread.queue(this);
            }
        }
    }

    void tick() {
        if (this.isOn && this.isOnLock.tryLock()) {
            try {
                if (this.isOn) {
                    for (ILuaAPI api : this.apis) {
                        api.update();
                    }
                }
            }
            finally {
                this.isOnLock.unlock();
            }
        }
    }

    private IMount getRomMount() {
        return this.computer.getComputerEnvironment().createResourceMount("computercraft", "lua/rom");
    }

    private IWritableMount getRootMount() {
        if (this.rootMount == null) {
            this.rootMount = this.computer.getComputerEnvironment().createSaveDirMount("computer/" + this.computer.assignID(), this.computer.getComputerEnvironment().getComputerSpaceLimit());
        }
        return this.rootMount;
    }

    private FileSystem createFileSystem() {
        FileSystem filesystem = null;
        try {
            filesystem = new FileSystem("hdd", this.getRootMount());
            IMount romMount = this.getRomMount();
            if (romMount == null) {
                this.displayFailure("Cannot mount ROM", null);
                return null;
            }
            filesystem.mount("rom", "rom", romMount);
            return filesystem;
        }
        catch (FileSystemException e) {
            if (filesystem != null) {
                filesystem.close();
            }
            ComputerCraft.log.error("Cannot mount computer filesystem", (Throwable)e);
            this.displayFailure("Cannot mount computer system", null);
            return null;
        }
    }

    private ILuaMachine createLuaMachine() {
        InputStream biosStream = null;
        try {
            biosStream = this.computer.getComputerEnvironment().createResourceFile("computercraft", "lua/bios.lua");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (biosStream == null) {
            this.displayFailure("Error loading bios.lua", null);
            return null;
        }
        CobaltLuaMachine machine = new CobaltLuaMachine(this.computer, this.timeout);
        for (ILuaAPI api : this.apis) {
            machine.addAPI(api instanceof ApiWrapper ? ((ApiWrapper)api).getDelegate() : api);
        }
        MachineResult result = machine.loadBios(biosStream);
        IoUtil.closeQuietly(biosStream);
        if (result.isError()) {
            machine.close();
            this.displayFailure("Error loading bios.lua", result.getMessage());
            return null;
        }
        return machine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void turnOn() throws InterruptedException {
        this.isOnLock.lockInterruptibly();
        try {
            this.computer.getTerminal().reset();
            this.interruptedEvent = false;
            Iterator<ILuaAPI> iterator = this.queueLock;
            synchronized (iterator) {
                this.eventQueue.clear();
            }
            this.fileSystem = this.createFileSystem();
            if (this.fileSystem == null) {
                this.shutdown();
                return;
            }
            this.computer.getEnvironment().reset();
            for (ILuaAPI api : this.apis) {
                api.startup();
            }
            this.machine = this.createLuaMachine();
            if (this.machine == null) {
                this.shutdown();
                return;
            }
            this.isOn = true;
            this.computer.markChanged();
        }
        finally {
            this.isOnLock.unlock();
        }
        this.resumeMachine(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown() throws InterruptedException {
        this.isOnLock.lockInterruptibly();
        try {
            this.isOn = false;
            this.interruptedEvent = false;
            Iterator<ILuaAPI> iterator = this.queueLock;
            synchronized (iterator) {
                this.eventQueue.clear();
            }
            if (this.machine != null) {
                this.machine.close();
                this.machine = null;
            }
            for (ILuaAPI api : this.apis) {
                api.shutdown();
            }
            this.computer.getEnvironment().reset();
            if (this.fileSystem != null) {
                this.fileSystem.close();
                this.fileSystem = null;
            }
            this.computer.getEnvironment().resetOutput();
            this.computer.markChanged();
        }
        finally {
            this.isOnLock.unlock();
        }
    }

    void beforeWork() {
        this.vRuntimeStart = System.nanoTime();
        this.timeout.startTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean afterWork() {
        if (this.interruptedEvent) {
            this.timeout.pauseTimer();
        } else {
            this.timeout.stopTimer();
        }
        Tracking.addTaskTiming(this.getComputer(), this.timeout.nanoCurrent());
        if (this.interruptedEvent) {
            return true;
        }
        Object object = this.queueLock;
        synchronized (object) {
            if (this.eventQueue.isEmpty() && this.command == null) {
                this.onComputerQueue = false;
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void work() throws InterruptedException {
        StateCommand command;
        if (this.interruptedEvent) {
            this.interruptedEvent = false;
            if (this.machine != null) {
                this.resumeMachine(null, null);
                return;
            }
        }
        Event event = null;
        Object object = this.queueLock;
        synchronized (object) {
            command = this.command;
            this.command = null;
            if (command == null) {
                if (!this.isOn) {
                    this.eventQueue.clear();
                    return;
                }
                event = this.eventQueue.poll();
            }
        }
        if (command != null) {
            switch (command) {
                case TURN_ON: {
                    if (this.isOn) {
                        return;
                    }
                    this.turnOn();
                    break;
                }
                case SHUTDOWN: {
                    if (!this.isOn) {
                        return;
                    }
                    this.computer.getTerminal().reset();
                    this.shutdown();
                    break;
                }
                case REBOOT: {
                    if (!this.isOn) {
                        return;
                    }
                    this.computer.getTerminal().reset();
                    this.shutdown();
                    this.computer.turnOn();
                    break;
                }
                case ABORT: {
                    if (!this.isOn) {
                        return;
                    }
                    this.displayFailure("Error running computer", "Too long without yielding");
                    this.shutdown();
                    break;
                }
                case ERROR: {
                    if (!this.isOn) {
                        return;
                    }
                    this.displayFailure("Error running computer", "An internal error occurred, see logs.");
                    this.shutdown();
                }
            }
        } else if (event != null) {
            this.resumeMachine(event.name, event.args);
        }
    }

    private void displayFailure(String message, String extra) {
        Terminal terminal = this.computer.getTerminal();
        boolean colour = this.computer.getComputerEnvironment().isColour();
        terminal.reset();
        if (colour) {
            terminal.setTextColour(15 - Colour.RED.ordinal());
        }
        terminal.write(message);
        if (extra != null) {
            terminal.setCursorPos(0, terminal.getCursorY() + 1);
            terminal.write(extra);
        }
        terminal.setCursorPos(0, terminal.getCursorY() + 1);
        if (colour) {
            terminal.setTextColour(15 - Colour.WHITE.ordinal());
        }
        terminal.write("ComputerCraft may be installed incorrectly");
    }

    private void resumeMachine(String event, Object[] args) throws InterruptedException {
        MachineResult result = this.machine.handleEvent(event, args);
        this.interruptedEvent = result.isPause();
        if (!result.isError()) {
            return;
        }
        this.displayFailure("Error running computer", result.getMessage());
        this.shutdown();
    }

    private static final class Event {
        final String name;
        final Object[] args;

        private Event(String name, Object[] args) {
            this.name = name;
            this.args = args;
        }
    }

    private static enum StateCommand {
        TURN_ON,
        SHUTDOWN,
        REBOOT,
        ABORT,
        ERROR;

    }
}

