/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.terminal;

import dan200.computercraft.core.terminal.TextBuffer;
import dan200.computercraft.shared.util.Colour;
import dan200.computercraft.shared.util.Palette;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;

public class Terminal {
    private static final String base16 = "0123456789abcdef";
    private int cursorX = 0;
    private int cursorY = 0;
    private boolean cursorBlink = false;
    private int cursorColour = 0;
    private int cursorBackgroundColour = 15;
    private int width;
    private int height;
    private TextBuffer[] text;
    private TextBuffer[] textColour;
    private TextBuffer[] backgroundColour;
    private final Palette palette = new Palette();
    private final Runnable onChanged;

    public Terminal(int width, int height) {
        this(width, height, null);
    }

    public Terminal(int width, int height, Runnable changedCallback) {
        this.width = width;
        this.height = height;
        this.onChanged = changedCallback;
        this.text = new TextBuffer[height];
        this.textColour = new TextBuffer[height];
        this.backgroundColour = new TextBuffer[height];
        for (int i = 0; i < this.height; ++i) {
            this.text[i] = new TextBuffer(' ', this.width);
            this.textColour[i] = new TextBuffer(base16.charAt(this.cursorColour), this.width);
            this.backgroundColour[i] = new TextBuffer(base16.charAt(this.cursorBackgroundColour), this.width);
        }
    }

    public synchronized void reset() {
        this.cursorColour = 0;
        this.cursorBackgroundColour = 15;
        this.cursorX = 0;
        this.cursorY = 0;
        this.cursorBlink = false;
        this.clear();
        this.setChanged();
        this.palette.resetColours();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public synchronized void resize(int width, int height) {
        if (width == this.width && height == this.height) {
            return;
        }
        int oldHeight = this.height;
        int oldWidth = this.width;
        TextBuffer[] oldText = this.text;
        TextBuffer[] oldTextColour = this.textColour;
        TextBuffer[] oldBackgroundColour = this.backgroundColour;
        this.width = width;
        this.height = height;
        this.text = new TextBuffer[height];
        this.textColour = new TextBuffer[height];
        this.backgroundColour = new TextBuffer[height];
        for (int i = 0; i < this.height; ++i) {
            if (i >= oldHeight) {
                this.text[i] = new TextBuffer(' ', this.width);
                this.textColour[i] = new TextBuffer(base16.charAt(this.cursorColour), this.width);
                this.backgroundColour[i] = new TextBuffer(base16.charAt(this.cursorBackgroundColour), this.width);
                continue;
            }
            if (this.width == oldWidth) {
                this.text[i] = oldText[i];
                this.textColour[i] = oldTextColour[i];
                this.backgroundColour[i] = oldBackgroundColour[i];
                continue;
            }
            this.text[i] = new TextBuffer(' ', this.width);
            this.textColour[i] = new TextBuffer(base16.charAt(this.cursorColour), this.width);
            this.backgroundColour[i] = new TextBuffer(base16.charAt(this.cursorBackgroundColour), this.width);
            this.text[i].write(oldText[i]);
            this.textColour[i].write(oldTextColour[i]);
            this.backgroundColour[i].write(oldBackgroundColour[i]);
        }
        this.setChanged();
    }

    public void setCursorPos(int x, int y) {
        if (this.cursorX != x || this.cursorY != y) {
            this.cursorX = x;
            this.cursorY = y;
            this.setChanged();
        }
    }

    public void setCursorBlink(boolean blink) {
        if (this.cursorBlink != blink) {
            this.cursorBlink = blink;
            this.setChanged();
        }
    }

    public void setTextColour(int colour) {
        if (this.cursorColour != colour) {
            this.cursorColour = colour;
            this.setChanged();
        }
    }

    public void setBackgroundColour(int colour) {
        if (this.cursorBackgroundColour != colour) {
            this.cursorBackgroundColour = colour;
            this.setChanged();
        }
    }

    public int getCursorX() {
        return this.cursorX;
    }

    public int getCursorY() {
        return this.cursorY;
    }

    public boolean getCursorBlink() {
        return this.cursorBlink;
    }

    public int getTextColour() {
        return this.cursorColour;
    }

    public int getBackgroundColour() {
        return this.cursorBackgroundColour;
    }

    @Nonnull
    public Palette getPalette() {
        return this.palette;
    }

    public synchronized void blit(String text, String textColour, String backgroundColour) {
        int x = this.cursorX;
        int y = this.cursorY;
        if (y >= 0 && y < this.height) {
            this.text[y].write(text, x);
            this.textColour[y].write(textColour, x);
            this.backgroundColour[y].write(backgroundColour, x);
            this.setChanged();
        }
    }

    public synchronized void write(String text) {
        int x = this.cursorX;
        int y = this.cursorY;
        if (y >= 0 && y < this.height) {
            this.text[y].write(text, x);
            this.textColour[y].fill(base16.charAt(this.cursorColour), x, x + text.length());
            this.backgroundColour[y].fill(base16.charAt(this.cursorBackgroundColour), x, x + text.length());
            this.setChanged();
        }
    }

    public synchronized void scroll(int yDiff) {
        if (yDiff != 0) {
            TextBuffer[] newText = new TextBuffer[this.height];
            TextBuffer[] newTextColour = new TextBuffer[this.height];
            TextBuffer[] newBackgroundColour = new TextBuffer[this.height];
            for (int y = 0; y < this.height; ++y) {
                int oldY = y + yDiff;
                if (oldY >= 0 && oldY < this.height) {
                    newText[y] = this.text[oldY];
                    newTextColour[y] = this.textColour[oldY];
                    newBackgroundColour[y] = this.backgroundColour[oldY];
                    continue;
                }
                newText[y] = new TextBuffer(' ', this.width);
                newTextColour[y] = new TextBuffer(base16.charAt(this.cursorColour), this.width);
                newBackgroundColour[y] = new TextBuffer(base16.charAt(this.cursorBackgroundColour), this.width);
            }
            this.text = newText;
            this.textColour = newTextColour;
            this.backgroundColour = newBackgroundColour;
            this.setChanged();
        }
    }

    public synchronized void clear() {
        for (int y = 0; y < this.height; ++y) {
            this.text[y].fill(' ');
            this.textColour[y].fill(base16.charAt(this.cursorColour));
            this.backgroundColour[y].fill(base16.charAt(this.cursorBackgroundColour));
        }
        this.setChanged();
    }

    public synchronized void clearLine() {
        int y = this.cursorY;
        if (y >= 0 && y < this.height) {
            this.text[y].fill(' ');
            this.textColour[y].fill(base16.charAt(this.cursorColour));
            this.backgroundColour[y].fill(base16.charAt(this.cursorBackgroundColour));
            this.setChanged();
        }
    }

    public synchronized TextBuffer getLine(int y) {
        if (y >= 0 && y < this.height) {
            return this.text[y];
        }
        return null;
    }

    public synchronized void setLine(int y, String text, String textColour, String backgroundColour) {
        this.text[y].write(text);
        this.textColour[y].write(textColour);
        this.backgroundColour[y].write(backgroundColour);
        this.setChanged();
    }

    public synchronized TextBuffer getTextColourLine(int y) {
        if (y >= 0 && y < this.height) {
            return this.textColour[y];
        }
        return null;
    }

    public synchronized TextBuffer getBackgroundColourLine(int y) {
        if (y >= 0 && y < this.height) {
            return this.backgroundColour[y];
        }
        return null;
    }

    public final void setChanged() {
        if (this.onChanged != null) {
            this.onChanged.run();
        }
    }

    public synchronized void write(PacketBuffer buffer) {
        buffer.writeInt(this.cursorX);
        buffer.writeInt(this.cursorY);
        buffer.writeBoolean(this.cursorBlink);
        buffer.writeByte(this.cursorBackgroundColour << 4 | this.cursorColour);
        for (int y = 0; y < this.height; ++y) {
            TextBuffer text = this.text[y];
            TextBuffer textColour = this.textColour[y];
            TextBuffer backColour = this.backgroundColour[y];
            for (int x = 0; x < this.width; ++x) {
                buffer.writeByte(text.charAt(x) & 0xFF);
                buffer.writeByte(Terminal.getColour(backColour.charAt(x), Colour.BLACK) << 4 | Terminal.getColour(textColour.charAt(x), Colour.WHITE));
            }
        }
        this.palette.write(buffer);
    }

    public synchronized void read(PacketBuffer buffer) {
        this.cursorX = buffer.readInt();
        this.cursorY = buffer.readInt();
        this.cursorBlink = buffer.readBoolean();
        byte cursorColour = buffer.readByte();
        this.cursorBackgroundColour = cursorColour >> 4 & 0xF;
        this.cursorColour = cursorColour & 0xF;
        for (int y = 0; y < this.height; ++y) {
            TextBuffer text = this.text[y];
            TextBuffer textColour = this.textColour[y];
            TextBuffer backColour = this.backgroundColour[y];
            for (int x = 0; x < this.width; ++x) {
                text.setChar(x, (char)(buffer.readByte() & 0xFF));
                byte colour = buffer.readByte();
                backColour.setChar(x, base16.charAt(colour >> 4 & 0xF));
                textColour.setChar(x, base16.charAt(colour & 0xF));
            }
        }
        this.palette.read(buffer);
        this.setChanged();
    }

    public synchronized CompoundNBT writeToNBT(CompoundNBT nbt) {
        nbt.func_74768_a("term_cursorX", this.cursorX);
        nbt.func_74768_a("term_cursorY", this.cursorY);
        nbt.func_74757_a("term_cursorBlink", this.cursorBlink);
        nbt.func_74768_a("term_textColour", this.cursorColour);
        nbt.func_74768_a("term_bgColour", this.cursorBackgroundColour);
        for (int n = 0; n < this.height; ++n) {
            nbt.func_74778_a("term_text_" + n, this.text[n].toString());
            nbt.func_74778_a("term_textColour_" + n, this.textColour[n].toString());
            nbt.func_74778_a("term_textBgColour_" + n, this.backgroundColour[n].toString());
        }
        this.palette.writeToNBT(nbt);
        return nbt;
    }

    public synchronized void readFromNBT(CompoundNBT nbt) {
        this.cursorX = nbt.func_74762_e("term_cursorX");
        this.cursorY = nbt.func_74762_e("term_cursorY");
        this.cursorBlink = nbt.func_74767_n("term_cursorBlink");
        this.cursorColour = nbt.func_74762_e("term_textColour");
        this.cursorBackgroundColour = nbt.func_74762_e("term_bgColour");
        for (int n = 0; n < this.height; ++n) {
            this.text[n].fill(' ');
            if (nbt.func_74764_b("term_text_" + n)) {
                this.text[n].write(nbt.func_74779_i("term_text_" + n));
            }
            this.textColour[n].fill(base16.charAt(this.cursorColour));
            if (nbt.func_74764_b("term_textColour_" + n)) {
                this.textColour[n].write(nbt.func_74779_i("term_textColour_" + n));
            }
            this.backgroundColour[n].fill(base16.charAt(this.cursorBackgroundColour));
            if (!nbt.func_74764_b("term_textBgColour_" + n)) continue;
            this.backgroundColour[n].write(nbt.func_74779_i("term_textBgColour_" + n));
        }
        this.palette.readFromNBT(nbt);
        this.setChanged();
    }

    public static int getColour(char c, Colour def) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return 15 - def.ordinal();
    }
}

