/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.event.TurtleBlockEvent;
import dan200.computercraft.shared.peripheral.generic.data.BlockData;
import dan200.computercraft.shared.turtle.core.InteractDirection;
import dan200.computercraft.shared.turtle.core.TurtlePlayer;
import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class TurtleInspectCommand
implements ITurtleCommand {
    private final InteractDirection direction;

    public TurtleInspectCommand(InteractDirection direction) {
        this.direction = direction;
    }

    @Override
    @Nonnull
    public TurtleCommandResult execute(@Nonnull ITurtleAccess turtle) {
        BlockPos oldPosition;
        BlockPos newPosition;
        Direction direction = this.direction.toWorldDir(turtle);
        World world = turtle.getWorld();
        BlockState state = world.func_180495_p(newPosition = (oldPosition = turtle.getPosition()).func_177972_a(direction));
        if (state.func_177230_c().isAir(state, (IBlockReader)world, newPosition)) {
            return TurtleCommandResult.failure("No block to inspect");
        }
        HashMap<String, Object> table = BlockData.fill(new HashMap(), state);
        TurtlePlayer turtlePlayer = TurtlePlayer.getWithPosition(turtle, oldPosition, direction);
        TurtleBlockEvent.Inspect event = new TurtleBlockEvent.Inspect(turtle, turtlePlayer, world, newPosition, state, table);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return TurtleCommandResult.failure(event.getFailureMessage());
        }
        return TurtleCommandResult.success(new Object[]{table});
    }
}

