/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.upgrades;

import dan200.computercraft.api.client.TransformedModel;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.AbstractTurtleUpgrade;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import dan200.computercraft.api.turtle.TurtleVerb;
import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.peripheral.modem.ModemState;
import dan200.computercraft.shared.peripheral.modem.wireless.WirelessModemPeripheral;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TurtleModem
extends AbstractTurtleUpgrade {
    private final boolean advanced;
    private final ModelResourceLocation leftOffModel;
    private final ModelResourceLocation rightOffModel;
    private final ModelResourceLocation leftOnModel;
    private final ModelResourceLocation rightOnModel;

    public TurtleModem(boolean advanced, ResourceLocation id) {
        super(id, TurtleUpgradeType.PERIPHERAL, (Supplier<? extends IItemProvider>)(advanced ? Registry.ModBlocks.WIRELESS_MODEM_ADVANCED : Registry.ModBlocks.WIRELESS_MODEM_NORMAL));
        this.advanced = advanced;
        if (advanced) {
            this.leftOffModel = new ModelResourceLocation("computercraft:turtle_modem_advanced_off_left", "inventory");
            this.rightOffModel = new ModelResourceLocation("computercraft:turtle_modem_advanced_off_right", "inventory");
            this.leftOnModel = new ModelResourceLocation("computercraft:turtle_modem_advanced_on_left", "inventory");
            this.rightOnModel = new ModelResourceLocation("computercraft:turtle_modem_advanced_on_right", "inventory");
        } else {
            this.leftOffModel = new ModelResourceLocation("computercraft:turtle_modem_normal_off_left", "inventory");
            this.rightOffModel = new ModelResourceLocation("computercraft:turtle_modem_normal_off_right", "inventory");
            this.leftOnModel = new ModelResourceLocation("computercraft:turtle_modem_normal_on_left", "inventory");
            this.rightOnModel = new ModelResourceLocation("computercraft:turtle_modem_normal_on_right", "inventory");
        }
    }

    @Override
    public IPeripheral createPeripheral(@Nonnull ITurtleAccess turtle, @Nonnull TurtleSide side) {
        return new Peripheral(turtle, this.advanced);
    }

    @Override
    @Nonnull
    public TurtleCommandResult useTool(@Nonnull ITurtleAccess turtle, @Nonnull TurtleSide side, @Nonnull TurtleVerb verb, @Nonnull Direction dir) {
        return TurtleCommandResult.failure();
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public TransformedModel getModel(ITurtleAccess turtle, @Nonnull TurtleSide side) {
        boolean active = false;
        if (turtle != null) {
            CompoundNBT turtleNBT = turtle.getUpgradeNBTData(side);
            boolean bl = active = turtleNBT.func_74764_b("active") && turtleNBT.func_74767_n("active");
        }
        return side == TurtleSide.LEFT ? TransformedModel.of(active ? this.leftOnModel : this.leftOffModel) : TransformedModel.of(active ? this.rightOnModel : this.rightOffModel);
    }

    @Override
    public void update(@Nonnull ITurtleAccess turtle, @Nonnull TurtleSide side) {
        ModemState state;
        IPeripheral peripheral;
        if (!turtle.getWorld().field_72995_K && (peripheral = turtle.getPeripheral(side)) instanceof Peripheral && (state = ((Peripheral)peripheral).getModemState()).pollChanged()) {
            turtle.getUpgradeNBTData(side).func_74757_a("active", state.isOpen());
            turtle.updateUpgradeNBTData(side);
        }
    }

    private static class Peripheral
    extends WirelessModemPeripheral {
        private final ITurtleAccess turtle;

        Peripheral(ITurtleAccess turtle, boolean advanced) {
            super(new ModemState(), advanced);
            this.turtle = turtle;
        }

        @Override
        @Nonnull
        public World getWorld() {
            return this.turtle.getWorld();
        }

        @Override
        @Nonnull
        public Vector3d getPosition() {
            BlockPos turtlePos = this.turtle.getPosition();
            return new Vector3d((double)turtlePos.func_177958_n(), (double)turtlePos.func_177956_o(), (double)turtlePos.func_177952_p());
        }

        @Override
        public boolean equals(IPeripheral other) {
            return this == other || other instanceof Peripheral && ((Peripheral)other).turtle == this.turtle;
        }
    }
}

