/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.upgrade_aquatic.common.blocks.coralstone;

import com.minecraftabnormals.upgrade_aquatic.common.blocks.coralstone.CoralstoneBlock;
import com.minecraftabnormals.upgrade_aquatic.core.registry.UABlocks;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CoralWallFanBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.SlabType;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class CoralstoneSlabBlock
extends SlabBlock {
    public static final BooleanProperty POWERED = BooleanProperty.func_177716_a((String)"powered");
    @Nullable
    private final Block[] growableCoralBlocks;

    public CoralstoneSlabBlock(AbstractBlock.Properties properties, @Nullable Block[] growableCoralBlocks) {
        super(properties);
        this.growableCoralBlocks = growableCoralBlocks;
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_196505_a, (Comparable)SlabType.BOTTOM)).func_206870_a((Property)field_204512_b, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (!worldIn.isAreaLoaded(pos, 3)) {
            return;
        }
        Block block = state.func_177230_c();
        if (this.growableCoralBlocks == null && block != UABlocks.DEAD_CORALSTONE_SLAB.get()) {
            CoralstoneBlock.tickConversion(UABlocks.CORALSTONE_SLAB_CONVERSION_MAP, state, worldIn, pos, random);
        }
        if (this.growableCoralBlocks != null && random.nextFloat() < 0.12f && ((Boolean)state.func_177229_b((Property)POWERED)).booleanValue()) {
            Direction randDirection = this.growableCoralBlocks.length > 3 ? Direction.func_239631_a_((Random)random) : Direction.func_82600_a((int)(random.nextInt(5) + 1));
            BlockPos growPos = pos.func_177972_a(randDirection);
            FluidState fluidState = worldIn.func_180495_p(growPos).func_204520_s();
            if (state.func_177229_b((Property)field_196505_a) == SlabType.BOTTOM) {
                if (this.isValidPosToGrow((World)worldIn, pos.func_177972_a(Direction.DOWN), fluidState) && this.growableCoralBlocks.length > 3) {
                    worldIn.func_180501_a(pos.func_177972_a(Direction.DOWN), this.growableCoralBlocks[3].func_176223_P(), 2);
                }
            } else if (state.func_177229_b((Property)field_196505_a) == SlabType.TOP) {
                if (this.isValidPosToGrow((World)worldIn, pos.func_177972_a(Direction.UP), fluidState)) {
                    if (random.nextBoolean()) {
                        worldIn.func_180501_a(pos.func_177972_a(Direction.UP), this.growableCoralBlocks[0].func_176223_P(), 2);
                    } else {
                        worldIn.func_180501_a(pos.func_177972_a(Direction.UP), this.growableCoralBlocks[1].func_176223_P(), 2);
                    }
                }
            } else if (state.func_177229_b((Property)field_196505_a) == SlabType.DOUBLE && this.isValidPosToGrow((World)worldIn, growPos, fluidState)) {
                if (randDirection.func_176745_a() > 1) {
                    worldIn.func_180501_a(growPos, (BlockState)this.growableCoralBlocks[2].func_176223_P().func_206870_a((Property)CoralWallFanBlock.field_211884_b, (Comparable)randDirection), 2);
                } else if (randDirection.func_176745_a() == 1) {
                    if (random.nextBoolean()) {
                        worldIn.func_180501_a(growPos, this.growableCoralBlocks[1].func_176223_P(), 2);
                    } else {
                        worldIn.func_180501_a(growPos, this.growableCoralBlocks[0].func_176223_P(), 2);
                    }
                } else {
                    worldIn.func_180501_a(growPos, this.growableCoralBlocks[3].func_176223_P(), 2);
                }
            }
        }
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean flag;
        if (!worldIn.field_72995_K && (flag = ((Boolean)state.func_177229_b((Property)POWERED)).booleanValue()) != worldIn.func_175640_z(pos)) {
            worldIn.func_180501_a(pos, (BlockState)state.func_235896_a_((Property)POWERED), 2);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == Items.field_151097_aZ && state.func_177230_c() != UABlocks.CORALSTONE_SLAB.get()) {
            BlockState newState = ((Block)UABlocks.CORALSTONE_SLAB.get()).func_176223_P();
            world.func_184133_a(null, pos, SoundEvents.field_187784_dt, SoundCategory.PLAYERS, 1.0f, 0.8f);
            stack.func_222118_a(1, (LivingEntity)player, entity -> entity.func_213334_d(hand));
            world.func_180501_a(pos, (BlockState)((BlockState)newState.func_206870_a((Property)field_196505_a, state.func_177229_b((Property)field_196505_a))).func_206870_a((Property)field_204512_b, state.func_177229_b((Property)field_204512_b)), 2);
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, world, pos, player, hand, hit);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)super.func_196258_a(context).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(context.func_195991_k().func_175640_z(context.func_195995_a())));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_196505_a, field_204512_b, POWERED});
    }

    private boolean isValidPosToGrow(World world, BlockPos pos, FluidState fluidState) {
        return world.func_180495_p(pos).func_185904_a().func_76222_j() && fluidState.func_206882_g() >= 8 && fluidState.func_206884_a((ITag)FluidTags.field_206959_a);
    }
}

