/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.building.block;

import javax.annotation.Nullable;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.IHidable;
import knightminer.inspirations.library.Util;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoorBlock;
import net.minecraft.entity.MobEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoorHingeSide;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;

public class GlassDoorBlock
extends DoorBlock
implements IHidable {
    private static final VoxelShape[] SHAPES = new VoxelShape[16];

    public GlassDoorBlock(AbstractBlock.Properties props) {
        super(props);
    }

    @Nullable
    public PathNodeType getAiPathNodeType(BlockState state, IBlockReader world, BlockPos pos, @Nullable MobEntity entity) {
        return (Boolean)state.func_177229_b((Property)field_176519_b) != false ? PathNodeType.DOOR_WOOD_CLOSED : PathNodeType.DOOR_WOOD_CLOSED;
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)Config.enableGlassDoor.get();
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.shouldAddtoItemGroup(group)) {
            super.func_149666_a(group, items);
        }
    }

    @Deprecated
    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return super.func_220053_a(state, worldIn, pos, context);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        boolean flipped;
        Direction direction = (Direction)state.func_177229_b((Property)field_176520_a);
        boolean bl = flipped = state.func_177229_b((Property)field_176521_M) == DoorHingeSide.RIGHT;
        if (((Boolean)state.func_177229_b((Property)field_176519_b)).booleanValue()) {
            direction = flipped ? direction.func_176735_f() : direction.func_176746_e();
            flipped = !flipped;
        }
        int half = state.func_177229_b((Property)field_176523_O) == DoubleBlockHalf.UPPER ? 8 : 0;
        return SHAPES[direction.func_176736_b() | half | (flipped ? 4 : 0)];
    }

    static {
        for (boolean onTop : new boolean[]{false, true}) {
            for (Direction yaw : Direction.Plane.HORIZONTAL) {
                int ind = (onTop ? 8 : 0) | yaw.func_176736_b();
                VoxelShape door = Util.makeRotatedShape(yaw, 0, 0, 0, 16, 16, 3);
                int z1 = onTop ? 0 : 6;
                int z2 = onTop ? 9 : 16;
                VoxelShape handleL = Util.makeRotatedShape(yaw, 4, z1, -2, 5, z2, 5);
                VoxelShape handleR = Util.makeRotatedShape(yaw, 11, z1, -2, 12, z2, 5);
                GlassDoorBlock.SHAPES[ind] = VoxelShapes.func_197872_a((VoxelShape)door, (VoxelShape)handleL);
                GlassDoorBlock.SHAPES[ind | 4] = VoxelShapes.func_197872_a((VoxelShape)door, (VoxelShape)handleR);
            }
        }
    }
}

