/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.building.tileentity;

import knightminer.inspirations.building.tileentity.ShelfTileEntity;
import knightminer.inspirations.library.InspirationsRegistry;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class ShelfInventory
implements IItemHandler,
IItemHandlerModifiable,
INBTSerializable<ListNBT> {
    public static final int MAX_ITEMS = 16;
    private final ShelfTileEntity parent;
    private final NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)16, (Object)ItemStack.field_190927_a);
    private static final String SLOT_TAG = "Slot";

    public ShelfInventory(ShelfTileEntity parent) {
        this.parent = parent;
    }

    private void onSlotChanged(int slot, ItemStack oldStack) {
        this.parent.onSlotChanged(slot, oldStack, (ItemStack)this.stacks.get(slot));
    }

    public int getSlots() {
        return 16;
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return true;
    }

    private boolean isSlotValid(int slot) {
        return slot >= 0 && slot < 16;
    }

    public boolean canHoldItem(int slot, ItemStack stack) {
        ItemStack previous;
        if (!this.isSlotValid(slot) || stack.func_190926_b()) {
            return false;
        }
        if (slot != 0 && slot != 8 && !(previous = (ItemStack)this.stacks.get(slot - 1)).func_190926_b() && !InspirationsRegistry.isBook(previous)) {
            return false;
        }
        if (InspirationsRegistry.isBook(stack)) {
            return true;
        }
        if (slot == 7 || slot == 15) {
            return false;
        }
        return ((ItemStack)this.stacks.get(slot + 1)).func_190926_b();
    }

    public boolean canInsertItem(int slot, ItemStack stack) {
        return this.canHoldItem(slot, stack) && ((ItemStack)this.stacks.get(slot)).func_190926_b();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.isSlotValid(slot) ? (ItemStack)this.stacks.get(slot) : ItemStack.field_190927_a;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        if (stack.func_190926_b() || this.canHoldItem(slot, stack)) {
            ItemStack oldStack = (ItemStack)this.stacks.get(slot);
            this.stacks.set(slot, (Object)stack);
            this.onSlotChanged(slot, oldStack);
        }
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (!this.canInsertItem(slot, stack)) {
            return stack;
        }
        ItemStack result = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - 1));
        if (!simulate) {
            this.setStackInSlot(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
        }
        return result;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount <= 0 || !this.isSlotValid(slot)) {
            return ItemStack.field_190927_a;
        }
        ItemStack current = (ItemStack)this.stacks.get(slot);
        if (current.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack result = ItemHandlerHelper.copyStackWithSize((ItemStack)current, (int)1);
        if (!simulate) {
            this.setStackInSlot(slot, ItemStack.field_190927_a);
        }
        return result;
    }

    public ListNBT serializeNBT() {
        ListNBT list = new ListNBT();
        for (int i = 0; i < 16; ++i) {
            ItemStack stack = (ItemStack)this.stacks.get(i);
            if (stack.func_190926_b()) continue;
            CompoundNBT itemTag = new CompoundNBT();
            itemTag.func_74774_a(SLOT_TAG, (byte)i);
            stack.func_77955_b(itemTag);
            list.add((Object)itemTag);
        }
        return list;
    }

    public void deserializeNBT(ListNBT list) {
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT itemNBT = list.func_150305_b(i);
            int slot = itemNBT.func_74771_c(SLOT_TAG) & 0xFF;
            if (!this.isSlotValid(slot)) continue;
            this.stacks.set(slot, (Object)ItemStack.func_199557_a((CompoundNBT)itemNBT));
        }
    }
}

