/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import knightminer.inspirations.library.InspirationsRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.DyeColor;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;

public class Util {
    private static final String TAG_DISPLAY = "display";
    private static final String TAG_COLOR = "color";
    private static final ItemStack silkTouchItem = new ItemStack((IItemProvider)Items.field_151055_y);

    public static VoxelShape makeRotatedShape(Direction side, int x1, int y1, int z1, int x2, int y2, int z2) {
        float yaw = -1.5707964f * (float)side.func_176736_b();
        Vector3d min = new Vector3d((double)(x1 - 8), (double)(y1 - 8), (double)(z1 - 8)).func_178785_b(yaw);
        Vector3d max = new Vector3d((double)(x2 - 8), (double)(y2 - 8), (double)(z2 - 8)).func_178785_b(yaw);
        return VoxelShapes.func_197873_a((double)(0.5 + min.field_72450_a / 16.0), (double)(0.5 + min.field_72448_b / 16.0), (double)(0.5 + min.field_72449_c / 16.0), (double)(0.5 + max.field_72450_a / 16.0), (double)(0.5 + max.field_72448_b / 16.0), (double)(0.5 + max.field_72449_c / 16.0));
    }

    public static ItemStack getStackFromState(ServerWorld world, @Nullable BlockState state) {
        if (state == null) {
            return ItemStack.field_190927_a;
        }
        Block block = state.func_177230_c();
        if (block == Blocks.field_150350_a) {
            return ItemStack.field_190927_a;
        }
        List drops = state.func_215693_a(new LootContext.Builder(world).func_216015_a(LootParameters.field_237457_g_, (Object)new Vector3d(0.5, 64.0, 0.5)).func_216015_a(LootParameters.field_216289_i, (Object)silkTouchItem));
        if (drops.size() > 0) {
            return (ItemStack)drops.get(0);
        }
        InspirationsRegistry.log.error("Failed to get silk touch drop for {}, using fallback", (Object)state);
        Item item = Item.func_150898_a((Block)block);
        if (item == Items.field_190931_a) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack((IItemProvider)item);
    }

    @SafeVarargs
    @Deprecated
    public static <E> NonNullList<E> createNonNullList(E ... elements) {
        NonNullList list = NonNullList.func_191196_a();
        list.addAll(Arrays.asList(elements));
        return list;
    }

    public static int combineColors(int color1, int color2, int scale) {
        if (scale == 0) {
            return color1;
        }
        int a = color1 >> 24 & 0xFF;
        int r = color1 >> 16 & 0xFF;
        int g = color1 >> 8 & 0xFF;
        int b = color1 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        for (int i = 0; i < scale; ++i) {
            a = (int)Math.sqrt(a * a2);
            r = (int)Math.sqrt(r * r2);
            g = (int)Math.sqrt(g * g2);
            b = (int)Math.sqrt(b * b2);
        }
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int getColorInteger(float[] component) {
        return ((int)(component[0] * 255.0f) & 0xFF) << 16 | ((int)(component[1] * 255.0f) & 0xFF) << 8 | (int)(component[2] * 255.0f) & 0xFF;
    }

    @Nullable
    public static DyeColor getDyeForColor(int color) {
        for (DyeColor dyeColor : DyeColor.values()) {
            if (dyeColor.getColorValue() != color) continue;
            return dyeColor;
        }
        return null;
    }

    public static int getColor(ItemStack stack) {
        CompoundNBT display;
        Item item = stack.func_77973_b();
        if (item instanceof IDyeableArmorItem) {
            return ((IDyeableArmorItem)item).func_200886_f(stack);
        }
        CompoundNBT tags = stack.func_77978_p();
        if (tags != null && (display = tags.func_74775_l(TAG_DISPLAY)).func_150297_b(TAG_COLOR, 3)) {
            return display.func_74762_e(TAG_COLOR);
        }
        return -1;
    }

    public static boolean hasColor(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof IDyeableArmorItem) {
            return ((IDyeableArmorItem)item).func_200883_f_(stack);
        }
        CompoundNBT tags = stack.func_179543_a(TAG_COLOR);
        return tags != null && tags.func_150297_b(TAG_COLOR, 99);
    }

    public static ItemStack setColor(ItemStack stack, int color) {
        Item item = stack.func_77973_b();
        if (item instanceof IDyeableArmorItem) {
            ((IDyeableArmorItem)item).func_200885_a(stack, color);
        } else {
            stack.func_190925_c(TAG_DISPLAY).func_74768_a(TAG_COLOR, color);
        }
        return stack;
    }

    public static ItemStack clearColor(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof IDyeableArmorItem) {
            ((IDyeableArmorItem)item).func_200884_g(stack);
        } else {
            CompoundNBT displayTag = stack.func_179543_a(TAG_DISPLAY);
            if (displayTag != null && displayTag.func_74764_b(TAG_COLOR)) {
                displayTag.func_82580_o(TAG_COLOR);
            }
        }
        return stack;
    }

    public static Item deserializeItem(JsonObject parent, String key) {
        String name = JSONUtils.func_151200_h((JsonObject)parent, (String)key);
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(name));
        if (item == null) {
            throw new JsonSyntaxException("Invalid " + key + ": Unknown item " + name + "'");
        }
        return item;
    }

    public static void notifyClientUpdate(TileEntity te) {
        World world = te.func_145831_w();
        if (world != null && world.field_72995_K) {
            te.requestModelDataUpdate();
            BlockState state = te.func_195044_w();
            world.func_184138_a(te.func_174877_v(), state, state, 36);
        }
    }

    static {
        silkTouchItem.func_77966_a(Enchantments.field_185306_r, 1);
    }
}

