/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.client;

import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.library.InspirationsRegistry;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.resource.VanillaResourceType;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.text.WordUtils;

public final class ClientUtil {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final Map<Item, Integer> COLOR_CACHE = new HashMap<Item, Integer>();
    private static final Set<Item> UNSAFE_COLORS = new HashSet<Item>();
    private static final Map<String, String> NORMALIZED_NAMES = new HashMap<String, String>();
    public static final ISelectiveResourceReloadListener RELOAD_LISTENER = (manager, predicate) -> {
        if (predicate.test(VanillaResourceType.MODELS) || predicate.test(VanillaResourceType.TEXTURES)) {
            COLOR_CACHE.clear();
        }
    };

    private ClientUtil() {
    }

    public static int getItemColor(Item item) {
        return COLOR_CACHE.computeIfAbsent(item, ClientUtil::getItemColorRaw);
    }

    private static Integer getItemColorRaw(Item key) {
        IBakedModel model = mc.func_175599_af().func_184393_a(new ItemStack((IItemProvider)key), null, null);
        if (model == mc.func_209506_al().func_174951_a()) {
            return -1;
        }
        TextureAtlasSprite sprite = model.getParticleTexture((IModelData)EmptyModelData.INSTANCE);
        if (sprite == null) {
            return -1;
        }
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        float count = 0.0f;
        float[] hsb = new float[3];
        try {
            for (int x = 0; x < sprite.func_94211_a(); ++x) {
                for (int y = 0; y < sprite.func_94216_b(); ++y) {
                    int argb = sprite.getPixelRGBA(0, x, y);
                    int cr = argb & 0xFF;
                    int cg = argb >> 8 & 0xFF;
                    int cb = argb >> 16 & 0xFF;
                    int ca = argb >> 24 & 0xFF;
                    if (ca <= 127 || NumberUtils.max((int)cr, (int)cg, (int)cb) <= 31) continue;
                    Color.RGBtoHSB(ca, cr, cg, hsb);
                    float weight = hsb[1];
                    r += (float)cr * weight;
                    g += (float)cg * weight;
                    b += (float)cb * weight;
                    count += weight;
                }
            }
        }
        catch (Exception e) {
            InspirationsRegistry.log.error("Caught exception reading sprite for " + key.getRegistryName(), (Throwable)e);
            return -1;
        }
        if (count > 0.0f) {
            r /= count;
            g /= count;
            b /= count;
        }
        return 0xFF000000 | (int)r << 16 | (int)g << 8 | (int)b;
    }

    public static TextureAtlasSprite getSprite(@Nullable ResourceLocation location) {
        AtlasTexture atlas = mc.func_209506_al().func_229356_a_(PlayerContainer.field_226615_c_);
        if (location == null) {
            return atlas.func_195424_a(MissingTextureSprite.func_195675_b());
        }
        return atlas.func_195424_a(location);
    }

    public static void renderFilledSprite(TextureAtlasSprite sprite, int x, int y, int size, int filled) {
        float uMin = sprite.func_94209_e();
        float uMax = sprite.func_94212_f();
        float vMin = sprite.func_94206_g();
        float vMax = sprite.func_94210_h();
        uMax -= (float)(16 - size) / 16.0f * (uMax - uMin);
        vMax -= (float)(16 - filled) / 16.0f * (vMax - vMin);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferBuilder.func_225582_a_((double)x, (double)(y + size), 100.0).func_225583_a_(uMin, vMax).func_181675_d();
        bufferBuilder.func_225582_a_((double)(x + size), (double)(y + size), 100.0).func_225583_a_(uMax, vMax).func_181675_d();
        bufferBuilder.func_225582_a_((double)(x + size), (double)(y + size - filled), 100.0).func_225583_a_(uMax, vMin).func_181675_d();
        bufferBuilder.func_225582_a_((double)x, (double)(y + size - filled), 100.0).func_225583_a_(uMin, vMin).func_181675_d();
        tessellator.func_78381_a();
    }

    public static int getStackBlockColorsSafe(ItemStack stack, @Nullable IBlockDisplayReader world, @Nullable BlockPos pos, int index) {
        if (stack.func_190926_b()) {
            return -1;
        }
        Item item = stack.func_77973_b();
        if (!UNSAFE_COLORS.contains(item)) {
            try {
                return ClientUtil.getStackBlockColors(stack, world, pos, index);
            }
            catch (Exception e) {
                Inspirations.log.error(String.format("Caught exception getting block colors for %s", item.getRegistryName()), (Throwable)e);
                UNSAFE_COLORS.add(item);
            }
        }
        return mc.getItemColors().func_186728_a(stack, index);
    }

    public static int getStackBlockColors(ItemStack stack, @Nullable IBlockDisplayReader world, @Nullable BlockPos pos, int index) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof BlockItem)) {
            return -1;
        }
        BlockItem item = (BlockItem)stack.func_77973_b();
        BlockState state = item.func_179223_d().func_176223_P();
        return mc.func_184125_al().func_228054_a_(state, world, pos, index);
    }

    public static String normalizeName(String name) {
        return NORMALIZED_NAMES.computeIfAbsent(name, s -> WordUtils.capitalizeFully((String)name.replace('_', ' ')));
    }
}

