/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.recipe.cauldron.contents;

import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import io.netty.handler.codec.DecoderException;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import knightminer.inspirations.library.recipe.cauldron.contents.CauldronContentType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class RegistryContentType<T extends IForgeRegistryEntry<T>>
extends CauldronContentType<T> {
    private final IForgeRegistry<T> registry;

    public RegistryContentType(IForgeRegistry<T> registry) {
        this.registry = registry;
    }

    @Override
    public String getName(T value) {
        return Objects.requireNonNull(value.getRegistryName()).toString();
    }

    @Override
    public String getModId(T value) {
        return Objects.requireNonNull(value.getRegistryName()).func_110624_b();
    }

    @Nullable
    private T getValue(ResourceLocation name) {
        if (this.registry.containsKey(name)) {
            return (T)this.registry.getValue(name);
        }
        return null;
    }

    private T getValue(ResourceLocation name, Function<String, RuntimeException> exception) {
        T value = this.getValue(name);
        if (value != null) {
            return value;
        }
        throw exception.apply("Invalid value '" + name + "' for registry " + this.registry.getRegistryName());
    }

    @Override
    public T getValue(JsonElement element, String key) {
        return this.getValue(new ResourceLocation(JSONUtils.func_151206_a((JsonElement)element, (String)key)), JsonSyntaxException::new);
    }

    @Override
    @Nullable
    public T read(CompoundNBT tag) {
        if (tag.func_150297_b(this.getKey(), 8)) {
            return this.getValue(new ResourceLocation(tag.func_74779_i(this.getKey())));
        }
        return null;
    }

    @Override
    public T read(PacketBuffer buffer) {
        return this.getValue(buffer.func_192575_l(), DecoderException::new);
    }

    @Override
    public void write(T value, PacketBuffer buffer) {
        buffer.func_192572_a(Objects.requireNonNull(value.getRegistryName()));
    }
}

