/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.recipe.cauldron.ingredient;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import knightminer.inspirations.library.recipe.cauldron.CauldronContentTypes;
import knightminer.inspirations.library.recipe.cauldron.CauldronIngredients;
import knightminer.inspirations.library.recipe.cauldron.contents.ICauldronContents;
import knightminer.inspirations.library.recipe.cauldron.ingredient.ContentMatchIngredient;
import net.minecraft.fluid.Fluid;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class FluidCauldronIngredient
extends ContentMatchIngredient<Fluid> {
    private final ITag<Fluid> tag;
    private List<ICauldronContents> displayValues;

    private FluidCauldronIngredient(ITag<Fluid> tag) {
        super(CauldronIngredients.FLUID);
        this.tag = tag;
    }

    @Override
    protected boolean testValue(Fluid value) {
        return this.tag.func_230235_a_((Object)value);
    }

    @Override
    protected void write(JsonObject json) {
        json.addProperty("tag", TagCollectionManager.func_242178_a().func_241837_c().func_232975_b_(this.tag).toString());
    }

    @Override
    protected void write(PacketBuffer buffer) {
        List elements = this.tag.func_230236_b_();
        buffer.func_150787_b(elements.size());
        for (Fluid fluid : elements) {
            buffer.func_192572_a(Objects.requireNonNull(fluid.getRegistryName()));
        }
    }

    @Override
    public List<ICauldronContents> getMatchingContents() {
        if (this.displayValues == null) {
            this.displayValues = this.tag.func_230236_b_().stream().map(CauldronContentTypes.FLUID::of).collect(Collectors.toList());
        }
        return this.displayValues;
    }

    public static class Serializer
    extends ContentMatchIngredient.Serializer<Fluid> {
        public Serializer() {
            super(CauldronContentTypes.FLUID);
        }

        @Override
        public ContentMatchIngredient<Fluid> of(ITag<Fluid> tag) {
            return new FluidCauldronIngredient(tag);
        }

        @Override
        public ContentMatchIngredient<Fluid> read(JsonObject json) {
            if (json.has("name")) {
                return super.read(json);
            }
            if (json.has("tag")) {
                ResourceLocation tagName = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"tag"));
                ITag tag = TagCollectionManager.func_242178_a().func_241837_c().func_199910_a(tagName);
                if (tag == null) {
                    throw new JsonSyntaxException("Unknown fluid tag '" + tagName + "'");
                }
                return this.of((ITag<Fluid>)tag);
            }
            throw new JsonSyntaxException("Invalid cauldron fluid ingredient, must have 'name' or 'tag");
        }
    }
}

