/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.recipe.cauldron.special;

import com.google.gson.JsonObject;
import java.util.Objects;
import javax.annotation.Nullable;
import knightminer.inspirations.library.Util;
import knightminer.inspirations.library.recipe.DynamicFinishedRecipe;
import knightminer.inspirations.library.recipe.RecipeSerializer;
import knightminer.inspirations.library.recipe.RecipeSerializers;
import knightminer.inspirations.library.recipe.cauldron.CauldronContentTypes;
import knightminer.inspirations.library.recipe.cauldron.inventory.ICauldronInventory;
import knightminer.inspirations.library.recipe.cauldron.inventory.IModifyableCauldronInventory;
import knightminer.inspirations.library.recipe.cauldron.recipe.ICauldronRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import slimeknights.mantle.recipe.RecipeHelper;

public class EmptyPotionCauldronRecipe
implements ICauldronRecipe {
    private final ResourceLocation id;
    private final Item potionItem;
    private final Item bottle;

    public EmptyPotionCauldronRecipe(ResourceLocation id, Item potion, Item bottle) {
        this.id = id;
        this.potionItem = potion;
        this.bottle = bottle;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean matches(ICauldronInventory inv, World worldIn) {
        if (inv.getLevel() == 12) {
            return false;
        }
        ItemStack stack = inv.getStack();
        if (stack.func_77973_b() != this.potionItem) {
            return false;
        }
        Potion potion = PotionUtils.func_185191_c((ItemStack)stack);
        if (potion == Potions.field_185229_a) {
            return false;
        }
        if (inv.getLevel() == 0) return true;
        if (inv.getContents().get(CauldronContentTypes.POTION).map(potion::equals).orElse(false) == false) return false;
        return true;
    }

    @Override
    public void handleRecipe(IModifyableCauldronInventory inv) {
        Potion potion = PotionUtils.func_185191_c((ItemStack)inv.getStack());
        if (potion != Potions.field_185229_a) {
            inv.addLevel(4);
            inv.setContents(CauldronContentTypes.POTION.of(potion));
            inv.shrinkStack(1);
            inv.setOrGiveStack(new ItemStack((IItemProvider)this.bottle));
            inv.playSound(SoundEvents.field_191241_J);
        }
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return RecipeSerializers.CAULDRON_EMPTY_POTION;
    }

    public static class FinishedRecipe
    extends DynamicFinishedRecipe {
        private final Item potionItem;
        private final Item bottle;

        public FinishedRecipe(ResourceLocation id, Item potionItem, Item bottle) {
            super(id, RecipeSerializers.CAULDRON_EMPTY_POTION);
            this.potionItem = potionItem;
            this.bottle = bottle;
        }

        @Override
        public void func_218610_a(JsonObject json) {
            json.addProperty("potion", Objects.requireNonNull(this.potionItem.getRegistryName()).toString());
            json.addProperty("bottle", Objects.requireNonNull(this.bottle.getRegistryName()).toString());
        }
    }

    public static class Serializer
    extends RecipeSerializer<EmptyPotionCauldronRecipe> {
        public EmptyPotionCauldronRecipe read(ResourceLocation id, JsonObject json) {
            Item potion = Util.deserializeItem(json, "potion");
            Item bottle = Util.deserializeItem(json, "bottle");
            return new EmptyPotionCauldronRecipe(id, potion, bottle);
        }

        @Nullable
        public EmptyPotionCauldronRecipe read(ResourceLocation id, PacketBuffer buffer) {
            Item potion = RecipeHelper.readItem((PacketBuffer)buffer);
            Item bottle = RecipeHelper.readItem((PacketBuffer)buffer);
            return new EmptyPotionCauldronRecipe(id, potion, bottle);
        }

        public void write(PacketBuffer buffer, EmptyPotionCauldronRecipe recipe) {
            RecipeHelper.writeItem((PacketBuffer)buffer, (IItemProvider)recipe.potionItem);
            RecipeHelper.writeItem((PacketBuffer)buffer, (IItemProvider)recipe.bottle);
        }
    }
}

