/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.recipe.cauldron.special;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import javax.annotation.Nullable;
import knightminer.inspirations.library.Util;
import knightminer.inspirations.library.recipe.DynamicFinishedRecipe;
import knightminer.inspirations.library.recipe.RecipeSerializer;
import knightminer.inspirations.library.recipe.RecipeSerializers;
import knightminer.inspirations.library.recipe.cauldron.CauldronContentTypes;
import knightminer.inspirations.library.recipe.cauldron.inventory.ICauldronInventory;
import knightminer.inspirations.library.recipe.cauldron.inventory.IModifyableCauldronInventory;
import knightminer.inspirations.library.recipe.cauldron.recipe.ICauldronRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import slimeknights.mantle.recipe.RecipeHelper;
import slimeknights.mantle.recipe.SizedIngredient;

public class FillPotionCauldronRecipe
implements ICauldronRecipe {
    private final ResourceLocation id;
    private final SizedIngredient bottle;
    private final Item potionItem;

    public FillPotionCauldronRecipe(ResourceLocation id, SizedIngredient bottle, Item potionItem) {
        this.id = id;
        this.potionItem = potionItem;
        this.bottle = bottle;
    }

    public boolean matches(ICauldronInventory inv, World world) {
        return inv.getLevel() >= 4 && inv.getContents().contains(CauldronContentTypes.POTION) && this.bottle.test(inv.getStack());
    }

    @Override
    public void handleRecipe(IModifyableCauldronInventory inv) {
        inv.getContents().get(CauldronContentTypes.POTION).ifPresent(potion -> {
            int amount = this.bottle.getAmountNeeded();
            inv.shrinkStack(amount);
            inv.setOrGiveStack(PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)this.potionItem, amount), (Potion)potion));
            inv.addLevel(-4);
            inv.playSound(SoundEvents.field_187615_H);
        });
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return RecipeSerializers.CAULDRON_FILL_POTION;
    }

    public static class FinishedRecipe
    extends DynamicFinishedRecipe {
        private final SizedIngredient bottle;
        private final Item potionItem;

        public FinishedRecipe(ResourceLocation id, SizedIngredient bottle, Item potionItem) {
            super(id, RecipeSerializers.CAULDRON_FILL_POTION);
            this.bottle = bottle;
            this.potionItem = potionItem;
        }

        @Override
        public void func_218610_a(JsonObject json) {
            json.add("bottle", (JsonElement)this.bottle.serialize());
            json.addProperty("potion", Objects.requireNonNull(this.potionItem.getRegistryName()).toString());
        }
    }

    public static class Serializer
    extends RecipeSerializer<FillPotionCauldronRecipe> {
        public FillPotionCauldronRecipe read(ResourceLocation id, JsonObject json) {
            SizedIngredient bottle = SizedIngredient.deserialize((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"bottle"));
            Item potion = Util.deserializeItem(json, "potion");
            return new FillPotionCauldronRecipe(id, bottle, potion);
        }

        @Nullable
        public FillPotionCauldronRecipe read(ResourceLocation id, PacketBuffer buffer) {
            SizedIngredient bottle = SizedIngredient.read((PacketBuffer)buffer);
            Item potion = RecipeHelper.readItem((PacketBuffer)buffer);
            return new FillPotionCauldronRecipe(id, bottle, potion);
        }

        public void write(PacketBuffer buffer, FillPotionCauldronRecipe recipe) {
            recipe.bottle.write(buffer);
            RecipeHelper.writeItem((PacketBuffer)buffer, (IItemProvider)recipe.potionItem);
        }
    }
}

