/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.plugins.jei.cauldron;

import javax.annotation.Nullable;
import knightminer.inspirations.library.recipe.cauldron.CauldronContentTypes;
import knightminer.inspirations.library.recipe.cauldron.contents.CauldronContentType;
import knightminer.inspirations.library.recipe.cauldron.contents.ICauldronContents;
import mezz.jei.api.ingredients.IIngredientHelper;

public class CauldronContentHelper
implements IIngredientHelper<ICauldronContents> {
    public static final CauldronContentHelper INSTANCE = new CauldronContentHelper();

    private CauldronContentHelper() {
    }

    private static CauldronContentType<?> getType(ICauldronContents contents) {
        CauldronContentType<?> type = contents.getType();
        if (type == CauldronContentTypes.UNFERMENTED_POTION) {
            return CauldronContentTypes.POTION;
        }
        return type;
    }

    @Nullable
    public ICauldronContents getMatch(Iterable<ICauldronContents> options, ICauldronContents match) {
        CauldronContentType<?> type = CauldronContentHelper.getType(match);
        String name = match.getName();
        for (ICauldronContents content : options) {
            if (type != CauldronContentHelper.getType(content) || !name.equals(content.getName())) continue;
            return content;
        }
        return null;
    }

    public ICauldronContents copyIngredient(ICauldronContents contents) {
        return contents;
    }

    public String getDisplayName(ICauldronContents contents) {
        return contents.getDisplayName().getString();
    }

    public String getUniqueId(ICauldronContents contents) {
        return CauldronContentTypes.getName(CauldronContentHelper.getType(contents)).toString() + ":" + contents.getName();
    }

    public String getWildcardId(ICauldronContents contents) {
        return this.getUniqueId(contents);
    }

    public String getResourceId(ICauldronContents contents) {
        return contents.getName();
    }

    public String getModId(ICauldronContents contents) {
        String modId = contents.getModId();
        return modId == null ? "inspirations" : modId;
    }

    public String getErrorInfo(@Nullable ICauldronContents contents) {
        if (contents == null) {
            return "null";
        }
        return this.getUniqueId(contents);
    }
}

