/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.plugins.jei.cauldron;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import knightminer.inspirations.library.recipe.cauldron.contents.ICauldronContents;
import knightminer.inspirations.plugins.jei.cauldron.CauldronCategory;
import knightminer.inspirations.recipes.RecipesClientEvents;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;

public class CauldronRenderer {
    private static final String LEVEL = CauldronCategory.TRANSLATION_KEY + ".level";
    private static final String LEVEL_HALF = LEVEL + ".half";
    private static final String LEVEL_THIRD = LEVEL + ".third";
    private static final String LEVEL_QUARTER = LEVEL + ".quarter";
    private static final String LEVEL_SIXTH = LEVEL + ".sixth";
    private static final String LEVEL_EMPTY = LEVEL + ".empty";
    private static final String LEVEL_FULL = LEVEL + ".full";
    private static final ITextComponent[] AMOUNT_TEXTS = new ITextComponent[13];
    public static final int CAULDRON_SIZE = 12;
    public static final Contents LIST = new Contents(16, 12, true);
    private static final Contents[] CONTENT_LEVEL = new Contents[13];
    private static final Fluids[] FLUID_LEVEL = new Fluids[13];

    private CauldronRenderer() {
    }

    public static Contents contentLevel(int amount) {
        if (amount < 0) {
            amount = 0;
        } else if (amount > 12) {
            amount = 12;
        }
        if (CONTENT_LEVEL[amount] == null) {
            CauldronRenderer.CONTENT_LEVEL[amount] = new Contents(12, amount, false);
        }
        return CONTENT_LEVEL[amount];
    }

    public static Fluids fluidLevel(int amount) {
        if (amount < 0) {
            amount = 0;
        } else if (amount > 12) {
            amount = 12;
        }
        if (FLUID_LEVEL[amount] == null) {
            CauldronRenderer.FLUID_LEVEL[amount] = new Fluids(amount);
        }
        return FLUID_LEVEL[amount];
    }

    public static ITextComponent getAmountText(int amount) {
        if (amount < 0) {
            amount = 0;
        }
        if (amount > 12) {
            amount = 12;
        }
        if (AMOUNT_TEXTS[amount] == null) {
            TranslationTextComponent amountText = amount == 0 ? new TranslationTextComponent(LEVEL_EMPTY) : (amount == 12 ? new TranslationTextComponent(LEVEL_FULL) : (amount % 6 == 0 ? new TranslationTextComponent(LEVEL_HALF) : (amount % 4 == 0 ? new TranslationTextComponent(LEVEL_THIRD, new Object[]{amount / 4}) : (amount % 3 == 0 ? new TranslationTextComponent(LEVEL_QUARTER, new Object[]{amount / 3}) : (amount % 2 == 0 ? new TranslationTextComponent(LEVEL_SIXTH, new Object[]{amount / 2}) : new TranslationTextComponent(LEVEL, new Object[]{amount}))))));
            CauldronRenderer.AMOUNT_TEXTS[amount] = amountText.func_240699_a_(TextFormatting.GRAY);
        }
        return AMOUNT_TEXTS[amount];
    }

    private static void render(MatrixStack matrices, int x, int y, int width, int height, int amount, ResourceLocation texture, int color) {
        if (amount == 0) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.enableAlphaTest();
        Minecraft minecraft = Minecraft.func_71410_x();
        TextureAtlasSprite sprite = minecraft.func_209506_al().func_229356_a_(PlayerContainer.field_226615_c_).func_195424_a(texture);
        minecraft.func_110434_K().func_110577_a(PlayerContainer.field_226615_c_);
        int scaled = amount * height / 12;
        Matrix4f matrix = matrices.func_227866_c_().func_227870_a_();
        CauldronRenderer.setGLColorFromInt(color);
        CauldronRenderer.drawSprite(matrix, x, y + height - scaled, width, scaled, sprite);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableAlphaTest();
        RenderSystem.disableBlend();
    }

    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        int alphaI = color >> 24 & 0xFF;
        float alpha = alphaI == 0 ? 1.0f : (float)alphaI / 255.0f;
        RenderSystem.color4f((float)red, (float)green, (float)blue, (float)alpha);
    }

    private static void drawSprite(Matrix4f matrix, float x1, float y1, float width, float height, TextureAtlasSprite sprite) {
        float z = 100.0f;
        float u1 = sprite.func_94209_e();
        float u2 = sprite.func_94214_a((double)(16.0f * width / (float)sprite.func_94211_a()));
        float v1 = sprite.func_94206_g();
        float v2 = sprite.func_94207_b((double)(16.0f * height / (float)sprite.func_94216_b()));
        float x2 = x1 + width;
        float y2 = y1 + height;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        builder.func_227888_a_(matrix, x1, y2, 100.0f).func_225583_a_(u1, v2).func_181675_d();
        builder.func_227888_a_(matrix, x2, y2, 100.0f).func_225583_a_(u2, v2).func_181675_d();
        builder.func_227888_a_(matrix, x2, y1, 100.0f).func_225583_a_(u2, v1).func_181675_d();
        builder.func_227888_a_(matrix, x1, y1, 100.0f).func_225583_a_(u1, v1).func_181675_d();
        tessellator.func_78381_a();
    }

    public static class Fluids
    implements IIngredientRenderer<FluidStack> {
        private final int amount;

        private Fluids(int amount) {
            this.amount = amount;
        }

        public void render(MatrixStack matrices, int x, int y, @Nullable FluidStack fluid) {
            if (fluid == null || fluid.isEmpty()) {
                return;
            }
            FluidAttributes attributes = fluid.getFluid().getAttributes();
            CauldronRenderer.render(matrices, x, y, 12, 12, this.amount, attributes.getStillTexture(fluid), attributes.getColor(fluid));
        }

        public List<ITextComponent> getTooltip(FluidStack fluidStack, ITooltipFlag iTooltipFlag) {
            ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
            if (this.amount == 0) {
                list.add(CauldronRenderer.getAmountText(0));
            } else {
                list.add(fluidStack.getDisplayName());
                list.add(CauldronRenderer.getAmountText(this.amount));
            }
            return list;
        }
    }

    public static class Contents
    implements IIngredientRenderer<ICauldronContents> {
        private final int size;
        private final int amount;
        private final boolean isList;

        private Contents(int size, int amount, boolean isList) {
            this.size = size;
            this.amount = amount;
            this.isList = isList;
        }

        public void render(MatrixStack matrices, int x, int y, @Nullable ICauldronContents contents) {
            if (contents == null) {
                return;
            }
            CauldronRenderer.render(matrices, x, y, this.size, this.size, this.amount, RecipesClientEvents.cauldronTextures.getTexture(contents.getTextureName()), contents.getTintColor());
        }

        public List<ITextComponent> getTooltip(ICauldronContents contents, ITooltipFlag flag) {
            ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
            if (!this.isList && this.amount == 0) {
                list.add(CauldronRenderer.getAmountText(0));
            } else {
                list.add(contents.getDisplayName());
                contents.addInformation(list, flag);
                if (!this.isList) {
                    list.add(CauldronRenderer.getAmountText(this.amount));
                }
            }
            return list;
        }
    }
}

