/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.recipes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.function.Supplier;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.ModuleBase;
import knightminer.inspirations.library.recipe.cauldron.CauldronContentTypes;
import knightminer.inspirations.library.recipe.cauldron.contents.ICauldronContents;
import knightminer.inspirations.library.recipe.cauldron.recipe.CauldronRecipe;
import knightminer.inspirations.library.recipe.cauldron.recipe.CauldronTransform;
import knightminer.inspirations.library.recipe.cauldron.special.DyeableCauldronRecipe;
import knightminer.inspirations.library.recipe.cauldron.special.EmptyPotionCauldronRecipe;
import knightminer.inspirations.library.recipe.cauldron.special.FillPotionCauldronRecipe;
import knightminer.inspirations.recipes.block.EnhancedCauldronBlock;
import knightminer.inspirations.recipes.data.RecipesRecipeProvider;
import knightminer.inspirations.recipes.item.EmptyBottleItem;
import knightminer.inspirations.recipes.item.MixedDyedBottleItem;
import knightminer.inspirations.recipes.item.SimpleDyedBottleItem;
import knightminer.inspirations.recipes.recipe.cauldron.BrewingCauldronRecipe;
import knightminer.inspirations.recipes.recipe.cauldron.DyeCauldronWaterRecipe;
import knightminer.inspirations.recipes.recipe.cauldron.EmptyBucketCauldronRecipe;
import knightminer.inspirations.recipes.recipe.cauldron.FillBucketCauldronRecipe;
import knightminer.inspirations.recipes.recipe.cauldron.FillDyedBottleRecipe;
import knightminer.inspirations.recipes.recipe.cauldron.MixCauldronDyeRecipe;
import knightminer.inspirations.recipes.recipe.cauldron.PotionFermentCauldronTransform;
import knightminer.inspirations.recipes.recipe.cauldron.RemoveBannerPatternCauldronRecipe;
import knightminer.inspirations.recipes.tileentity.CauldronTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BucketItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.Items;
import net.minecraft.item.SoupItem;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Potions;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.village.PointOfInterestType;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.registration.FluidBuilder;
import slimeknights.mantle.registration.adapter.BlockRegistryAdapter;
import slimeknights.mantle.registration.adapter.FluidRegistryAdapter;
import slimeknights.mantle.registration.adapter.ItemRegistryAdapter;
import slimeknights.mantle.registration.adapter.RegistryAdapter;
import slimeknights.mantle.registration.adapter.TileEntityTypeRegistryAdapter;
import slimeknights.mantle.registration.object.EnumObject;

public class InspirationsRecipes
extends ModuleBase {
    public static final ResourceLocation STILL_FLUID = Inspirations.getResource("block/fluid/colorless");
    public static final ResourceLocation FLOWING_FLUID = Inspirations.getResource("block/fluid/colorless_flow");
    public static final ResourceLocation STILL_TRANSPARENT = Inspirations.getResource("block/fluid/transparent");
    public static final ResourceLocation FLOWING_TRANSPARENT = Inspirations.getResource("block/fluid/transparent_flow");
    public static Block fullAnvil;
    public static Block chippedAnvil;
    public static Block damagedAnvil;
    public static EnhancedCauldronBlock cauldron;
    public static TileEntityType<CauldronTileEntity> tileCauldron;
    public static Item splashBottle;
    public static Item lingeringBottle;
    public static EnumObject<DyeColor, SimpleDyedBottleItem> simpleDyedWaterBottle;
    public static MixedDyedBottleItem mixedDyedWaterBottle;
    public static SoupItem potatoSoupItem;
    public static ForgeFlowingFluid milk;
    public static ForgeFlowingFluid mushroomStew;
    public static BucketItem mushroomStewBucket;
    public static FlowingFluidBlock mushroomStewBlock;
    public static ForgeFlowingFluid beetrootSoup;
    public static BucketItem beetrootSoupBucket;
    public static FlowingFluidBlock beetrootSoupBlock;
    public static ForgeFlowingFluid rabbitStew;
    public static BucketItem rabbitStewBucket;
    public static FlowingFluidBlock rabbitStewBlock;
    public static ForgeFlowingFluid potatoSoup;
    public static BucketItem potatoSoupBucket;
    public static FlowingFluidBlock potatoSoupBlock;
    public static ForgeFlowingFluid honey;
    public static BucketItem honeyBucket;
    public static FlowingFluidBlock honeyFluidBlock;
    public static BasicParticleType boilingParticle;

    public InspirationsRecipes() {
        ForgeMod.enableMilkFluid();
    }

    @SubscribeEvent
    void registerFluids(RegistryEvent.Register<Fluid> event) {
        FluidRegistryAdapter adapter = new FluidRegistryAdapter(event.getRegistry());
        mushroomStew = adapter.register(new FluidBuilder(InspirationsRecipes.coloredFluid().color(-3306385).temperature(373).viscosity(1200)).block(() -> mushroomStewBlock).bucket(() -> mushroomStewBucket), "mushroom_stew");
        beetrootSoup = adapter.register(new FluidBuilder(InspirationsRecipes.coloredFluid().color(-8120819).temperature(373).viscosity(1100)).block(() -> beetrootSoupBlock).bucket(() -> beetrootSoupBucket), "beetroot_soup");
        rabbitStew = adapter.register(new FluidBuilder(InspirationsRecipes.coloredFluid().color(-6796756).temperature(373).viscosity(1400)).block(() -> rabbitStewBlock).bucket(() -> rabbitStewBucket), "rabbit_stew");
        potatoSoup = adapter.register(new FluidBuilder(InspirationsRecipes.coloredFluid().color(-861537).temperature(373).viscosity(1300)).block(() -> potatoSoupBlock).bucket(() -> potatoSoupBucket), "potato_soup");
        honey = adapter.register(new FluidBuilder(FluidAttributes.builder((ResourceLocation)STILL_TRANSPARENT, (ResourceLocation)FLOWING_TRANSPARENT).color(-28394).viscosity(4000).temperature(373)).block(() -> honeyFluidBlock).bucket(() -> honeyBucket), "honey");
    }

    @SubscribeEvent
    void registerBlocks(RegistryEvent.Register<Block> event) {
        BlockRegistryAdapter registry = new BlockRegistryAdapter(event.getRegistry());
        mushroomStewBlock = registry.registerFluidBlock(() -> mushroomStew, Material.field_151586_h, 0, "mushroom_stew");
        beetrootSoupBlock = registry.registerFluidBlock(() -> beetrootSoup, Material.field_151586_h, 0, "beetroot_soup");
        rabbitStewBlock = registry.registerFluidBlock(() -> rabbitStew, Material.field_151586_h, 0, "rabbit_stew");
        potatoSoupBlock = registry.registerFluidBlock(() -> potatoSoup, Material.field_151586_h, 0, "potato_soup");
        honeyFluidBlock = registry.registerFluidBlock(() -> honey, Material.field_151586_h, 0, "honey");
        if (((Boolean)Config.extendedCauldron.get()).booleanValue()) {
            cauldron = (EnhancedCauldronBlock)registry.registerOverride(EnhancedCauldronBlock::new, Blocks.field_150383_bp);
        }
    }

    @SubscribeEvent
    void registerItems(RegistryEvent.Register<Item> event) {
        ItemRegistryAdapter registry = new ItemRegistryAdapter(event.getRegistry());
        mushroomStewBucket = registry.registerBucket(() -> mushroomStew, "mushroom_stew");
        beetrootSoupBucket = registry.registerBucket(() -> beetrootSoup, "beetroot_soup");
        rabbitStewBucket = registry.registerBucket(() -> rabbitStew, "rabbit_stew");
        potatoSoupBucket = registry.registerBucket(() -> potatoSoup, "potato_soup");
        honeyBucket = registry.registerBucket(() -> honey, "honey");
        potatoSoupItem = (SoupItem)registry.register((IForgeRegistryEntry)new SoupItem(new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(8).func_221454_a(0.6f).func_221453_d())), "potato_soup");
        Item.Properties brewingProps = new Item.Properties().func_200916_a(ItemGroup.field_78038_k);
        splashBottle = (Item)registry.register((IForgeRegistryEntry)new EmptyBottleItem(brewingProps, (Supplier<Item>)Items.field_185155_bH.delegate), "splash_bottle");
        lingeringBottle = (Item)registry.register((IForgeRegistryEntry)new EmptyBottleItem(brewingProps, (Supplier<Item>)Items.field_185156_bI.delegate), "lingering_bottle");
        Item.Properties bottleProps = new Item.Properties().func_200916_a(ItemGroup.field_78035_l).func_200917_a(16).func_200919_a(Items.field_151069_bo);
        simpleDyedWaterBottle = registry.registerEnum(color -> new SimpleDyedBottleItem(bottleProps, DyeItem.func_195961_a((DyeColor)color)), (Enum[])DyeColor.values(), "dyed_bottle");
        mixedDyedWaterBottle = (MixedDyedBottleItem)registry.register((IForgeRegistryEntry)new MixedDyedBottleItem(bottleProps), "mixed_dyed_bottle");
        if (Config.extendedCauldron.getAsBoolean()) {
            registry.registerBlockItem((Block)cauldron, brewingProps);
        }
    }

    @SubscribeEvent
    void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> event) {
        TileEntityTypeRegistryAdapter registry = new TileEntityTypeRegistryAdapter(event.getRegistry());
        if (((Boolean)Config.extendedCauldron.get()).booleanValue()) {
            tileCauldron = registry.register(CauldronTileEntity::new, (Block)cauldron, "cauldron");
        }
    }

    @SubscribeEvent
    void registerParticleTypes(RegistryEvent.Register<ParticleType<?>> event) {
        RegistryAdapter registry = new RegistryAdapter(event.getRegistry());
        boilingParticle = (BasicParticleType)registry.register((IForgeRegistryEntry)new BasicParticleType(false), "boiling");
    }

    @SubscribeEvent
    void registerSerializers(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        RegistryAdapter registry = new RegistryAdapter(event.getRegistry());
        registry.register((IForgeRegistryEntry)new CauldronRecipe.Serializer(), "cauldron");
        registry.register((IForgeRegistryEntry)new EmptyPotionCauldronRecipe.Serializer(), "cauldron_empty_potion");
        registry.register((IForgeRegistryEntry)new FillPotionCauldronRecipe.Serializer(), "cauldron_fill_potion");
        registry.register((IForgeRegistryEntry)new DyeCauldronWaterRecipe.Serializer(), "cauldron_dye_water");
        registry.register((IForgeRegistryEntry)new MixCauldronDyeRecipe.Serializer(), "cauldron_mix_dye");
        registry.register((IForgeRegistryEntry)new DyeableCauldronRecipe.Serializer(DyeableCauldronRecipe.Dye::new), "cauldron_dye_dyeable");
        registry.register((IForgeRegistryEntry)new DyeableCauldronRecipe.Serializer(DyeableCauldronRecipe.Clear::new), "cauldron_clear_dyeable");
        registry.register((IForgeRegistryEntry)new CauldronTransform.Serializer(), "cauldron_transform");
        registry.register((IForgeRegistryEntry)new PotionFermentCauldronTransform.Serializer(), "cauldron_potion_ferment");
        registry.register((IForgeRegistryEntry)new SpecialRecipeSerializer(EmptyBucketCauldronRecipe::new), "cauldron_empty_bucket");
        registry.register((IForgeRegistryEntry)new SpecialRecipeSerializer(FillBucketCauldronRecipe::new), "cauldron_fill_bucket");
        registry.register((IForgeRegistryEntry)new SpecialRecipeSerializer(FillDyedBottleRecipe::new), "cauldron_fill_dyed_bottle");
        registry.register((IForgeRegistryEntry)new SpecialRecipeSerializer(RemoveBannerPatternCauldronRecipe::new), "cauldron_remove_banner_pattern");
        registry.register((IForgeRegistryEntry)new BrewingCauldronRecipe.Serializer(BrewingCauldronRecipe.Vanilla::new), "cauldron_potion_brewing");
        registry.register((IForgeRegistryEntry)new BrewingCauldronRecipe.Serializer(BrewingCauldronRecipe.Forge::new), "cauldron_forge_brewing");
        ICauldronContents water = CauldronContentTypes.FLUID.of((Fluid)Fluids.field_204546_a);
        CauldronContentTypes.POTION.setResult(Potions.field_185230_b, water);
        for (DyeColor color : DyeColor.values()) {
            CauldronContentTypes.COLOR.setResult(color.getColorValue(), CauldronContentTypes.DYE.of(color));
        }
    }

    @SubscribeEvent
    void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        if (event.includeServer()) {
            gen.func_200390_a((IDataProvider)new RecipesRecipeProvider(gen));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    void commonSetup(FMLCommonSetupEvent event) {
        if (Config.extendedCauldron.getAsBoolean()) {
            Map map;
            Map map2 = map = GameData.getBlockStatePointOfInterestTypeMap();
            synchronized (map2) {
                ImmutableList newStates = cauldron.func_176194_O().func_177619_a();
                PointOfInterestType pointOfInterestType = PointOfInterestType.field_221062_j;
                synchronized (pointOfInterestType) {
                    ImmutableSet.Builder builder = ImmutableSet.builder();
                    builder.addAll((Iterable)PointOfInterestType.field_221062_j.field_221075_w);
                    builder.addAll((Iterable)newStates);
                    PointOfInterestType.field_221062_j.field_221075_w = builder.build();
                }
                newStates.forEach(state -> map.put(state, PointOfInterestType.field_221062_j));
            }
        }
    }

    private static FluidAttributes.Builder coloredFluid() {
        return FluidAttributes.builder((ResourceLocation)STILL_FLUID, (ResourceLocation)FLOWING_FLUID);
    }

    static {
        simpleDyedWaterBottle = EnumObject.empty();
    }
}

