/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.recipes;

import java.util.function.BooleanSupplier;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.common.ClientEvents;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.library.client.CustomTextureLoader;
import knightminer.inspirations.library.client.model.CauldronModel;
import knightminer.inspirations.library.recipe.cauldron.CauldronContentTypes;
import knightminer.inspirations.library.recipe.cauldron.contents.ICauldronContents;
import knightminer.inspirations.recipes.InspirationsRecipes;
import knightminer.inspirations.recipes.client.BoilingParticle;
import knightminer.inspirations.recipes.item.MixedDyedBottleItem;
import knightminer.inspirations.recipes.tileentity.CauldronTileEntity;
import knightminer.inspirations.shared.SharedClientEvents;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.particles.ParticleType;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="inspirations", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class RecipesClientEvents
extends ClientEvents {
    public static CustomTextureLoader cauldronTextures = new CustomTextureLoader(Inspirations.getResource("cauldron_textures"));

    public static void onConstruct() {
        IResourceManager manager = Minecraft.func_71410_x().func_195551_G();
        if (manager instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)manager).func_219534_a((IFutureReloadListener)cauldronTextures);
        } else {
            Inspirations.log.error("Failed to register resource reload listener, expected instance of IReloadableResourceManager but got {}", manager.getClass());
        }
    }

    @SubscribeEvent
    static void clientSetup(FMLClientSetupEvent event) {
        RenderTypeLookup.setRenderLayer((Fluid)InspirationsRecipes.honey, (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Fluid)InspirationsRecipes.honey.func_210197_e(), (RenderType)RenderType.func_228645_f_());
        if (Config.extendedCauldron.getAsBoolean()) {
            RenderTypeLookup.setRenderLayer((Block)Blocks.field_150383_bp, (RenderType)RenderType.func_228643_e_());
        }
    }

    @SubscribeEvent
    static void registerModelLoaders(ModelRegistryEvent event) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)Inspirations.getResource("cauldron"), (IModelLoader)CauldronModel.LOADER);
        SharedClientEvents.configPack.addBlockstateReplacement((BooleanSupplier)Config.extendedCauldron, Blocks.field_150383_bp, "cauldron");
    }

    @SubscribeEvent
    static void registerBlockColors(ColorHandlerEvent.Block event) {
        BlockColors blockColors = event.getBlockColors();
        RecipesClientEvents.registerBlockColors(blockColors, (state, world, pos, tintIndex) -> {
            if (tintIndex > 0 && world != null && pos != null) {
                ICauldronContents contents;
                TileEntity te = world.func_175625_s(pos);
                if (te instanceof CauldronTileEntity && !(contents = ((CauldronTileEntity)te).getContents()).matches(CauldronContentTypes.FLUID, Fluids.field_204546_a)) {
                    return contents.getTintColor();
                }
                return BiomeColors.func_228363_c_((IBlockDisplayReader)world, (BlockPos)pos);
            }
            return -1;
        }, new Block[]{InspirationsRecipes.cauldron});
    }

    @SubscribeEvent
    static void registerParticleFactories(ParticleFactoryRegisterEvent event) {
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)InspirationsRecipes.boilingParticle, BoilingParticle.Factory::new);
    }

    @SubscribeEvent
    static void registerItemColors(ColorHandlerEvent.Item event) {
        ItemColors itemColors = event.getItemColors();
        InspirationsRecipes.simpleDyedWaterBottle.forEach((color, bottle) -> itemColors.func_199877_a((stack, index) -> index == 0 ? color.getColorValue() : -1, new IItemProvider[]{bottle}));
        RecipesClientEvents.registerItemColors(itemColors, (stack, index) -> index == 0 ? MixedDyedBottleItem.dyeFromBottle(stack) : -1, new IItemProvider[]{InspirationsRecipes.mixedDyedWaterBottle});
    }

    @SubscribeEvent
    static void registerTextures(TextureStitchEvent.Pre event) {
        if (PlayerContainer.field_226615_c_.equals((Object)event.getMap().func_229223_g_())) {
            event.addSprite(InspirationsRecipes.STILL_FLUID);
            event.addSprite(InspirationsRecipes.FLOWING_FLUID);
        }
    }
}

