/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.recipes.block;

import java.util.Random;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.library.recipe.cauldron.util.CauldronTemperature;
import knightminer.inspirations.recipes.InspirationsRecipes;
import knightminer.inspirations.recipes.tileentity.CauldronTileEntity;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.CauldronBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import slimeknights.mantle.util.TileEntityHelper;

public class EnhancedCauldronBlock
extends CauldronBlock {
    public EnhancedCauldronBlock(AbstractBlock.Properties props) {
        super(props);
    }

    public int getLevel(BlockState state) {
        return (Integer)state.func_177229_b((Property)field_176591_a);
    }

    public void func_176590_a(World world, BlockPos pos, BlockState state, int level) {
        if (level != this.getLevel(state)) {
            super.func_176590_a(world, pos, state, level);
        }
    }

    public void func_176224_k(World world, BlockPos pos) {
        BlockState state;
        int level;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof CauldronTileEntity && !((CauldronTileEntity)te).getContents().isSimple()) {
            return;
        }
        if ((((Boolean)Config.fasterCauldronRain.get()).booleanValue() || world.field_73012_v.nextInt(20) == 0) && world.func_226691_t_(pos).func_225486_c(pos) >= 0.15f && (level = this.getLevel(state = world.func_180495_p(pos))) < 3) {
            this.func_176590_a(world, pos, state, level + 1);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        if (Config.cauldronRecipes.getAsBoolean()) {
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, world, pos, player, hand, ray);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new CauldronTileEntity(this);
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        if (world.field_72995_K) {
            return;
        }
        int level = this.getLevel(state);
        if (entity.func_174813_aQ().field_72338_b <= (double)((float)pos.func_177956_o() + (5.5f + (float)(3 * Math.max(level, 1))) / 16.0f)) {
            TileEntityHelper.getTile(CauldronTileEntity.class, (IBlockReader)world, (BlockPos)pos).ifPresent(te -> {
                int newLevel = te.onEntityCollide(entity, level, state);
                if (level != newLevel) {
                    this.func_176590_a(world, pos, state, newLevel);
                }
            });
        }
    }

    @Deprecated
    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        TileEntityHelper.getTile(CauldronTileEntity.class, (IBlockReader)world, (BlockPos)currentPos).ifPresent(te -> te.neighborChanged(facingPos));
        return state;
    }

    @Deprecated
    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        if (this.getLevel(state) == 0) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof CauldronTileEntity) {
            CauldronTileEntity cauldron = (CauldronTileEntity)te;
            int level = cauldron.getLevel();
            if (cauldron.getTemperature() == CauldronTemperature.BOILING) {
                EnhancedCauldronBlock.addParticles((IParticleData)InspirationsRecipes.boilingParticle, world, pos, 2, level, rand);
            }
            int count = cauldron.getTransformParticles();
            EnhancedCauldronBlock.addParticles((IParticleData)ParticleTypes.field_197632_y, world, pos, count, level, rand);
        }
    }

    private static void addParticles(IParticleData type, World world, BlockPos pos, int count, int level, Random rand) {
        for (int i = 0; i < count; ++i) {
            double x = (double)pos.func_177958_n() + 0.1875 + (double)rand.nextFloat() * 0.625;
            double y = (double)pos.func_177956_o() + 0.1875 + (double)level * 0.0625;
            double z = (double)pos.func_177952_p() + 0.1875 + (double)rand.nextFloat() * 0.625;
            world.func_195594_a(type, x, y, z, 0.0, 0.0, 0.0);
        }
    }
}

