/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.recipes.data;

import java.util.EnumSet;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import knightminer.inspirations.common.data.ConfigEnabledCondition;
import knightminer.inspirations.common.datagen.IInspirationsRecipeBuilder;
import knightminer.inspirations.common.datagen.NBTIngredient;
import knightminer.inspirations.library.InspirationsTags;
import knightminer.inspirations.library.recipe.RecipeSerializers;
import knightminer.inspirations.library.recipe.cauldron.CauldronContentTypes;
import knightminer.inspirations.library.recipe.cauldron.CauldronIngredients;
import knightminer.inspirations.library.recipe.cauldron.contents.ICauldronContents;
import knightminer.inspirations.library.recipe.cauldron.ingredient.ContentMatchIngredient;
import knightminer.inspirations.library.recipe.cauldron.ingredient.ICauldronIngredient;
import knightminer.inspirations.library.recipe.cauldron.recipe.CauldronRecipeBuilder;
import knightminer.inspirations.library.recipe.cauldron.recipe.CauldronTransformBuilder;
import knightminer.inspirations.library.recipe.cauldron.special.DyeableCauldronRecipe;
import knightminer.inspirations.library.recipe.cauldron.special.EmptyPotionCauldronRecipe;
import knightminer.inspirations.library.recipe.cauldron.special.FillPotionCauldronRecipe;
import knightminer.inspirations.library.recipe.cauldron.util.TemperaturePredicate;
import knightminer.inspirations.recipes.InspirationsRecipes;
import knightminer.inspirations.recipes.data.VanillaEnum;
import knightminer.inspirations.recipes.recipe.cauldron.BrewingCauldronRecipe;
import knightminer.inspirations.recipes.recipe.cauldron.DyeCauldronWaterRecipe;
import knightminer.inspirations.recipes.recipe.cauldron.MixCauldronDyeRecipe;
import knightminer.inspirations.recipes.recipe.cauldron.PotionFermentCauldronTransform;
import knightminer.inspirations.shared.InspirationsShared;
import knightminer.inspirations.tools.InspirationsTools;
import knightminer.inspirations.utility.InspirationsUtility;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.data.CustomRecipeBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.recipe.SizedIngredient;
import slimeknights.mantle.recipe.data.ConsumerWrapperBuilder;
import slimeknights.mantle.registration.object.EnumObject;

public class RecipesRecipeProvider
extends RecipeProvider
implements IConditionBuilder,
IInspirationsRecipeBuilder {
    private Consumer<IFinishedRecipe> consumer;

    public RecipesRecipeProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    public String func_200397_b() {
        return "Inspirations Recipes - Recipes";
    }

    public Consumer<IFinishedRecipe> getConsumer() {
        return this.consumer;
    }

    @Override
    public ICondition baseCondition() {
        return ConfigEnabledCondition.MODULE_RECIPES;
    }

    protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
        this.consumer = consumer;
        this.addCauldronRecipes();
    }

    private void addCauldronRecipes() {
        String folder = "cauldron/";
        ContentMatchIngredient<FlowingFluid> waterIngredient = CauldronIngredients.FLUID.of(Fluids.field_204546_a);
        Consumer cauldronRecipes = this.withCondition(new ICondition[]{ConfigEnabledCondition.CAULDRON_RECIPES});
        CustomRecipeBuilder.func_218656_a(RecipeSerializers.CAULDRON_FILL_BUCKET).func_200499_a(this.withCondition(new ICondition[]{ConfigEnabledCondition.CAULDRON_RECIPES}), this.resourceName(folder + "fill_bucket"));
        ItemStack waterBottle = PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185230_b);
        ((CauldronRecipeBuilder)CauldronRecipeBuilder.cauldron(SizedIngredient.fromItems((IItemProvider[])new IItemProvider[]{Items.field_151069_bo}), waterIngredient).minLevels(4).addLevels(-4).setOutput(waterBottle.func_77946_l()).setSound(SoundEvents.field_187615_H).addCriterion("has_item", (ICriterionInstance)RecipesRecipeProvider.func_200403_a((IItemProvider)Items.field_151069_bo))).build(cauldronRecipes, this.resource(folder + "fill_water_bottle"));
        CustomRecipeBuilder.func_218656_a(RecipeSerializers.CAULDRON_EMPTY_BUCKET).func_200499_a(cauldronRecipes, this.resourceName(folder + "empty_bucket"));
        ((CauldronRecipeBuilder)CauldronRecipeBuilder.cauldron(SizedIngredient.of((Ingredient)new NBTIngredient(waterBottle)), waterIngredient).maxLevels(11).addLevels(4).setOutput((IItemProvider)Items.field_151069_bo).setOutput(CauldronContentTypes.FLUID.of((Fluid)Fluids.field_204546_a)).noContainer().setSound(SoundEvents.field_191241_J).addCriterion("has_item", (ICriterionInstance)RecipesRecipeProvider.func_200405_a((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.func_200309_a().func_200308_a((IItemProvider)Items.field_151068_bn).func_218002_a(Objects.requireNonNull(waterBottle.func_77978_p())).func_200310_b()}))).build(cauldronRecipes, this.resource(folder + "empty_water_bottle"));
        ((CauldronRecipeBuilder)CauldronRecipeBuilder.cauldron(SizedIngredient.fromItems((IItemProvider[])new IItemProvider[]{Blocks.field_150360_v}), waterIngredient).matchFull().setEmpty().setOutput((IItemProvider)Blocks.field_196577_ad).addCriterion("has_item", (ICriterionInstance)RecipesRecipeProvider.func_200403_a((IItemProvider)Blocks.field_150360_v))).setSound(SoundType.field_185850_c.func_185841_e()).build(cauldronRecipes, this.resource(folder + "dry_cauldron"));
        String iceFolder = folder + "ice/";
        ((CauldronRecipeBuilder)CauldronRecipeBuilder.cauldron(SizedIngredient.fromItems((IItemProvider[])new IItemProvider[]{Blocks.field_150432_aD}), waterIngredient).maxLevels(11).setFull().setTemperature(TemperaturePredicate.BOILING).setOutput(CauldronContentTypes.FLUID.of((Fluid)Fluids.field_204546_a)).setSound(SoundEvents.field_187630_M).addCriterion("has_item", (ICriterionInstance)RecipesRecipeProvider.func_200403_a((IItemProvider)Blocks.field_150432_aD))).build(this.withCondition(new ICondition[]{ConfigEnabledCondition.CAULDRON_RECIPES, this.not(ConfigEnabledCondition.CAULDRON_ICE)}), this.wrapE((IForgeRegistryEntry<?>)Fluids.field_204546_a, iceFolder, "_from_ice"));
        Consumer cauldronIce = this.withCondition(new ICondition[]{ConfigEnabledCondition.CAULDRON_ICE});
        ResourceLocation ice = Objects.requireNonNull(Blocks.field_150432_aD.getRegistryName());
        ((CauldronTransformBuilder)CauldronTransformBuilder.transform(CauldronIngredients.FLUID.of(Fluids.field_204546_a), CauldronContentTypes.CUSTOM.of(ice), 500).setTemperature(TemperaturePredicate.FREEZING).addCriterion("has_item", (ICriterionInstance)RecipesRecipeProvider.func_200403_a((IItemProvider)Items.field_221770_cu))).setSound(SoundType.field_185853_f.func_185841_e()).build(cauldronIce, this.resource(iceFolder + "ice_from_water"));
        ResourceLocation wetIce = Objects.requireNonNull(this.resource("wet_ice"));
        ResourceLocation packedIce = Objects.requireNonNull(Blocks.field_150403_cj.getRegistryName());
        ((CauldronTransformBuilder)CauldronTransformBuilder.transform(CauldronIngredients.CUSTOM.of(wetIce), CauldronContentTypes.CUSTOM.of(packedIce), 2000).setTemperature(TemperaturePredicate.FREEZING).addCriterion("has_item", (ICriterionInstance)RecipesRecipeProvider.func_200403_a((IItemProvider)Items.field_221898_fg))).setSound(SoundType.field_185853_f.func_185841_e()).build(cauldronIce, this.resource(iceFolder + "packed_ice_from_wet_ice"));
        ((CauldronTransformBuilder)CauldronTransformBuilder.transform(CauldronIngredients.CUSTOM.of(ice), CauldronContentTypes.FLUID.of((Fluid)Fluids.field_204546_a), 500).setTemperature(TemperaturePredicate.BOILING).addCriterion("has_item", (ICriterionInstance)RecipesRecipeProvider.func_200403_a((IItemProvider)Items.field_221770_cu))).setSound(SoundEvents.field_187624_K).build(cauldronIce, this.resource(iceFolder + "water_from_ice_melting"));
        ((CauldronTransformBuilder)CauldronTransformBuilder.transform(CauldronIngredients.CUSTOM.of(wetIce), CauldronContentTypes.FLUID.of((Fluid)Fluids.field_204546_a), 500).setTemperature(TemperaturePredicate.BOILING).addCriterion("has_item", (ICriterionInstance)RecipesRecipeProvider.func_200403_a((IItemProvider)Items.field_221770_cu))).setSound(SoundType.field_185853_f.func_185841_e()).build(cauldronIce, this.resource(iceFolder + "water_from_wet_ice"));
        ((CauldronTransformBuilder)CauldronTransformBuilder.transform(CauldronIngredients.CUSTOM.of(packedIce), CauldronContentTypes.CUSTOM.of(wetIce), 2000).setTemperature(TemperaturePredicate.BOILING).addCriterion("has_item", (ICriterionInstance)RecipesRecipeProvider.func_200403_a((IItemProvider)Items.field_221898_fg))).setSound(SoundType.field_185853_f.func_185841_e()).build(cauldronIce, this.resource(iceFolder + "wet_ice_from_packed_ice"));
        ((CauldronRecipeBuilder)CauldronRecipeBuilder.cauldron(CauldronIngredients.CUSTOM.of(ice)).matchFull().setEmpty().setOutput((IItemProvider)Blocks.field_150432_aD).setSound(SoundType.field_185853_f.func_185845_c()).addCriterion("has_item", (ICriterionInstance)RecipesRecipeProvider.func_200403_a((IItemProvider)Items.field_221770_cu))).build(cauldronIce, this.resource(iceFolder + "pickup_ice"));
        ((CauldronRecipeBuilder)CauldronRecipeBuilder.cauldron(SizedIngredient.fromItems((IItemProvider[])new IItemProvider[]{Blocks.field_150432_aD}), CauldronIngredients.CUSTOM.of(ice)).matchEmpty().setFull().setOutput(CauldronContentTypes.CUSTOM.of(ice)).setSound(SoundType.field_185853_f.func_185841_e()).addCriterion("has_item", (ICriterionInstance)RecipesRecipeProvider.func_200403_a((IItemProvider)Items.field_221770_cu))).build(cauldronIce, this.resource(iceFolder + "place_ice"));
        ((CauldronRecipeBuilder)CauldronRecipeBuilder.cauldron(CauldronIngredients.CUSTOM.of(wetIce)).matchFull().setOutput((IItemProvider)Blocks.field_150432_aD).setOutput(CauldronContentTypes.FLUID.of((Fluid)Fluids.field_204546_a)).setSound(SoundType.field_185853_f.func_185845_c()).addCriterion("has_item", (ICriterionInstance)RecipesRecipeProvider.func_200403_a((IItemProvider)Items.field_221770_cu))).build(cauldronIce, this.resource(iceFolder + "pickup_wet_ice"));
        ((CauldronRecipeBuilder)CauldronRecipeBuilder.cauldron(SizedIngredient.fromItems((IItemProvider[])new IItemProvider[]{Blocks.field_150432_aD}), CauldronIngredients.FLUID.of(Fluids.field_204546_a)).matchFull().setOutput(CauldronContentTypes.CUSTOM.of(wetIce)).setSound(SoundType.field_185853_f.func_185841_e()).addCriterion("has_item", (ICriterionInstance)RecipesRecipeProvider.func_200403_a((IItemProvider)Items.field_221770_cu))).build(cauldronIce, this.resource(iceFolder + "place_wet_ice"));
        ((CauldronRecipeBuilder)CauldronRecipeBuilder.cauldron(CauldronIngredients.CUSTOM.of(packedIce)).matchFull().setEmpty().setOutput((IItemProvider)Blocks.field_150403_cj).setSound(SoundType.field_185853_f.func_185845_c()).addCriterion("has_item", (ICriterionInstance)RecipesRecipeProvider.func_200403_a((IItemProvider)Items.field_221898_fg))).build(cauldronIce, this.resource(iceFolder + "pickup_packed_ice"));
        ((CauldronRecipeBuilder)CauldronRecipeBuilder.cauldron(SizedIngredient.fromItems((IItemProvider[])new IItemProvider[]{Blocks.field_150403_cj}), CauldronIngredients.CUSTOM.of(packedIce)).matchEmpty().setFull().setOutput(CauldronContentTypes.CUSTOM.of(packedIce)).setSound(SoundType.field_185853_f.func_185841_e()).addCriterion("has_item", (ICriterionInstance)RecipesRecipeProvider.func_200403_a((IItemProvider)Items.field_221770_cu))).build(cauldronIce, this.resource(iceFolder + "place_packed_ice"));
        ((CauldronRecipeBuilder)CauldronRecipeBuilder.cauldron(SizedIngredient.fromItems((IItemProvider[])new IItemProvider[]{Blocks.field_150320_F}), waterIngredient).minLevels(4).addLevels(-4).setOutput((IItemProvider)Blocks.field_150331_J).addCriterion("has_item", (ICriterionInstance)RecipesRecipeProvider.func_200403_a((IItemProvider)Blocks.field_150320_F))).build(cauldronRecipes, this.wrap((IItemProvider)Blocks.field_150320_F, folder, "_cleaning"));
        String concreteFolder = folder + "concrete/";
        Consumer concrete = this.withCondition(new ICondition[]{ConfigEnabledCondition.CAULDRON_CONCRETE});
        VanillaEnum.CONCRETE_POWDER.forEach((color, powder) -> ((CauldronRecipeBuilder)CauldronRecipeBuilder.cauldron(SizedIngredient.fromItems((IItemProvider[])new IItemProvider[]{powder}), waterIngredient).minLevels(4).addLevels(-4).setOutput((IItemProvider)VanillaEnum.CONCRETE.get((Enum)color)).addCriterion("has_item", (ICriterionInstance)RecipesRecipeProvider.func_200403_a((IItemProvider)powder))).build(concrete, this.resource(concreteFolder + color.func_176610_l())));
        Consumer fluidConsumer = this.withCondition(new ICondition[]{ConfigEnabledCondition.CAULDRON_FLUIDS});
        String honeyFolder = folder + "honey/";
        ((CauldronRecipeBuilder)CauldronRecipeBuilder.cauldron(SizedIngredient.fromItems((IItemProvider[])new IItemProvider[]{Items.field_226638_pX_}), CauldronIngredients.FLUID.of(InspirationsRecipes.honey)).maxLevels(11).addLevels(3).setOutput((IItemProvider)Items.field_151069_bo).noContainer().setOutput(CauldronContentTypes.FLUID.of((Fluid)InspirationsRecipes.honey)).setSound(SoundEvents.field_191241_J).addCriterion("has_item", (ICriterionInstance)RecipesRecipeProvider.func_200403_a((IItemProvider)Items.field_226638_pX_))).build(fluidConsumer, this.resource(honeyFolder + "empty_bottle"));
        ((CauldronRecipeBuilder)CauldronRecipeBuilder.cauldron(SizedIngredient.fromItems((IItemProvider[])new IItemProvider[]{Items.field_151069_bo}), CauldronIngredients.FLUID.of(InspirationsRecipes.honey)).minLevels(3).addLevels(-3).setOutput((IItemProvider)Items.field_226638_pX_).setSound(SoundEvents.field_187630_M).addCriterion("has_item", (ICriterionInstance)RecipesRecipeProvider.func_200403_a((IItemProvider)Items.field_226638_pX_))).build(fluidConsumer, this.resource(honeyFolder + "fill_bottle"));
        ResourceLocation honeyBlock = new ResourceLocation("honey_block");
        ((CauldronRecipeBuilder)CauldronRecipeBuilder.cauldron(SizedIngredient.fromItems((IItemProvider[])new IItemProvider[]{Blocks.field_226907_mc_}), CauldronIngredients.CUSTOM.of(honeyBlock)).matchEmpty().setFull().setOutput(CauldronContentTypes.CUSTOM.of(honeyBlock)).setSound(SoundType.field_226947_m_.func_185841_e()).addCriterion("has_item", (ICriterionInstance)RecipesRecipeProvider.func_200403_a((IItemProvider)Blocks.field_226907_mc_))).build(fluidConsumer, this.resource(honeyFolder + "place_block"));
        ((CauldronRecipeBuilder)CauldronRecipeBuilder.cauldron(CauldronIngredients.CUSTOM.of(honeyBlock)).matchFull().setEmpty().setOutput((IItemProvider)Blocks.field_226907_mc_).setSound(SoundType.field_226947_m_.func_185845_c()).addCriterion("has_item", (ICriterionInstance)RecipesRecipeProvider.func_200403_a((IItemProvider)Blocks.field_226907_mc_))).build(fluidConsumer, this.resource(honeyFolder + "pickup_block"));
        ((CauldronRecipeBuilder)CauldronRecipeBuilder.cauldron(CauldronIngredients.CUSTOM.of(honeyBlock)).levelRange(1, 11).addLevels(-1).setOutput((IItemProvider)Items.field_151102_aT).setSound(SoundType.field_185855_h.func_185845_c()).addCriterion("has_item", (ICriterionInstance)RecipesRecipeProvider.func_200403_a((IItemProvider)Items.field_226638_pX_))).build(fluidConsumer, this.resource(honeyFolder + "pickup_sugar"));
        ((CauldronTransformBuilder)CauldronTransformBuilder.transform(CauldronIngredients.FLUID.of(InspirationsRecipes.honey), CauldronContentTypes.CUSTOM.of(honeyBlock), 300).setTemperature(TemperaturePredicate.COOL).setSound(SoundType.field_226947_m_.func_185841_e()).addCriterion("has_item", (ICriterionInstance)RecipesRecipeProvider.func_200403_a((IItemProvider)Blocks.field_226907_mc_))).build(fluidConsumer, this.resource(honeyFolder + "solidify"));
        ((CauldronTransformBuilder)CauldronTransformBuilder.transform(CauldronIngredients.CUSTOM.of(honeyBlock), CauldronContentTypes.FLUID.of((Fluid)InspirationsRecipes.honey), 300).setTemperature(TemperaturePredicate.BOILING).setSound(SoundType.field_226947_m_.func_185845_c()).addCriterion("has_item", (ICriterionInstance)RecipesRecipeProvider.func_200403_a((IItemProvider)Blocks.field_226907_mc_))).build(fluidConsumer, this.resource(honeyFolder + "melt"));
        String dyeFolder = folder + "dye/";
        Consumer dyeConsumer = this.withCondition(new ICondition[]{ConfigEnabledCondition.CAULDRON_DYEING});
        for (DyeColor color2 : DyeColor.values()) {
            dyeConsumer.accept(new DyeCauldronWaterRecipe.FinishedRecipe(this.resource(dyeFolder + "dye_" + color2.func_176610_l()), color2));
            dyeConsumer.accept(new MixCauldronDyeRecipe.FinishedRecipe(this.resource(dyeFolder + "bottle/" + color2.func_176610_l()), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)InspirationsRecipes.simpleDyedWaterBottle.get((Enum)color2)}), color2.getColorValue()));
        }
        dyeConsumer.accept(new MixCauldronDyeRecipe.FinishedRecipe(this.resource(dyeFolder + "bottle/mixed"), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{InspirationsRecipes.mixedDyedWaterBottle})));
        CustomRecipeBuilder.func_218656_a(RecipeSerializers.CAULDRON_FILL_DYED_BOTTLE).func_200499_a(dyeConsumer, this.resourceName(dyeFolder + "bottle/fill"));
        String mixFolder = dyeFolder + "bottle/mix/";
        this.addDyedBottleMix(mixFolder, DyeColor.CYAN, DyeColor.BLUE, DyeColor.GREEN);
        this.addDyedBottleMix(mixFolder, DyeColor.GRAY, DyeColor.BLACK, DyeColor.WHITE);
        this.addDyedBottleMix(mixFolder, DyeColor.LIGHT_BLUE, DyeColor.BLUE, DyeColor.WHITE);
        this.addDyedBottleMix(mixFolder, DyeColor.LIGHT_GRAY, DyeColor.BLACK, DyeColor.WHITE, DyeColor.WHITE);
        this.addDyedBottleMix(mixFolder, DyeColor.LIGHT_GRAY, DyeColor.GRAY, DyeColor.WHITE);
        this.addDyedBottleMix(mixFolder, DyeColor.LIME, DyeColor.GREEN, DyeColor.WHITE);
        this.addDyedBottleMix(mixFolder, DyeColor.MAGENTA, DyeColor.BLUE, DyeColor.RED, DyeColor.PINK);
        this.addDyedBottleMix(mixFolder, DyeColor.MAGENTA, DyeColor.BLUE, DyeColor.RED, DyeColor.RED, DyeColor.WHITE);
        this.addDyedBottleMix(mixFolder, DyeColor.MAGENTA, DyeColor.PURPLE, DyeColor.PINK);
        this.addDyedBottleMix(mixFolder, DyeColor.ORANGE, DyeColor.RED, DyeColor.YELLOW);
        this.addDyedBottleMix(mixFolder, DyeColor.PINK, DyeColor.RED, DyeColor.WHITE);
        this.addDyedBottleMix(mixFolder, DyeColor.PURPLE, DyeColor.BLUE, DyeColor.RED);
        this.addColoredRecipes((ITag<Item>)ItemTags.field_199904_a, VanillaEnum.WOOL, folder + "wool/", null);
        this.addColoredRecipes((ITag<Item>)ItemTags.field_219771_F, VanillaEnum.BED, folder + "bed/", null);
        this.addColoredRecipes((ITag<Item>)ItemTags.field_200035_e, InspirationsShared.VANILLA_CARPETS, folder + "carpet/", null);
        this.addColoredRecipes((ITag<Item>)InspirationsTags.Items.SHULKER_BOXES, (EnumObject<DyeColor, ? extends IItemProvider>)VanillaEnum.SHULKER_BOX, (IItemProvider)Items.field_221970_gq, folder + "shulker_box/", true, null);
        this.addColoredRecipes((ITag<Item>)InspirationsTags.Items.CARPETED_TRAPDOORS, (EnumObject<DyeColor, ? extends IItemProvider>)InspirationsUtility.carpetedTrapdoors, folder + "carpeted_trapdoor/", ConfigEnabledCondition.CARPETED_TRAPDOOR);
        Consumer bottleConsumer = this.withCondition(new ICondition[]{ConfigEnabledCondition.CAULDRON_DYEING});
        String bottleFolder = folder + "bottle/";
        InspirationsRecipes.simpleDyedWaterBottle.forEach((dye, bottle) -> {
            String name = dye.func_176610_l();
            InventoryChangeTrigger.Instance hasBottle = RecipesRecipeProvider.func_200403_a((IItemProvider)bottle);
            this.addComboRecipe(bottleConsumer, (IItemProvider)VanillaEnum.WOOL.get((Enum)dye), "wool", (ITag<Item>)ItemTags.field_199904_a, (IItemProvider)bottle, this.resource(bottleFolder + "wool/" + name));
            this.addSurroundRecipe(bottleConsumer, (IItemProvider)VanillaEnum.CARPET.get((Enum)dye), "carpet", (ITag<Item>)InspirationsTags.Items.CARPETS, (IItemProvider)bottle, this.resource(bottleFolder + "carpet/" + name));
            this.addComboRecipe(bottleConsumer, (IItemProvider)VanillaEnum.BED.get((Enum)dye), "dyed_bed", (ITag<Item>)ItemTags.field_219771_F, (IItemProvider)bottle, this.resource(bottleFolder + "beds/" + name));
            this.addSurroundRecipe(bottleConsumer, (IItemProvider)VanillaEnum.STAINED_GLASS.get((Enum)dye), "stained_glass", (ITag<Item>)Tags.Items.GLASS_COLORLESS, (IItemProvider)bottle, this.resource(bottleFolder + "stained_glass/" + name));
            this.addSurroundRecipe(bottleConsumer, (IItemProvider)VanillaEnum.STAINED_GLASS_PANE.get((Enum)dye), "stained_glass_pane", (ITag<Item>)Tags.Items.GLASS_PANES_COLORLESS, (IItemProvider)bottle, this.resource(bottleFolder + "stained_glass_pane/" + name));
            this.addSurroundRecipe(bottleConsumer, (IItemProvider)VanillaEnum.TERRACOTTA.get((Enum)dye), "stained_terracotta", (ITag<Item>)InspirationsTags.Items.TERRACOTTA, (IItemProvider)bottle, this.resource(bottleFolder + "terracotta/" + name));
            ShapelessRecipeBuilder.func_200488_a((IItemProvider)((IItemProvider)VanillaEnum.CONCRETE_POWDER.get((Enum)dye)), (int)8).func_200490_a("concrete_powder").func_200487_b((IItemProvider)bottle).func_203221_a((ITag)ItemTags.field_203440_u).func_203221_a((ITag)ItemTags.field_203440_u).func_203221_a((ITag)ItemTags.field_203440_u).func_203221_a((ITag)ItemTags.field_203440_u).func_203221_a((ITag)Tags.Items.GRAVEL).func_203221_a((ITag)Tags.Items.GRAVEL).func_203221_a((ITag)Tags.Items.GRAVEL).func_203221_a((ITag)Tags.Items.GRAVEL).func_200483_a("has_item", (ICriterionInstance)hasBottle).func_200485_a(bottleConsumer, this.resource(bottleFolder + "concrete_powder/" + name));
        });
        IItemProvider blackBottle = (IItemProvider)InspirationsRecipes.simpleDyedWaterBottle.get((Enum)DyeColor.BLACK);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_151099_bA).func_200490_a(Objects.requireNonNull(Items.field_151099_bA.getRegistryName()).func_110623_a()).func_200487_b(blackBottle).func_203221_a((ITag)Tags.Items.FEATHERS).func_200487_b((IItemProvider)Items.field_151122_aG).func_200483_a("has_item", (ICriterionInstance)RecipesRecipeProvider.func_200403_a((IItemProvider)blackBottle)).func_200485_a(bottleConsumer, this.resource(bottleFolder + "writable_book"));
        this.addDyeableRecipes((IItemProvider)Items.field_151024_Q, folder, null);
        this.addDyeableRecipes((IItemProvider)Items.field_151027_R, folder, null);
        this.addDyeableRecipes((IItemProvider)Items.field_151026_S, folder, null);
        this.addDyeableRecipes((IItemProvider)Items.field_151021_T, folder, null);
        this.addDyeableRecipes((IItemProvider)Items.field_222110_op, folder, null);
        this.addDyeableRecipes((IItemProvider)InspirationsTools.dimensionCompass, folder, ConfigEnabledCondition.DIMENSION_COMPASS);
        CustomRecipeBuilder.func_218656_a(RecipeSerializers.CAULDRON_REMOVE_BANNER_PATTERN).func_200499_a(cauldronRecipes, this.resourceName(folder + "remove_banner_pattern"));
        String potionFolder = folder + "potion/";
        Consumer potionConsumer = this.withCondition(new ICondition[]{ConfigEnabledCondition.CAULDRON_POTIONS});
        potionConsumer.accept(new EmptyPotionCauldronRecipe.FinishedRecipe(this.resource(potionFolder + "normal_empty"), Items.field_151068_bn, Items.field_151069_bo));
        potionConsumer.accept(new FillPotionCauldronRecipe.FinishedRecipe(this.resource(potionFolder + "normal_fill"), SizedIngredient.fromItems((IItemProvider[])new IItemProvider[]{Items.field_151069_bo}), Items.field_151068_bn));
        potionConsumer.accept(new EmptyPotionCauldronRecipe.FinishedRecipe(this.resource(potionFolder + "splash_empty"), Items.field_185155_bH, InspirationsRecipes.splashBottle));
        potionConsumer.accept(new FillPotionCauldronRecipe.FinishedRecipe(this.resource(potionFolder + "splash_fill"), SizedIngredient.fromTag(InspirationsTags.Items.SPLASH_BOTTLES), Items.field_185155_bH));
        potionConsumer.accept(new EmptyPotionCauldronRecipe.FinishedRecipe(this.resource(potionFolder + "lingering_empty"), Items.field_185156_bI, InspirationsRecipes.lingeringBottle));
        potionConsumer.accept(new FillPotionCauldronRecipe.FinishedRecipe(this.resource(potionFolder + "lingering_fill"), SizedIngredient.fromTag(InspirationsTags.Items.LINGERING_BOTTLES), Items.field_185156_bI));
        this.withCondition(new ICondition[]{ConfigEnabledCondition.CAULDRON_TIP_ARROWS}).accept(new FillPotionCauldronRecipe.FinishedRecipe(this.resource(potionFolder + "tipped_arrow"), SizedIngredient.fromItems((int)16, (IItemProvider[])new IItemProvider[]{Items.field_151032_g}), Items.field_185167_i));
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)InspirationsRecipes.splashBottle).func_200487_b((IItemProvider)Items.field_151069_bo).func_200487_b((IItemProvider)Items.field_151069_bo).func_200487_b((IItemProvider)Items.field_151069_bo).func_203221_a((ITag)Tags.Items.GUNPOWDER).func_200483_a("has_item", (ICriterionInstance)RecipesRecipeProvider.func_200409_a((ITag)Tags.Items.GUNPOWDER)).func_200485_a(potionConsumer, this.prefix((IItemProvider)InspirationsRecipes.splashBottle, potionFolder));
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)InspirationsRecipes.lingeringBottle).func_203221_a(InspirationsTags.Items.SPLASH_BOTTLES).func_203221_a(InspirationsTags.Items.SPLASH_BOTTLES).func_203221_a(InspirationsTags.Items.SPLASH_BOTTLES).func_200487_b((IItemProvider)Items.field_185157_bK).func_200483_a("has_item", (ICriterionInstance)RecipesRecipeProvider.func_200403_a((IItemProvider)Items.field_185157_bK)).func_200485_a(potionConsumer, this.prefix((IItemProvider)InspirationsRecipes.lingeringBottle, potionFolder));
        Consumer brewingConsumer = this.withCondition(new ICondition[]{ConfigEnabledCondition.CAULDRON_BREWING});
        brewingConsumer.accept(new BrewingCauldronRecipe.FinishedRecipe(this.resource(potionFolder + "potion_brewing"), RecipeSerializers.CAULDRON_POTION_BREWING, false));
        brewingConsumer.accept(new BrewingCauldronRecipe.FinishedRecipe(this.resource(potionFolder + "forge_brewing"), RecipeSerializers.CAULDRON_FORGE_BREWING, false));
        brewingConsumer.accept(new PotionFermentCauldronTransform.FinishedRecipe(this.resource(potionFolder + "potion_ferment"), 600));
        this.addStewRecipe((IItemProvider)Items.field_185165_cW, Ingredient.func_199805_a((ITag)Tags.Items.CROPS_BEETROOT), 6, (Fluid)InspirationsRecipes.beetrootSoup, waterIngredient, folder + "beetroot_soup/");
        this.addStewRecipe((IItemProvider)Items.field_151009_A, Ingredient.func_199805_a((ITag)Tags.Items.MUSHROOMS), 2, (Fluid)InspirationsRecipes.mushroomStew, waterIngredient, folder + "mushroom_stew/");
        this.addStewRecipe((IItemProvider)InspirationsRecipes.potatoSoupItem, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151168_bH}), 2, (Fluid)InspirationsRecipes.potatoSoup, CauldronIngredients.FLUID.of(InspirationsRecipes.mushroomStew), folder + "potato_soup/");
        this.addStewRecipe((IItemProvider)Items.field_179560_bq, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_179559_bp}), 1, (Fluid)InspirationsRecipes.rabbitStew, CauldronIngredients.FLUID.of(InspirationsRecipes.potatoSoup), folder + "rabbit_stew/");
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)InspirationsRecipes.potatoSoupItem).func_200487_b((IItemProvider)Items.field_151054_z).func_200487_b((IItemProvider)Items.field_151168_bH).func_200487_b((IItemProvider)Items.field_151168_bH).func_203221_a((ITag)Tags.Items.MUSHROOMS).func_200483_a("has_item", (ICriterionInstance)RecipesRecipeProvider.func_200403_a((IItemProvider)Items.field_151168_bH)).func_200485_a(this.withCondition(new ICondition[0]), this.resource(folder + "potato_soup/item"));
    }

    private void addColoredRecipes(ITag<Item> tag, EnumObject<DyeColor, ? extends IItemProvider> enumObject, String folder, @Nullable ICondition condition) {
        this.addColoredRecipes(tag, enumObject, (IItemProvider)enumObject.get((Enum)DyeColor.WHITE), folder, false, condition);
    }

    private void addColoredRecipes(ITag<Item> tag, EnumObject<DyeColor, ? extends IItemProvider> enumObject, IItemProvider undyedItem, String folder, boolean copyNBT, @Nullable ICondition condition) {
        Consumer dyed;
        Consumer undyed;
        if (condition == null) {
            undyed = this.withCondition(new ICondition[]{ConfigEnabledCondition.CAULDRON_RECIPES});
            dyed = this.withCondition(new ICondition[]{ConfigEnabledCondition.CAULDRON_DYEING});
        } else {
            undyed = this.withCondition(new ICondition[]{ConfigEnabledCondition.CAULDRON_RECIPES, condition});
            dyed = this.withCondition(new ICondition[]{ConfigEnabledCondition.CAULDRON_DYEING, condition});
        }
        SizedIngredient ingredient = SizedIngredient.fromTag(tag);
        InventoryChangeTrigger.Instance criteria = RecipesRecipeProvider.func_200409_a(tag);
        CauldronRecipeBuilder undyedBuilder = (CauldronRecipeBuilder)CauldronRecipeBuilder.cauldron(ingredient, CauldronIngredients.FLUID.of(Fluids.field_204546_a)).minLevels(4).addLevels(-4).setOutput(undyedItem).addCriterion("has_item", (ICriterionInstance)criteria);
        if (copyNBT) {
            undyedBuilder.setCopyNBT();
        }
        undyedBuilder.build(undyed, this.resource(folder + "undye"));
        enumObject.forEach((arg_0, arg_1) -> this.lambda$addColoredRecipes$2(ingredient, (ICriterionInstance)criteria, copyNBT, dyed, folder, arg_0, arg_1));
    }

    private void addDyeableRecipes(IItemProvider dyeable, String folder, @Nullable ICondition extraCondition) {
        Ingredient ingredient = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{dyeable});
        (extraCondition == null ? this.withCondition(new ICondition[]{ConfigEnabledCondition.CAULDRON_RECIPES}) : this.withCondition(new ICondition[]{ConfigEnabledCondition.CAULDRON_RECIPES, extraCondition})).accept(DyeableCauldronRecipe.FinishedRecipe.clear(this.prefix(dyeable, folder + "dyeable/clear_"), ingredient));
        (extraCondition == null ? this.withCondition(new ICondition[]{ConfigEnabledCondition.CAULDRON_DYEING}) : this.withCondition(new ICondition[]{ConfigEnabledCondition.CAULDRON_DYEING, extraCondition})).accept(DyeableCauldronRecipe.FinishedRecipe.dye(this.prefix(dyeable, folder + "dyeable/dye_"), ingredient));
    }

    private void addStewRecipe(IItemProvider stewItem, Ingredient ingredient, int amount, Fluid stewFluid, ICauldronIngredient base, String folder) {
        Consumer consumer = this.withCondition(new ICondition[]{ConfigEnabledCondition.CAULDRON_FLUIDS});
        ContentMatchIngredient<Fluid> stewIngredient = CauldronIngredients.FLUID.of(stewFluid);
        ICauldronContents stewContents = CauldronContentTypes.FLUID.of(stewFluid);
        ((CauldronRecipeBuilder)CauldronRecipeBuilder.cauldron(SizedIngredient.fromItems((IItemProvider[])new IItemProvider[]{Items.field_151054_z}), stewIngredient).minLevels(4).addLevels(-4).setOutput(stewItem).setSound(SoundEvents.field_187615_H).addCriterion("has_item", (ICriterionInstance)RecipesRecipeProvider.func_200403_a((IItemProvider)Items.field_151054_z))).build(consumer, this.resource(folder + "fill_bowl"));
        ((CauldronRecipeBuilder)CauldronRecipeBuilder.cauldron(SizedIngredient.fromItems((IItemProvider[])new IItemProvider[]{stewItem}), stewIngredient).maxLevels(11).addLevels(4).setOutput((IItemProvider)Items.field_151054_z).setOutput(stewContents).noContainer().setSound(SoundEvents.field_191241_J).addCriterion("has_item", (ICriterionInstance)RecipesRecipeProvider.func_200403_a((IItemProvider)stewItem))).build(consumer, this.resource(folder + "empty_bowl"));
        InventoryChangeTrigger.Instance criteria = RecipesRecipeProvider.func_200403_a((IItemProvider)Blocks.field_150383_bp);
        ((CauldronRecipeBuilder)CauldronRecipeBuilder.cauldron(SizedIngredient.of((Ingredient)ingredient, (int)amount), base).levelRange(1, 4).setTemperature(TemperaturePredicate.BOILING).setOutput(stewContents).addCriterion("has_item", (ICriterionInstance)criteria)).build(consumer, this.resource(folder + "stew_small"));
        ((CauldronRecipeBuilder)CauldronRecipeBuilder.cauldron(SizedIngredient.of((Ingredient)ingredient, (int)(amount * 2)), base).minLevels(5).setTemperature(TemperaturePredicate.BOILING).setOutput(stewContents).addCriterion("has_item", (ICriterionInstance)criteria)).build(consumer, this.resource(folder + "stew_large"));
    }

    private void addDyedBottleMix(String folder, DyeColor output, DyeColor ... inputs) {
        this.addDyedBottleMix(folder, output, (ICondition)null, inputs);
    }

    private void addDyedBottleMix(String folder, DyeColor output, @Nullable ICondition extraCondition, DyeColor ... inputs) {
        ConsumerWrapperBuilder consumerBuilder = ConsumerWrapperBuilder.wrap((IRecipeSerializer)RecipeSerializers.SHAPELESS_NO_CONTAINER).addCondition((ICondition)ConfigEnabledCondition.CAULDRON_DYEING);
        if (extraCondition != null) {
            consumerBuilder.addCondition(extraCondition);
        }
        Consumer consumer = consumerBuilder.build(this.getConsumer());
        StringBuilder name = new StringBuilder(folder + output.func_176610_l() + "_from");
        Item outputItem = (Item)InspirationsRecipes.simpleDyedWaterBottle.get((Enum)output);
        ShapelessRecipeBuilder builder = ShapelessRecipeBuilder.func_200488_a((IItemProvider)outputItem, (int)inputs.length).func_200490_a(Objects.requireNonNull(outputItem.getRegistryName()).toString());
        EnumSet<DyeColor> seen = EnumSet.noneOf(DyeColor.class);
        for (DyeColor input : inputs) {
            IItemProvider bottle = (IItemProvider)InspirationsRecipes.simpleDyedWaterBottle.get((Enum)input);
            builder.func_200487_b(bottle);
            if (seen.contains(input)) continue;
            builder.func_200483_a("has_" + input.func_176610_l(), (ICriterionInstance)RecipesRecipeProvider.func_200403_a((IItemProvider)bottle));
            name.append("_").append(input.func_176610_l());
            seen.add(input);
        }
        builder.func_200484_a(consumer, this.resourceName(name.toString()));
    }

    private void addSurroundRecipe(Consumer<IFinishedRecipe> consumer, IItemProvider output, String group, ITag<Item> surround, IItemProvider center, ResourceLocation location) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)output, (int)8).func_200473_b(group).func_200469_a(Character.valueOf('#'), surround).func_200462_a(Character.valueOf('x'), center).func_200472_a("###").func_200472_a("#x#").func_200472_a("###").func_200465_a("has_item", (ICriterionInstance)RecipesRecipeProvider.func_200403_a((IItemProvider)center)).func_200467_a(consumer, location);
    }

    private void addComboRecipe(Consumer<IFinishedRecipe> consumer, IItemProvider output, String group, ITag<Item> input, IItemProvider modifier, ResourceLocation location) {
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)output).func_200490_a(group).func_203221_a(input).func_200487_b(modifier).func_200483_a("has_item", (ICriterionInstance)RecipesRecipeProvider.func_200403_a((IItemProvider)modifier)).func_200485_a(consumer, location);
    }

    private ResourceLocation prefixE(IForgeRegistryEntry<?> entry, String prefix) {
        return this.resource(prefix + Objects.requireNonNull(entry.getRegistryName()).func_110623_a());
    }

    private ResourceLocation wrapE(IForgeRegistryEntry<?> entry, String prefix, String suffix) {
        return this.resource(prefix + Objects.requireNonNull(entry.getRegistryName()).func_110623_a() + suffix);
    }

    private /* synthetic */ void lambda$addColoredRecipes$2(SizedIngredient ingredient, ICriterionInstance criteria, boolean copyNBT, Consumer dyed, String folder, DyeColor color, IItemProvider block) {
        CauldronRecipeBuilder coloredBuilder = (CauldronRecipeBuilder)CauldronRecipeBuilder.cauldron(ingredient, CauldronIngredients.DYE.of(color)).minLevels(4).addLevels(-4).setOutput(block).addCriterion("has_item", criteria);
        if (copyNBT) {
            coloredBuilder.setCopyNBT();
        }
        coloredBuilder.build(dyed, this.resource(folder + color.func_176610_l()));
    }
}

