/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.recipes.recipe.cauldron;

import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import knightminer.inspirations.library.recipe.DynamicFinishedRecipe;
import knightminer.inspirations.library.recipe.RecipeSerializer;
import knightminer.inspirations.library.recipe.RecipeSerializers;
import knightminer.inspirations.library.recipe.cauldron.CauldronContentTypes;
import knightminer.inspirations.library.recipe.cauldron.inventory.ICauldronInventory;
import knightminer.inspirations.library.recipe.cauldron.inventory.IModifyableCauldronInventory;
import knightminer.inspirations.library.recipe.cauldron.recipe.ICauldronRecipe;
import knightminer.inspirations.library.recipe.cauldron.util.CauldronTemperature;
import knightminer.inspirations.library.recipe.cauldron.util.DisplayCauldronRecipe;
import knightminer.inspirations.library.recipe.cauldron.util.TemperaturePredicate;
import knightminer.inspirations.library.util.ReflectionUtil;
import knightminer.inspirations.tweaks.recipe.NormalBrewingRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionBrewing;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.common.brewing.VanillaBrewingRecipe;
import slimeknights.mantle.recipe.IMultiRecipe;

public abstract class BrewingCauldronRecipe
implements ICauldronRecipe,
IMultiRecipe<DisplayCauldronRecipe> {
    private final ResourceLocation id;
    private final boolean instant;
    private List<DisplayCauldronRecipe> displayRecipes;

    protected BrewingCauldronRecipe(ResourceLocation id, boolean instant) {
        this.id = id;
        this.instant = instant;
    }

    public boolean matches(ICauldronInventory inv, World worldIn) {
        if (inv.getLevel() == 0 || inv.getTemperature() != CauldronTemperature.BOILING) {
            return false;
        }
        ItemStack stack = inv.getStack();
        if (stack.func_190926_b()) {
            return false;
        }
        return inv.getContents().get(CauldronContentTypes.POTION).filter(value -> this.getResult((Potion)value, stack) != Potions.field_185229_a).isPresent();
    }

    @Override
    public void handleRecipe(IModifyableCauldronInventory inventory) {
        inventory.getContents().get(CauldronContentTypes.POTION).ifPresent(potion -> {
            ItemStack stack = inventory.getStack();
            Potion output = this.getResult((Potion)potion, stack);
            if (output != Potions.field_185229_a) {
                inventory.setContents((this.instant ? CauldronContentTypes.POTION : CauldronContentTypes.UNFERMENTED_POTION).of(output));
                ItemStack container = stack.getContainerItem().func_77946_l();
                inventory.shrinkStack(1);
                inventory.setOrGiveStack(container);
                inventory.playSound(SoundEvents.field_187547_bF);
            }
        });
    }

    protected abstract Potion getResult(Potion var1, ItemStack var2);

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    protected DisplayCauldronRecipe makeRecipe(Potion input, Ingredient reagent, Potion output) {
        return DisplayCauldronRecipe.builder(12).setTemperature(TemperaturePredicate.BOILING).setItemInputs(Arrays.asList(reagent.func_193365_a())).setContentInputs(CauldronContentTypes.POTION.of(input)).setContentOutput((this.instant ? CauldronContentTypes.POTION : CauldronContentTypes.UNFERMENTED_POTION).of(output)).build();
    }

    protected abstract List<DisplayCauldronRecipe> getDisplayRecipes();

    public List<DisplayCauldronRecipe> getRecipes() {
        if (this.displayRecipes == null) {
            this.displayRecipes = this.getDisplayRecipes();
        }
        return this.displayRecipes;
    }

    public static class FinishedRecipe
    extends DynamicFinishedRecipe {
        private final boolean instant;

        public FinishedRecipe(ResourceLocation id, Serializer serializer, boolean instant) {
            super(id, serializer);
            this.instant = instant;
        }

        @Override
        public void func_218610_a(JsonObject json) {
            json.addProperty("instant", Boolean.valueOf(this.instant));
        }
    }

    public static class Serializer
    extends RecipeSerializer<BrewingCauldronRecipe> {
        private final BiFunction<ResourceLocation, Boolean, BrewingCauldronRecipe> factory;

        public Serializer(BiFunction<ResourceLocation, Boolean, BrewingCauldronRecipe> factory) {
            this.factory = factory;
        }

        public BrewingCauldronRecipe read(ResourceLocation id, JsonObject json) {
            boolean instant = JSONUtils.func_151212_i((JsonObject)json, (String)"instant");
            return this.factory.apply(id, instant);
        }

        @Nullable
        public BrewingCauldronRecipe read(ResourceLocation id, PacketBuffer buffer) {
            return this.factory.apply(id, buffer.readBoolean());
        }

        public void write(PacketBuffer buffer, BrewingCauldronRecipe recipe) {
            buffer.writeBoolean(recipe.instant);
        }
    }

    public static class Forge
    extends BrewingCauldronRecipe {
        private static final Function<Potion, ItemStack> POTION_ITEM_MAPPER = potion -> PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)potion);
        private final Map<Potion, ItemStack> potionItemLookup = new IdentityHashMap<Potion, ItemStack>();
        private IBrewingRecipe lastRecipe;

        public Forge(ResourceLocation id, boolean instant) {
            super(id, instant);
        }

        private static Potion tryRecipe(IBrewingRecipe recipe, ItemStack potion, ItemStack stack) {
            ItemStack outputStack = recipe.getOutput(potion, stack);
            if (!outputStack.func_190926_b()) {
                return PotionUtils.func_185191_c((ItemStack)outputStack);
            }
            return Potions.field_185229_a;
        }

        @Override
        protected Potion getResult(Potion potion, ItemStack stack) {
            Potion output;
            ItemStack input = this.potionItemLookup.computeIfAbsent(potion, POTION_ITEM_MAPPER);
            if (this.lastRecipe != null && (output = Forge.tryRecipe(this.lastRecipe, input, stack)) != Potions.field_185229_a) {
                return output;
            }
            for (IBrewingRecipe recipe : BrewingRecipeRegistry.getRecipes()) {
                Potion output2;
                if (recipe instanceof VanillaBrewingRecipe || (output2 = Forge.tryRecipe(recipe, input, stack)) == Potions.field_185229_a) continue;
                this.lastRecipe = recipe;
                return output2;
            }
            return Potions.field_185229_a;
        }

        @Override
        protected List<DisplayCauldronRecipe> getDisplayRecipes() {
            List recipes = BrewingRecipeRegistry.getRecipes();
            return Stream.concat(recipes.stream().filter(r -> r instanceof BrewingRecipe).map(r -> (BrewingRecipe)r).filter(r -> r.getOutput().func_77973_b() == Items.field_151068_bn).flatMap(recipe -> {
                Potion output = PotionUtils.func_185191_c((ItemStack)recipe.getOutput());
                if (output != Potions.field_185229_a) {
                    return Arrays.stream(recipe.getInput().func_193365_a()).filter(s -> s.func_77973_b() == Items.field_151068_bn).map(PotionUtils::func_185191_c).filter(pot -> pot != Potions.field_185229_a).map(input -> this.makeRecipe((Potion)input, recipe.getIngredient(), output));
                }
                return Stream.empty();
            }), recipes.stream().filter(r -> r instanceof NormalBrewingRecipe).map(r -> (NormalBrewingRecipe)r).filter(NormalBrewingRecipe::isEnabled).map(r -> this.makeRecipe(r.getStart(), r.getCatalyst(), r.getOutput()))).collect(Collectors.toList());
        }

        public IRecipeSerializer<?> func_199559_b() {
            return RecipeSerializers.CAULDRON_FORGE_BREWING;
        }
    }

    public static class Vanilla
    extends BrewingCauldronRecipe {
        private Object lastMix;

        public Vanilla(ResourceLocation id, boolean instant) {
            super(id, instant);
        }

        private static Potion tryMix(Object mix, Potion potion, ItemStack stack) {
            Potion output;
            Ingredient ingredient;
            if (ReflectionUtil.getMixPredicateInput(mix) == potion && (ingredient = ReflectionUtil.getMixPredicateReagent(mix)) != null && ingredient.test(stack) && (output = (Potion)ReflectionUtil.getMixPredicateOutput(mix)) != null) {
                return output;
            }
            return Potions.field_185229_a;
        }

        @Override
        protected Potion getResult(Potion potion, ItemStack stack) {
            Potion output;
            if (this.lastMix != null && (output = Vanilla.tryMix(this.lastMix, potion, stack)) != Potions.field_185229_a) {
                return output;
            }
            for (Object mix : PotionBrewing.field_185213_a) {
                Potion output2 = Vanilla.tryMix(mix, potion, stack);
                if (output2 == Potions.field_185229_a) continue;
                this.lastMix = mix;
                return output2;
            }
            return Potions.field_185229_a;
        }

        @Override
        protected List<DisplayCauldronRecipe> getDisplayRecipes() {
            return PotionBrewing.field_185213_a.stream().flatMap(mix -> {
                Potion input = (Potion)ReflectionUtil.getMixPredicateInput(mix);
                Potion output = (Potion)ReflectionUtil.getMixPredicateOutput(mix);
                Ingredient reagent = ReflectionUtil.getMixPredicateReagent(mix);
                if (input != null && output != null && reagent != null && !reagent.func_203189_d()) {
                    return Stream.of(this.makeRecipe(input, reagent, output));
                }
                return Stream.empty();
            }).collect(Collectors.toList());
        }

        public IRecipeSerializer<?> func_199559_b() {
            return RecipeSerializers.CAULDRON_POTION_BREWING;
        }
    }
}

