/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.recipes.recipe.cauldron.contents;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import knightminer.inspirations.library.recipe.cauldron.CauldronContentTypes;
import knightminer.inspirations.library.recipe.cauldron.contents.CauldronContentType;
import knightminer.inspirations.library.recipe.cauldron.contents.ICauldronContents;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class CauldronContents<C>
implements ICauldronContents {
    private final CauldronContentType<C> type;
    private final C value;

    public CauldronContents(CauldronContentType<C> type, C value) {
        this.type = type;
        this.value = value;
    }

    @Override
    public <T> Optional<T> get(CauldronContentType<T> type) {
        if (type == this.type) {
            return Optional.of(this.value);
        }
        return type.getOverrideValue(this);
    }

    @Override
    public CauldronContentType<?> getType() {
        return this.type;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", CauldronContentTypes.getName(this.type).toString());
        this.type.write(this.value, json);
        return json;
    }

    @Override
    public CompoundNBT toNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("type", CauldronContentTypes.getName(this.type).toString());
        this.type.write(this.value, nbt);
        return nbt;
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.func_192572_a(CauldronContentTypes.getName(this.type));
        this.type.write(this.value, buffer);
    }

    @Override
    public ResourceLocation getTextureName() {
        return this.type.getTexture(this.value);
    }

    @Override
    public int getTintColor() {
        return this.type.getColor(this.value);
    }

    @Override
    public ITextComponent getDisplayName() {
        return this.type.getDisplayName(this.value);
    }

    @Override
    public void addInformation(List<ITextComponent> tooltip, ITooltipFlag tooltipFlag) {
        this.type.addInformation(this.value, tooltip, tooltipFlag);
    }

    @Override
    @Nullable
    public String getModId() {
        return this.type.getModId(this.value);
    }

    @Override
    public String getName() {
        return this.type.getName(this.value);
    }

    @Override
    public <T> boolean matches(CauldronContentType<T> type, T value) {
        return this.type == type && this.value == value;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ICauldronContents)) {
            return false;
        }
        ICauldronContents contents = (ICauldronContents)other;
        return contents.matches(this.type, this.value);
    }

    @Override
    public int hashCode() {
        return 31 * this.type.hashCode() + this.value.hashCode();
    }

    public String toString() {
        return String.format("CauldronContents(%s,%s)", this.type.toString(), this.value.toString());
    }
}

