/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.tweaks;

import java.util.List;
import java.util.function.BooleanSupplier;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.common.ClientEvents;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.library.client.model.TrimModel;
import knightminer.inspirations.shared.SharedClientEvents;
import knightminer.inspirations.tweaks.InspirationsTweaks;
import knightminer.inspirations.tweaks.client.PortalColorHandler;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="inspirations", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class TweaksClientEvents
extends ClientEvents {
    @SubscribeEvent
    static void clientSetup(FMLClientSetupEvent event) {
        RenderType cutout = RenderType.func_228643_e_();
        RenderTypeLookup.setRenderLayer((Block)InspirationsTweaks.cactus, (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)InspirationsTweaks.sugarCane, (RenderType)cutout);
        MinecraftForge.EVENT_BUS.addListener(TweaksClientEvents::fixShieldTooltip);
    }

    @SubscribeEvent
    static void modelRegistry(ModelRegistryEvent event) {
        SharedClientEvents.configPack.addBlockstateReplacement((BooleanSupplier)Config.customPortalColor, Blocks.field_150427_aO, "nether_portal");
        SharedClientEvents.configPack.addItemModelReplacement((BooleanSupplier)Config.coloredEnchantedRibbons, (IItemProvider)Items.field_151134_bR, "enchanted_book");
        SharedClientEvents.configPack.addItemModelReplacement((BooleanSupplier)Config.coloredFireworkItems, (IItemProvider)Items.field_196152_dE, "fireworks");
        SharedClientEvents.configPack.addItemModelReplacement((BooleanSupplier)Config.betterCauldronItem, (IItemProvider)Items.field_222089_ms, "cauldron");
    }

    @SubscribeEvent
    static void registerModelLoaders(ModelRegistryEvent event) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)Inspirations.getResource("trim"), (IModelLoader)TrimModel.LOADER);
    }

    @SubscribeEvent
    static void registerBlockColors(ColorHandlerEvent.Block event) {
        BlockColors colors = event.getBlockColors();
        TweaksClientEvents.registerBlockColors(colors, (state, world, pos, index) -> {
            if (world == null || pos == null) {
                return -1;
            }
            return BiomeColors.func_228358_a_((IBlockDisplayReader)world, (BlockPos)pos);
        }, new Block[]{InspirationsTweaks.sugarCane});
        TweaksClientEvents.registerBlockColors(colors, PortalColorHandler.INSTANCE, Blocks.field_150427_aO);
    }

    @SubscribeEvent
    static void registerItemColors(ColorHandlerEvent.Item event) {
        ItemColors itemColors = event.getItemColors();
        TweaksClientEvents.registerItemColors(itemColors, (stack, tintIndex) -> {
            if (tintIndex == 0 && ((Boolean)Config.coloredEnchantedRibbons.get()).booleanValue()) {
                Enchantment.Rarity rarity = Enchantment.Rarity.COMMON;
                for (INBT tag : EnchantedBookItem.func_92110_g((ItemStack)stack)) {
                    Enchantment.Rarity newRarity;
                    ResourceLocation id;
                    Enchantment enchantment;
                    if (tag.func_74732_a() != 10 || (enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(id = new ResourceLocation(((CompoundNBT)tag).func_74779_i("id")))) == null || (newRarity = enchantment.func_77324_c()).func_185270_a() >= rarity.func_185270_a()) continue;
                    rarity = newRarity;
                }
                switch (rarity) {
                    case COMMON: {
                        return 16720209;
                    }
                    case UNCOMMON: {
                        return 14845997;
                    }
                    case RARE: {
                        return 65313;
                    }
                    case VERY_RARE: {
                        return 0x9F7FFF;
                    }
                }
            }
            return -1;
        }, new IItemProvider[]{Items.field_151134_bR});
        TweaksClientEvents.registerItemColors(itemColors, (stack, tintIndex) -> {
            if (!((Boolean)Config.coloredFireworkItems.get()).booleanValue()) {
                return -1;
            }
            CompoundNBT nbt = stack.func_179543_a("Fireworks");
            if (tintIndex == 2) {
                if (nbt != null && nbt.func_150297_b("Flight", 99)) {
                    byte flight = nbt.func_74771_c("Flight");
                    switch (flight) {
                        case 1: {
                            return 0x808080;
                        }
                        case 2: {
                            return 0x606060;
                        }
                        case 3: {
                            return 0x303030;
                        }
                    }
                    if (flight > 3) {
                        return 0;
                    }
                }
                return 0xA0A0A0;
            }
            if (tintIndex == 0 || tintIndex == 1) {
                int missing;
                int n = missing = tintIndex == 1 ? 13410704 : 0xC0C0C0;
                if (nbt == null) {
                    return missing;
                }
                ListNBT stars = nbt.func_150295_c("Explosions", 10);
                if (tintIndex >= stars.size()) {
                    return missing;
                }
                CompoundNBT star = stars.func_150305_b(tintIndex);
                int[] colors = star.func_74759_k("Colors");
                if (colors.length > 0) {
                    return colors[0];
                }
                return missing;
            }
            return -1;
        }, new IItemProvider[]{Items.field_196152_dE});
    }

    private static void fixShieldTooltip(ItemTooltipEvent event) {
        if (!((Boolean)Config.fixShieldTooltip.get()).booleanValue()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b() != Items.field_185159_cQ) {
            return;
        }
        CompoundNBT tags = stack.func_179543_a("BlockEntityTag");
        if (tags != null && tags.func_74764_b("Patterns") && stack.func_77948_v()) {
            List text = event.getToolTip();
            for (int i = text.size() - 1; i >= 0; --i) {
                ITextComponent component = (ITextComponent)text.get(i);
                if (!(component instanceof TranslationTextComponent) || !((TranslationTextComponent)component).func_150268_i().contains("banner")) continue;
                text.add(i + 1, StringTextComponent.field_240750_d_);
                break;
            }
        }
    }
}

