/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.utility.tileentity;

import javax.annotation.Nullable;
import knightminer.inspirations.utility.InspirationsUtility;
import knightminer.inspirations.utility.inventory.CollectorContainer;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.tileentity.InventoryTileEntity;
import slimeknights.mantle.util.WeakConsumerWrapper;

public class CollectorTileEntity
extends InventoryTileEntity {
    private static final ITextComponent TITLE = new TranslationTextComponent("gui.inspirations.collector");
    @Nullable
    private LazyOptional<IItemHandler> facingHandler;
    @Nullable
    private AxisAlignedBB itemBounds;
    private final NonNullConsumer<IItemHandler> extractItem = this::extractItem;
    private final NonNullConsumer<LazyOptional<IItemHandler>> facingInvalidator = new WeakConsumerWrapper((Object)this, (te, handler) -> {
        if (te.facingHandler == handler) {
            te.clearCachedInventories();
        }
    });

    public CollectorTileEntity() {
        super(InspirationsUtility.tileCollector, TITLE, 9);
    }

    public void collect() {
        if (this.field_145850_b == null) {
            return;
        }
        LazyOptional<IItemHandler> handler = this.getHandler();
        if (handler.isPresent()) {
            handler.ifPresent(this.extractItem);
        } else {
            boolean collected = false;
            for (ItemEntity entity : this.field_145850_b.func_217357_a(ItemEntity.class, this.getItemBounds())) {
                ItemStack insert = entity.func_92059_d();
                ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemHandler, (ItemStack)insert, (boolean)false);
                if (remainder.func_190916_E() >= insert.func_190916_E()) continue;
                collected = true;
                if (remainder.func_190926_b()) {
                    entity.func_70106_y();
                    continue;
                }
                entity.func_92058_a(remainder);
            }
            this.field_145850_b.func_217379_c(collected ? 1000 : 1001, this.field_174879_c, 0);
        }
    }

    private LazyOptional<IItemHandler> getHandler() {
        LazyOptional handler;
        if (this.facingHandler != null) {
            return this.facingHandler;
        }
        Direction facing = (Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208155_H);
        assert (this.field_145850_b != null);
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
        if (te != null && (handler = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())).isPresent()) {
            handler.addListener(this.facingInvalidator);
            this.facingHandler = handler;
            return this.facingHandler;
        }
        this.facingHandler = LazyOptional.empty();
        return this.facingHandler;
    }

    private AxisAlignedBB getItemBounds() {
        if (this.itemBounds == null) {
            BlockPos offset = this.field_174879_c.func_177972_a((Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208155_H));
            this.itemBounds = new AxisAlignedBB((double)offset.func_177958_n(), (double)offset.func_177956_o(), (double)offset.func_177952_p(), (double)(offset.func_177958_n() + 1), (double)(offset.func_177956_o() + 1), (double)(offset.func_177952_p() + 1));
        }
        return this.itemBounds;
    }

    private void extractItem(IItemHandler neighbor) {
        for (int i = 0; i < neighbor.getSlots(); ++i) {
            ItemStack simulated = neighbor.extractItem(i, 1, true);
            if (simulated.func_190926_b() || !ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemHandler, (ItemStack)simulated, (boolean)false).func_190926_b()) continue;
            neighbor.extractItem(i, 1, false);
            break;
        }
    }

    public void clearCachedInventories() {
        this.facingHandler = null;
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.clearCachedInventories();
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return slot < this.func_70302_i_();
    }

    @Nullable
    public Container createMenu(int winId, PlayerInventory playerInv, PlayerEntity player) {
        return new CollectorContainer(winId, playerInv, this);
    }
}

