/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item;

import cofh.core.item.ItemCoFH;
import cofh.lib.energy.EnergyContainerItemWrapper;
import cofh.lib.energy.IEnergyContainerItem;
import cofh.lib.item.ContainerType;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.StringHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;

public abstract class EnergyContainerItem
extends ItemCoFH
implements IEnergyContainerItem {
    protected int maxEnergy;
    protected int extract;
    protected int receive;

    protected EnergyContainerItem(Item.Properties builder, int maxEnergy, int extract, int receive) {
        super(builder);
        this.maxEnergy = maxEnergy;
        this.extract = extract;
        this.receive = receive;
        this.setEnchantability(5);
    }

    public EnergyContainerItem(Item.Properties builder, int maxEnergy, int maxTransfer) {
        this(builder, maxEnergy, maxTransfer, maxTransfer);
    }

    @Override
    protected void tooltipDelegate(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        boolean creative = this.isCreative(stack, ContainerType.ENERGY);
        tooltip.add((ITextComponent)StringHelper.getTextComponent(StringHelper.localize("info.cofh.energy") + ": " + (creative ? StringHelper.localize("info.cofh.infinite") : StringHelper.getScaledNumber(this.getEnergyStored(stack)) + " / " + StringHelper.getScaledNumber(this.getMaxEnergyStored(stack)) + " RF")));
        this.addEnergyTooltip(stack, worldIn, tooltip, flagIn, this.getExtract(stack), this.getReceive(stack), creative);
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return newStack.func_77973_b() != oldStack.func_77973_b() || this.getEnergyStored(oldStack) > 0 != this.getEnergyStored(newStack) > 0;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) && (slotChanged || this.getEnergyStored(oldStack) > 0 != this.getEnergyStored(newStack) > 0);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return !this.isCreative(stack, ContainerType.ENERGY) && this.getEnergyStored(stack) > 0;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 0xD01010;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            return 0.0;
        }
        return MathHelper.clamp(1.0 - (double)this.getEnergyStored(stack) / (double)this.getMaxEnergyStored(stack), 0.0, 1.0);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new EnergyContainerItemWrapper(stack, this, (Capability<? extends IEnergyStorage>)this.getEnergyCapability());
    }

    @Override
    public int getExtract(ItemStack container) {
        return this.extract;
    }

    @Override
    public int getReceive(ItemStack container) {
        return this.receive;
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return this.getMaxStored(container, this.maxEnergy);
    }
}

