/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item;

import cofh.core.item.ItemCoFH;
import cofh.core.util.helpers.FluidHelper;
import cofh.lib.fluid.FluidContainerItemWrapper;
import cofh.lib.fluid.IFluidContainerItem;
import cofh.lib.item.ContainerType;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.lib.util.helpers.XpHelper;
import cofh.lib.util.references.CoreReferences;
import cofh.lib.xp.IXpContainerItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class XpContainerItem
extends ItemCoFH
implements IXpContainerItem,
IFluidContainerItem {
    protected int xpCapacity;

    public XpContainerItem(Item.Properties builder, int xpCapacity) {
        super(builder);
        this.xpCapacity = xpCapacity;
        this.setEnchantability(5);
    }

    @Override
    protected void tooltipDelegate(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)StringHelper.getTextComponent(StringHelper.localize("info.cofh.amount") + ": " + StringHelper.getScaledNumber(this.getStoredXp(stack)) + " / " + StringHelper.getScaledNumber(this.getCapacityXP(stack))));
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return newStack.func_77973_b() != oldStack.func_77973_b() || !ItemHelper.areItemStacksEqualIgnoreTags(oldStack, newStack, "Fluid");
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) && (slotChanged || !ItemHelper.areItemStacksEqualIgnoreTags(oldStack, newStack, "Fluid"));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return !this.isCreative(stack, ContainerType.XP) && this.getStoredXp(stack) > 0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return MathHelper.clamp(1.0 - (double)this.getStoredXp(stack) / (double)this.getCapacityXP(stack), 0.0, 1.0);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 8039506;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (Utils.isFakePlayer((Entity)player)) {
            return ActionResult.func_226251_d_((Object)stack);
        }
        int curLevel = player.field_71068_ca;
        if (player.func_226563_dT_()) {
            int xp = XpHelper.getExtraPlayerXp(player) > 0 ? Math.min(XpHelper.getTotalXpForLevel(player.field_71068_ca + 1) - XpHelper.getTotalXpForLevel(player.field_71068_ca) - XpHelper.getExtraPlayerXp(player), this.getStoredXp(stack)) : Math.min(XpHelper.getTotalXpForLevel(player.field_71068_ca + 1) - XpHelper.getTotalXpForLevel(player.field_71068_ca), this.getStoredXp(stack));
            XpHelper.setPlayerXP(player, XpHelper.getPlayerXP(player) + xp);
            if (player.field_71068_ca < curLevel + 1 && XpHelper.getPlayerXP(player) >= XpHelper.getTotalXpForLevel(curLevel + 1)) {
                XpHelper.setPlayerLevel(player, curLevel + 1);
            }
            this.modifyXp(stack, -xp);
        } else if (XpHelper.getExtraPlayerXp(player) > 0) {
            int xp = Math.min(XpHelper.getExtraPlayerXp(player), this.getSpaceXP(stack));
            XpHelper.setPlayerXP(player, XpHelper.getPlayerXP(player) - xp);
            if (player.field_71068_ca < curLevel) {
                XpHelper.setPlayerLevel(player, curLevel);
            }
            this.modifyXp(stack, xp);
        } else if (player.field_71068_ca > 0) {
            int xp = Math.min(XpHelper.getTotalXpForLevel(player.field_71068_ca) - XpHelper.getTotalXpForLevel(player.field_71068_ca - 1), this.getSpaceXP(stack));
            XpHelper.setPlayerXP(player, XpHelper.getPlayerXP(player) - xp);
            if (player.field_71068_ca < curLevel - 1) {
                XpHelper.setPlayerLevel(player, curLevel - 1);
            }
            this.modifyXp(stack, xp);
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new FluidContainerItemWrapper(stack, this);
    }

    @Override
    public int getCapacityXP(ItemStack stack) {
        return this.getMaxStored(stack, this.xpCapacity);
    }

    @Override
    public FluidStack getFluid(ItemStack container) {
        int xp = this.getStoredXp(container);
        return xp > 0 ? new FluidStack((Fluid)CoreReferences.FLUID_XP, xp * 20) : FluidStack.EMPTY;
    }

    @Override
    public boolean isFluidValid(ItemStack container, FluidStack resource) {
        return FluidHelper.IS_XP.test(resource);
    }

    @Override
    public int getCapacity(ItemStack container) {
        return this.getCapacityXP(container) * 20;
    }

    @Override
    public int fill(ItemStack container, FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !this.isFluidValid(container, resource)) {
            return 0;
        }
        int xp = this.getStoredXp(container);
        int filled = Math.min(this.getCapacityXP(container) - xp, resource.getAmount() / 20);
        if (action.execute()) {
            this.modifyXp(container, filled);
        }
        return filled * 20;
    }

    @Override
    public FluidStack drain(ItemStack container, int maxDrain, IFluidHandler.FluidAction action) {
        int xp = this.getStoredXp(container);
        if (xp <= 0) {
            return FluidStack.EMPTY;
        }
        int drained = Math.min(xp, maxDrain / 20);
        if (action.execute() && !this.isCreative(container, ContainerType.FLUID)) {
            this.modifyXp(container, -drained);
        }
        return new FluidStack((Fluid)CoreReferences.FLUID_XP, drained * 20);
    }
}

