/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.entity;

import cofh.lib.entity.AbstractAoESpellEntity;
import cofh.lib.util.references.CoreReferences;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ElectricArcEntity
extends AbstractAoESpellEntity {
    public static final int defaultDuration = 10;
    protected boolean cosmetic = false;
    public float damage = 5.0f;
    public long seed = this.field_70146_Z.nextLong();

    public ElectricArcEntity(EntityType<? extends ElectricArcEntity> type, World world) {
        super((EntityType<? extends AbstractAoESpellEntity>)type, world);
        this.radius = 1.5f;
        this.duration = 10;
        this.field_70158_ak = true;
    }

    public ElectricArcEntity(World world, Vector3d pos) {
        this((EntityType<? extends ElectricArcEntity>)CoreReferences.ELECTRIC_ARC_ENTITY, world);
        this.func_233576_c_(pos);
    }

    public ElectricArcEntity(World world, Entity target) {
        this(world, target.func_213303_ch());
    }

    @Override
    public void activeTick() {
        if (this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_195594_a((IParticleData)CoreReferences.SPARK_PARTICLE, this.func_226277_ct_() + this.field_70146_Z.nextGaussian() * (double)this.radius, this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * 0.25f), this.func_226281_cx_() + this.field_70146_Z.nextGaussian() * (double)this.radius, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void onCast() {
        if (this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_195594_a((IParticleData)CoreReferences.PLASMA_PARTICLE, this.func_226277_ct_(), this.func_226278_cu_() + 8.0, this.func_226281_cx_(), 0.0, 0.0, 0.0);
        } else {
            this.strike();
        }
    }

    public boolean strike() {
        if (this.cosmetic) {
            return false;
        }
        boolean hitSomething = false;
        for (Entity entity : this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_186662_g((double)this.radius), Entity::func_70089_S)) {
            hitSomething |= this.attack(entity);
        }
        return hitSomething;
    }

    public boolean attack(Entity entity) {
        if (entity.func_70097_a(DamageSource.field_180137_b, this.damage)) {
            if (entity instanceof LivingEntity) {
                ((LivingEntity)entity).func_195064_c(new EffectInstance(CoreReferences.SHOCKED, 100, 0));
            }
            return true;
        }
        return false;
    }

    public ElectricArcEntity setDamage(float damage) {
        this.damage = damage;
        return this;
    }

    public ElectricArcEntity setRadius(float radius) {
        this.radius = radius;
        return this;
    }

    public ElectricArcEntity setCosmetic(boolean cosmetic) {
        this.cosmetic = cosmetic;
        return this;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distSqr) {
        double d0 = 64.0 * ElectricArcEntity.func_184183_bd();
        return distSqr < d0 * d0;
    }
}

