/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.fluid;

import cofh.lib.fluid.FluidStorageCoFH;
import cofh.lib.fluid.ManagedFluidHandler;
import cofh.lib.fluid.SimpleFluidHandler;
import cofh.lib.fluid.SimpleTankInv;
import cofh.lib.tileentity.ITileCallback;
import cofh.lib.util.StorageGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;

public class ManagedTankInv
extends SimpleTankInv {
    protected List<FluidStorageCoFH> inputTanks = new ArrayList<FluidStorageCoFH>();
    protected List<FluidStorageCoFH> outputTanks = new ArrayList<FluidStorageCoFH>();
    protected List<FluidStorageCoFH> internalTanks = new ArrayList<FluidStorageCoFH>();
    protected IFluidHandler inputHandler;
    protected IFluidHandler outputHandler;
    protected IFluidHandler ioHandler;
    protected IFluidHandler accessibleHandler;
    protected IFluidHandler internalHandler;

    public ManagedTankInv(ITileCallback tile) {
        super(tile);
    }

    public ManagedTankInv(ITileCallback tile, String tag) {
        super(tile, tag);
    }

    public void addTank(FluidStorageCoFH tank, StorageGroup group) {
        if (this.allHandler != null) {
            return;
        }
        this.tanks.add(tank);
        switch (group) {
            case INPUT: {
                this.inputTanks.add(tank);
                break;
            }
            case OUTPUT: {
                this.outputTanks.add(tank);
                break;
            }
            case INTERNAL: {
                this.internalTanks.add(tank);
                break;
            }
            case ACCESSIBLE: {
                this.inputTanks.add(tank);
                this.outputTanks.add(tank);
                break;
            }
        }
    }

    public void initHandlers() {
        ((ArrayList)this.tanks).trimToSize();
        ((ArrayList)this.inputTanks).trimToSize();
        ((ArrayList)this.outputTanks).trimToSize();
        ((ArrayList)this.internalTanks).trimToSize();
        this.inputHandler = new ManagedFluidHandler(this.callback, this.inputTanks, Collections.emptyList());
        this.outputHandler = new ManagedFluidHandler(this.callback, Collections.emptyList(), this.outputTanks);
        this.ioHandler = new ManagedFluidHandler(this.callback, this.inputTanks, this.outputTanks).restrict();
        this.accessibleHandler = new ManagedFluidHandler(this.callback, this.inputTanks, this.outputTanks);
        this.internalHandler = new SimpleFluidHandler(this.callback, this.internalTanks);
        this.allHandler = new SimpleFluidHandler(this.callback, this.tanks);
    }

    public boolean hasInputTanks() {
        return this.inputTanks.size() > 0;
    }

    public boolean hasOutputTanks() {
        return this.outputTanks.size() > 0;
    }

    public boolean hasAccessibleTanks() {
        return this.hasInputTanks() || this.hasOutputTanks();
    }

    public List<FluidStorageCoFH> getInputTanks() {
        return this.inputTanks;
    }

    public List<FluidStorageCoFH> getOutputTanks() {
        return this.outputTanks;
    }

    public List<FluidStorageCoFH> getInternalTanks() {
        return this.internalTanks;
    }

    @Override
    public IFluidHandler getHandler(StorageGroup group) {
        if (this.allHandler == null) {
            this.initHandlers();
        }
        switch (group) {
            case INPUT: {
                return this.inputHandler;
            }
            case OUTPUT: {
                return this.outputHandler;
            }
            case INPUT_OUTPUT: {
                return this.ioHandler;
            }
            case ACCESSIBLE: {
                return this.accessibleHandler;
            }
            case INTERNAL: {
                return this.internalHandler;
            }
            case ALL: {
                return this.allHandler;
            }
        }
        return EmptyFluidHandler.INSTANCE;
    }
}

