/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import cofh.lib.util.constants.Constants;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import net.minecraft.client.resources.I18n;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.StringUtils;

public final class StringHelper {
    public static final DecimalFormat DF0 = new DecimalFormat("#");
    public static final DecimalFormat DF2 = new DecimalFormat("#.##");

    private StringHelper() {
    }

    public static String titleCase(String input) {
        return input.substring(0, 1).toUpperCase(Locale.ROOT) + input.substring(1);
    }

    public static String localize(String key) {
        return I18n.func_135052_a((String)key, (Object[])new Object[0]);
    }

    public static String localize(String key, Object ... format) {
        return I18n.func_135052_a((String)key, (Object[])format);
    }

    public static boolean canLocalize(String key) {
        return I18n.func_188566_a((String)key);
    }

    public static String format(long number) {
        return StringUtils.normalizeSpace((String)NumberFormat.getInstance().format(number));
    }

    public static IFormattableTextComponent getFluidName(FluidStack stack) {
        Fluid fluid = stack.getFluid();
        IFormattableTextComponent name = fluid.getAttributes().getDisplayName(stack).func_230532_e_();
        switch (fluid.getAttributes().getRarity(stack)) {
            case UNCOMMON: {
                name.func_240699_a_(TextFormatting.YELLOW);
                break;
            }
            case RARE: {
                name.func_240699_a_(TextFormatting.AQUA);
                break;
            }
            case EPIC: {
                name.func_240699_a_(TextFormatting.LIGHT_PURPLE);
            }
        }
        return name;
    }

    public static ITextComponent getItemName(ItemStack stack) {
        Item item = stack.func_77973_b();
        IFormattableTextComponent name = item.func_200295_i(stack).func_230532_e_();
        switch (item.func_77613_e(stack)) {
            case UNCOMMON: {
                name.func_240699_a_(TextFormatting.YELLOW);
                break;
            }
            case RARE: {
                name.func_240699_a_(TextFormatting.AQUA);
                break;
            }
            case EPIC: {
                name.func_240699_a_(TextFormatting.LIGHT_PURPLE);
            }
        }
        return name;
    }

    public static String getScaledNumber(long number) {
        if (number >= 1000000000L) {
            return number / 1000000000L + "." + number % 1000000000L / 100000000L + number % 100000000L / 10000000L + "G";
        }
        if (number >= 1000000L) {
            return number / 1000000L + "." + number % 1000000L / 100000L + number % 100000L / 10000L + "M";
        }
        if (number >= 1000L) {
            return number / 1000L + "." + number % 1000L / 100L + number % 100L / 10L + "k";
        }
        return String.valueOf(number);
    }

    public static String toJSON(ITextComponent chatComponent) {
        return ITextComponent.Serializer.func_150696_a((ITextComponent)chatComponent);
    }

    public static ITextComponent fromJSON(String string) {
        return ITextComponent.Serializer.func_240644_b_((String)string);
    }

    public static IFormattableTextComponent getEmptyLine() {
        return new StringTextComponent("");
    }

    public static IFormattableTextComponent getTextComponent(String key) {
        return StringHelper.canLocalize(key) ? new TranslationTextComponent(key) : new StringTextComponent(key);
    }

    public static IFormattableTextComponent getInfoTextComponent(String key) {
        return StringHelper.getTextComponent(key).func_240699_a_(TextFormatting.GOLD);
    }

    public static IFormattableTextComponent getKeywordTextComponent(String key) {
        return StringHelper.getTextComponent(key).func_240703_c_(Constants.INVIS_STYLE);
    }

    public static String[] decompose(String resourceLoc, char delimiter) {
        return StringHelper.decompose("minecraft", resourceLoc, delimiter);
    }

    public static String[] decompose(String modid, String resourceLoc, char delimiter) {
        String[] decomposed = new String[]{modid, resourceLoc};
        int delIndex = resourceLoc.indexOf(delimiter);
        if (delIndex >= 0) {
            decomposed[1] = resourceLoc.substring(delIndex + 1);
            if (delIndex >= 1) {
                decomposed[0] = resourceLoc.substring(0, delIndex);
            }
        }
        return decomposed;
    }

    public static String namespace(String resourceLoc) {
        return StringHelper.decompose(resourceLoc, ':')[0];
    }

    public static String path(String resourceLoc) {
        return StringHelper.decompose(resourceLoc, ':')[1];
    }
}

