/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.common.logic.entityblocking;

import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.xalcon.torchmaster.Torchmaster;
import net.xalcon.torchmaster.TorchmasterConfig;
import net.xalcon.torchmaster.common.ModCaps;
import net.xalcon.torchmaster.common.logic.entityblocking.LightsRegistryCapability;

@Mod.EventBusSubscriber(modid="torchmaster")
public class EntityBlockingEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onCheckSpawn(LivingSpawnEvent.CheckSpawn event) throws InterruptedException {
        boolean log = (Boolean)TorchmasterConfig.GENERAL.logSpawnChecks.get();
        if (log) {
            Torchmaster.Log.debug("CheckSpawn - IsSpawner: {}, Reason: {}, Type: {}", (Object)event.isSpawner(), (Object)event.getSpawnReason(), (Object)event.getEntity().func_200600_R().getRegistryName());
        }
        if (!((Boolean)TorchmasterConfig.GENERAL.aggressiveSpawnChecks.get()).booleanValue() && event.getResult() == Event.Result.ALLOW) {
            return;
        }
        if (((Boolean)TorchmasterConfig.GENERAL.blockOnlyNaturalSpawns.get()).booleanValue() && event.isSpawner()) {
            return;
        }
        Entity entity = event.getEntity();
        World world = entity.func_130014_f_();
        BlockPos pos = new BlockPos(event.getX(), event.getY(), event.getZ());
        world.getCapability(ModCaps.TEB_REGISTRY).ifPresent(reg -> {
            if (reg.shouldBlockEntity(entity, pos)) {
                event.setResult(Event.Result.DENY);
                if (log) {
                    Torchmaster.Log.debug("Blocking spawn of {}", (Object)event.getEntity().func_200600_R().getRegistryName());
                }
            } else if (log) {
                Torchmaster.Log.debug("Allowed spawn of {}", (Object)event.getEntity().func_200600_R().getRegistryName());
            }
        });
    }

    @SubscribeEvent
    public static void onWorldAttachCapabilityEvent(AttachCapabilitiesEvent<World> event) {
        event.addCapability(new ResourceLocation("torchmaster", "registry"), (ICapabilityProvider)new LightsRegistryCapability());
    }

    @SubscribeEvent
    public static void onGlobalTick(TickEvent.ServerTickEvent event) {
        if (event.side == LogicalSide.CLIENT) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            if (Torchmaster.server == null) {
                return;
            }
            for (ServerWorld world : Torchmaster.server.func_212370_w()) {
                world.func_217381_Z().func_76320_a("torchmaster_" + world.func_234923_W_().func_240901_a_());
                world.getCapability(ModCaps.TEB_REGISTRY).ifPresent(reg -> reg.onGlobalTick((World)world));
                world.func_217381_Z().func_76319_b();
            }
        }
    }
}

