/*
 * Decompiled with CFR 0.152.
 */
package squeek.wailaharvestability.helpers;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.Items;
import net.minecraft.item.TieredItem;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class BlockHelper {
    public static final ToolType SWORD = ToolType.get((String)"sword");
    private static final HashMap<ToolType, ItemStack> testTools = new HashMap();

    public static ToolType getEffectiveToolOf(World world, BlockPos blockPos, BlockState state) {
        float hardness;
        ToolType effectiveTool = state.getHarvestTool();
        if (effectiveTool == null && (hardness = state.func_185887_b((IBlockReader)world, blockPos)) > 0.0f) {
            for (Map.Entry<ToolType, ItemStack> testToolEntry : testTools.entrySet()) {
                ItemStack testTool = testToolEntry.getValue();
                if (testTool == null || testTool.func_190926_b() || !(testTool.func_77973_b() instanceof TieredItem) || !(testTool.func_150997_a(state) >= ItemTier.WOOD.func_200928_b())) continue;
                effectiveTool = testToolEntry.getKey();
                break;
            }
        }
        return effectiveTool;
    }

    public static boolean isBlockUnbreakable(World world, BlockPos blockPos, BlockState state) {
        return state.func_185887_b((IBlockReader)world, blockPos) == -1.0f;
    }

    public static boolean isAdventureModeAndBlockIsUnbreakable(PlayerEntity player, BlockPos pos) {
        ClientPlayNetHandler netHandler = Minecraft.func_71410_x().func_147114_u();
        if (netHandler == null) {
            return false;
        }
        NetworkPlayerInfo networkplayerinfo = netHandler.func_175102_a(player.func_146103_bH().getId());
        GameType gameType = networkplayerinfo.func_178848_b();
        if (gameType != GameType.ADVENTURE) {
            return false;
        }
        if (player.func_175142_cm()) {
            return false;
        }
        ItemStack heldItem = player.func_184614_ca();
        World world = player.field_70170_p;
        return gameType == GameType.SPECTATOR || heldItem.func_190926_b() || !heldItem.func_206848_a(world.func_205772_D(), new CachedBlockInfo((IWorldReader)world, pos, false));
    }

    public static boolean canHarvestBlock(BlockState state, PlayerEntity player) {
        if (!state.func_235783_q_()) {
            return true;
        }
        ItemStack stack = player.func_184614_ca();
        ToolType tool = state.getHarvestTool();
        if (stack.func_190926_b() || tool == null) {
            return player.func_234569_d_(state);
        }
        int toolLevel = stack.func_77973_b().getHarvestLevel(stack, tool, player, state);
        if (toolLevel < 0) {
            return player.func_234569_d_(state);
        }
        return toolLevel >= state.getHarvestLevel();
    }

    static {
        testTools.put(ToolType.PICKAXE, new ItemStack((IItemProvider)Items.field_151039_o));
        testTools.put(ToolType.SHOVEL, new ItemStack((IItemProvider)Items.field_151038_n));
        testTools.put(ToolType.AXE, new ItemStack((IItemProvider)Items.field_151053_p));
        testTools.put(SWORD, new ItemStack((IItemProvider)Items.field_151041_m));
    }
}

