/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimals.imdlib.entity.util;

import dev.itsmeow.betteranimals.imdlib.entity.util.IVariant;
import dev.itsmeow.betteranimals.imdlib.entity.util.IVariantTypes;
import dev.itsmeow.betteranimals.imdlib.util.BiomeDictionary;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;

public interface ISelectiveVariantTypes<T extends MobEntity>
extends IVariantTypes<T> {
    @Override
    @Nullable
    default public ILivingEntityData initData(IWorld world, SpawnReason reason, ILivingEntityData livingdata) {
        if (this.getContainer().biomeVariants && (reason == SpawnReason.CHUNK_GENERATION || reason == SpawnReason.NATURAL)) {
            Biome biome = world.func_226691_t_(this.getImplementation().func_233580_cy_());
            Optional biomeKey = world.func_241828_r().func_243612_b(Registry.field_239720_u_).func_230519_c_((Object)biome);
            biomeKey.orElseThrow(() -> new RuntimeException("Biome provided to selective type generation has no ID found."));
            String[] validTypes = this.getTypesFor((RegistryKey<Biome>)((RegistryKey)biomeKey.get()), biome, BiomeDictionary.getTypes((RegistryKey<Biome>)((RegistryKey)biomeKey.get())), reason);
            String varStr = validTypes[this.getImplementation().func_70681_au().nextInt(validTypes.length)];
            IVariant variant = this.getContainer().getVariantForName(varStr);
            if (variant == null || !varStr.equals(variant.getName())) {
                throw new RuntimeException("Received invalid variant string from selective type: " + varStr + " on entity " + this.getContainer().entityName);
            }
            if (livingdata instanceof IVariantTypes.TypeData) {
                variant = ((IVariantTypes.TypeData)livingdata).typeData;
            } else {
                livingdata = new IVariantTypes.TypeData(variant);
            }
            this.setType(variant);
        } else {
            IVariant variant = this.getRandomType();
            if (livingdata instanceof IVariantTypes.TypeData) {
                variant = ((IVariantTypes.TypeData)livingdata).typeData;
            } else {
                livingdata = new IVariantTypes.TypeData(variant);
            }
            this.setType(variant);
        }
        return livingdata;
    }

    @Override
    @Nullable
    default public ILivingEntityData initAgeableData(IWorld world, SpawnReason reason, ILivingEntityData livingdata) {
        if (!this.getImplementation().func_70631_g_()) {
            if (this.getContainer().biomeVariants && (reason == SpawnReason.CHUNK_GENERATION || reason == SpawnReason.NATURAL)) {
                Biome biome = world.func_226691_t_(this.getImplementation().func_233580_cy_());
                Optional biomeKey = world.func_241828_r().func_243612_b(Registry.field_239720_u_).func_230519_c_((Object)biome);
                biomeKey.orElseThrow(() -> new RuntimeException("Biome provided to selective type generation has no ID found."));
                String[] validTypes = this.getTypesFor((RegistryKey<Biome>)((RegistryKey)biomeKey.get()), biome, BiomeDictionary.getTypes((RegistryKey<Biome>)((RegistryKey)biomeKey.get())), reason);
                String varStr = validTypes[this.getImplementation().func_70681_au().nextInt(validTypes.length)];
                IVariant variant = this.getContainer().getVariantForName(varStr);
                if (livingdata instanceof IVariantTypes.AgeableTypeData) {
                    variant = ((IVariantTypes.AgeableTypeData)((Object)livingdata)).typeData;
                } else {
                    livingdata = livingdata instanceof AgeableEntity.AgeableData ? new IVariantTypes.AgeableTypeData((AgeableEntity.AgeableData)livingdata, variant) : new IVariantTypes.AgeableTypeData(variant);
                }
                this.setType(variant);
            } else {
                IVariant variant = this.getRandomType();
                if (livingdata instanceof IVariantTypes.AgeableTypeData) {
                    variant = ((IVariantTypes.AgeableTypeData)((Object)livingdata)).typeData;
                } else {
                    livingdata = livingdata instanceof AgeableEntity.AgeableData ? new IVariantTypes.AgeableTypeData((AgeableEntity.AgeableData)livingdata, variant) : new IVariantTypes.AgeableTypeData(variant);
                }
                this.setType(variant);
            }
        }
        return livingdata;
    }

    public String[] getTypesFor(RegistryKey<Biome> var1, Biome var2, Set<BiomeDictionary.Type> var3, SpawnReason var4);
}

