/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui.component.input;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonArrow;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetTextFieldExtended;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;

public class WidgetNumberField
extends WidgetTextFieldExtended {
    private final boolean arrows;
    private ButtonArrow arrowUp;
    private ButtonArrow arrowDown;
    private int minValue = Integer.MIN_VALUE;
    private int maxValue = Integer.MAX_VALUE;
    private boolean isEnabled = true;

    public WidgetNumberField(FontRenderer fontrenderer, int x, int y, int width, int height, boolean arrows, ITextComponent narrationMessage, boolean background) {
        super(fontrenderer, x, y, width, height, narrationMessage, background);
        this.arrows = arrows;
        if (this.arrows) {
            this.arrowUp = new ButtonArrow(x, y + height / 2, (ITextComponent)new TranslationTextComponent("gui.cyclopscore.up"), button -> this.increase(), ButtonArrow.Direction.NORTH);
            this.arrowDown = new ButtonArrow(x, y + height / 2, (ITextComponent)new TranslationTextComponent("gui.cyclopscore.down"), button -> this.decrease(), ButtonArrow.Direction.SOUTH);
            this.arrowUp.field_230691_m_ -= this.arrowUp.func_238483_d_();
        }
        this.func_146185_a(true);
        this.func_146180_a("0");
    }

    public void func_146184_c(boolean enabled) {
        this.arrowUp.field_230693_o_ = enabled;
        this.arrowDown.field_230693_o_ = enabled;
        this.isEnabled = enabled;
        super.func_146184_c(enabled);
    }

    public boolean func_146181_i() {
        return false;
    }

    public void setPositiveOnly(boolean positiveOnly) {
        this.setMinValue(positiveOnly ? 0 : Integer.MIN_VALUE);
    }

    public int getMinValue() {
        return this.minValue;
    }

    public void setMinValue(int minValue) {
        this.minValue = minValue;
        this.updateArrowsState();
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    public int getInt() throws NumberFormatException {
        return this.validateNumber(Integer.parseInt(this.func_146179_b()));
    }

    public double getDouble() throws NumberFormatException {
        return this.validateNumber(Double.parseDouble(this.func_146179_b()));
    }

    public float getFloat() throws NumberFormatException {
        return this.validateNumber(Float.parseFloat(this.func_146179_b()));
    }

    @Override
    public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int offsetX = 0;
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.arrows) {
            this.arrowUp.func_230431_b_(matrixStack, mouseX, mouseY, partialTicks);
            this.arrowDown.func_230431_b_(matrixStack, mouseX, mouseY, partialTicks);
            offsetX = this.arrowUp.func_230998_h_();
            this.field_230690_l_ += offsetX;
            this.field_230688_j_ -= offsetX;
        }
        super.func_230431_b_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.arrows) {
            this.field_230690_l_ -= offsetX;
            this.field_230688_j_ += offsetX;
        }
    }

    public int validateNumber(int number) {
        return Math.max(this.minValue, Math.min(this.maxValue, number));
    }

    public double validateNumber(double number) {
        return Math.max((double)this.minValue, Math.min((double)this.maxValue, number));
    }

    public float validateNumber(float number) {
        return Math.max((float)this.minValue, Math.min((float)this.maxValue, number));
    }

    protected int getDiffAmount() {
        return MinecraftHelpers.isShifted() ? 10 : 1;
    }

    protected void increase() {
        try {
            this.func_146180_a(Integer.toString(this.validateNumber(this.getInt() + this.getDiffAmount())));
        }
        catch (NumberFormatException e) {
            this.func_146180_a("0");
        }
        this.updateArrowsState();
    }

    protected void decrease() {
        try {
            this.func_146180_a(Integer.toString(this.validateNumber(this.getInt() - this.getDiffAmount())));
        }
        catch (NumberFormatException e) {
            this.func_146180_a("0");
        }
        this.updateArrowsState();
    }

    @Override
    public void func_146180_a(String value) {
        super.func_146180_a(value);
        this.updateArrowsState();
    }

    public boolean func_231042_a_(char typedChar, int keyCode) {
        boolean ret = super.func_231042_a_(typedChar, keyCode);
        this.updateArrowsState();
        return ret;
    }

    public boolean func_231046_a_(int typedChar, int keyCode, int modifiers) {
        boolean ret = super.func_231046_a_(typedChar, keyCode, modifiers);
        this.updateArrowsState();
        return ret;
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        boolean ret = this.arrowUp.func_231044_a_(mouseX, mouseY, mouseButton) || this.arrowDown.func_231044_a_(mouseX, mouseY, mouseButton) || super.func_231044_a_(mouseX, mouseY, mouseButton);
        this.updateArrowsState();
        return ret;
    }

    protected void updateArrowsState() {
        if (this.arrows) {
            this.arrowDown.field_230693_o_ = true;
            this.arrowUp.field_230693_o_ = true;
            try {
                if (this.getInt() <= this.minValue) {
                    this.arrowDown.field_230693_o_ = false;
                }
                if (this.getInt() >= this.maxValue) {
                    this.arrowUp.field_230693_o_ = false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

