/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class CollectionHelpers {
    public static <K, V> void addToMapList(Map<K, List<V>> map, K key, V value) {
        LinkedList collection = map.get(key);
        if (collection == null) {
            collection = Lists.newLinkedList();
            map.put(key, collection);
        }
        collection.add(value);
    }

    public static <K, V> void addToMapSet(Map<K, Set<V>> map, K key, V value) {
        HashSet collection = map.get(key);
        if (collection == null) {
            collection = Sets.newHashSet();
            map.put(key, collection);
        }
        collection.add(value);
    }

    public static <T extends Comparable<T>> int compareCollection(Collection<? super T> a, Collection<? super T> b) {
        if (a.size() != b.size()) {
            return a.size() - b.size();
        }
        Object[] aArray = a.toArray();
        Object[] bArray = b.toArray();
        for (int i = 0; i < aArray.length; ++i) {
            int compComp = ((Comparable)aArray[i]).compareTo((Comparable)bArray[i]);
            if (compComp == 0) continue;
            return compComp;
        }
        return 0;
    }

    public static <T> int compareCollection(Collection<? super T> a, Collection<? super T> b, Comparator<T> comparator) {
        if (a.size() != b.size()) {
            return a.size() - b.size();
        }
        Object[] aArray = a.toArray();
        Object[] bArray = b.toArray();
        for (int i = 0; i < aArray.length; ++i) {
            int compComp = comparator.compare(aArray[i], bArray[i]);
            if (compComp == 0) continue;
            return compComp;
        }
        return 0;
    }
}

