/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class WorldHelpers {
    public static final int CHUNK_SIZE = 16;
    private static final double TICK_LAG_REDUCTION_MODULUS_MODIFIER = 1.0;

    public static boolean efficientTick(World world, int baseModulus, int ... params) {
        int mod = (int)((double)baseModulus * 1.0);
        if (mod == 0) {
            mod = 1;
        }
        int offset = 0;
        for (int param : params) {
            offset += param;
        }
        return world.field_73012_v.nextInt(mod) == Math.abs(offset) % mod;
    }

    public static boolean efficientTick(World world, int baseModulus, BlockPos blockPos) {
        return WorldHelpers.efficientTick(world, baseModulus, blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
    }

    public static <T, W extends IWorld> T foldArea(W world, int[] areaMin, int[] areaMax, BlockPos blockPos, WorldFoldingFunction<T, T, W> folder, T value) {
        int x = blockPos.func_177958_n();
        int y = blockPos.func_177956_o();
        int z = blockPos.func_177952_p();
        for (int xc = x - areaMin[0]; xc <= x + areaMax[0]; ++xc) {
            for (int yc = y - areaMin[1]; yc <= y + areaMax[1]; ++yc) {
                for (int zc = z - areaMin[2]; zc <= z + areaMax[2]; ++zc) {
                    value = folder.apply(value, world, new BlockPos(xc, yc, zc));
                }
            }
        }
        return value;
    }

    public static <T, W extends IWorld> T foldArea(W world, int area, BlockPos blockPos, WorldFoldingFunction<T, T, W> folder, T value) {
        return WorldHelpers.foldArea(world, new int[]{area, area, area}, new int[]{area, area, area}, blockPos, folder, value);
    }

    public static interface WorldFoldingFunction<F, T, W> {
        @Nullable
        public T apply(@Nullable F var1, W var2, BlockPos var3);
    }
}

