/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral;

import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.util.ChunkManager;
import de.srendi.advancedperipherals.lib.peripherals.BasePeripheral;
import de.srendi.advancedperipherals.lib.peripherals.owner.TurtlePeripheralOwner;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChunkyPeripheral
extends BasePeripheral<TurtlePeripheralOwner> {
    public static final String TYPE = "chunky";
    private static final String UUID_TAG = "uuid";
    @Nullable
    private ChunkPos loadedChunk;

    public ChunkyPeripheral(ITurtleAccess turtle, TurtleSide side) {
        super(TYPE, new TurtlePeripheralOwner(turtle, side));
    }

    protected UUID getUUID() {
        CompoundNBT data = ((TurtlePeripheralOwner)this.owner).getDataStorage();
        if (!data.func_74764_b(UUID_TAG)) {
            data.func_186854_a(UUID_TAG, UUID.randomUUID());
            ((TurtlePeripheralOwner)this.owner).markDataStorageDirty();
        }
        return data.func_186857_a(UUID_TAG);
    }

    public ChunkPos getChunkPos() {
        return this.getWorld().func_175726_f(this.getPos()).func_76632_l();
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)APConfig.PERIPHERALS_CONFIG.ENABLE_CHUNKY_TURTLE.get();
    }

    public void updateChunkState() {
        ServerWorld world = (ServerWorld)this.getWorld();
        ChunkManager manager = ChunkManager.get(world);
        ChunkPos currentChunk = this.getChunkPos();
        if (this.loadedChunk == null || !this.loadedChunk.equals((Object)currentChunk)) {
            this.setLoadedChunk(currentChunk, manager, world);
        } else {
            manager.touch(this.getUUID());
        }
    }

    protected void setLoadedChunk(@Nullable ChunkPos newChunk, ChunkManager manager, ServerWorld world) {
        if (this.loadedChunk != null) {
            manager.removeForceChunk(world, this.getUUID(), this.loadedChunk);
            this.loadedChunk = null;
        }
        if (newChunk != null) {
            this.loadedChunk = newChunk;
            manager.addForceChunk(world, this.getUUID(), this.loadedChunk);
        }
    }

    @Override
    public void detach(@NotNull IComputerAccess computer) {
        super.detach(computer);
        ServerWorld world = (ServerWorld)((TurtlePeripheralOwner)this.owner).getWorld();
        ChunkManager manager = ChunkManager.get(Objects.requireNonNull(world));
        this.setLoadedChunk(null, manager, world);
    }
}

