/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral;

import com.refinedmods.refinedstorage.api.autocrafting.task.CalculationResultType;
import com.refinedmods.refinedstorage.api.autocrafting.task.ICalculationResult;
import com.refinedmods.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.util.Action;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import de.srendi.advancedperipherals.common.addons.refinedstorage.RefinedStorage;
import de.srendi.advancedperipherals.common.addons.refinedstorage.RefinedStorageNode;
import de.srendi.advancedperipherals.common.blocks.tileentity.RsBridgeTile;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.util.ItemUtil;
import de.srendi.advancedperipherals.lib.peripherals.BasePeripheral;
import de.srendi.advancedperipherals.lib.peripherals.owner.TileEntityPeripheralOwner;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class RsBridgePeripheral
extends BasePeripheral<TileEntityPeripheralOwner<RsBridgeTile>> {
    public static final String TYPE = "rsBridge";

    public RsBridgePeripheral(RsBridgeTile tileEntity) {
        super(TYPE, new TileEntityPeripheralOwner<RsBridgeTile>(tileEntity));
    }

    private RefinedStorageNode getNode() {
        return (RefinedStorageNode)((RsBridgeTile)((TileEntityPeripheralOwner)this.owner).tileEntity).getNode();
    }

    private INetwork getNetwork() {
        return this.getNode().getNetwork();
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)APConfig.PERIPHERALS_CONFIG.ENABLE_RS_BRIDGE.get();
    }

    @LuaFunction(mainThread=true)
    public final Object listItems() {
        return RefinedStorage.listItems(this.getNetwork());
    }

    @LuaFunction(mainThread=true)
    public final Integer getMaxItemDiskStorage() {
        return RefinedStorage.getMaxItemDiskStorage(this.getNetwork());
    }

    @LuaFunction(mainThread=true)
    public final Integer getMaxFluidDiskStorage() {
        return RefinedStorage.getMaxFluidDiskStorage(this.getNetwork());
    }

    @LuaFunction(mainThread=true)
    public final Integer getMaxItemExternalStorage() {
        return RefinedStorage.getMaxItemExternalStorage(this.getNetwork());
    }

    @LuaFunction(mainThread=true)
    public final Integer getMaxFluidExternalStorage() {
        return RefinedStorage.getMaxFluidExternalStorage(this.getNetwork());
    }

    @LuaFunction(mainThread=true)
    public final Object listFluids() {
        return RefinedStorage.listFluids(this.getNetwork());
    }

    @LuaFunction(mainThread=true)
    public final int getEnergyUsage() {
        return this.getNetwork().getEnergyUsage();
    }

    @LuaFunction(mainThread=true)
    public final int getMaxEnergyStorage() {
        return this.getNetwork().getEnergyStorage().getMaxEnergyStored();
    }

    @LuaFunction(mainThread=true)
    public final int getEnergyStorage() {
        return this.getNetwork().getEnergyStorage().getEnergyStored();
    }

    @LuaFunction(mainThread=true)
    public final Object getPattern(IArguments arguments) throws LuaException {
        return RefinedStorage.getObjectFromPattern(this.getNetwork().getCraftingManager().getPattern(ItemUtil.getItemStackRS(arguments.getTable(0), RefinedStorage.getItems(this.getNetwork()))));
    }

    @LuaFunction(mainThread=true)
    public final int exportItem(IArguments arguments) throws LuaException {
        IItemHandler inventory;
        ItemStack stack = ItemUtil.getItemStackRS(arguments.getTable(0), RefinedStorage.getItems(this.getNetwork()));
        Direction direction = this.validateSide(arguments.getString(1));
        TileEntity targetEntity = ((RsBridgeTile)((TileEntityPeripheralOwner)this.owner).tileEntity).func_145831_w().func_175625_s(((RsBridgeTile)((TileEntityPeripheralOwner)this.owner).tileEntity).func_174877_v().func_177972_a(direction));
        IItemHandler iItemHandler = inventory = targetEntity != null ? (IItemHandler)targetEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.func_176734_d()).resolve().orElse(null) : null;
        if (inventory == null) {
            throw new LuaException("No valid inventory at " + arguments.getString(1));
        }
        ItemStack extracted = this.getNetwork().extractItem(stack, stack.func_190916_E(), 1, Action.SIMULATE);
        if (extracted.func_190926_b()) {
            return 0;
        }
        int transferableAmount = extracted.func_190916_E();
        ItemStack remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)extracted, (boolean)true);
        if (!remaining.func_190926_b()) {
            transferableAmount -= remaining.func_190916_E();
        }
        if (!(remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)(extracted = this.getNetwork().extractItem(stack, transferableAmount, 1, Action.PERFORM)), (boolean)false)).func_190926_b()) {
            this.getNetwork().insertItem(remaining, remaining.func_190916_E(), Action.PERFORM);
        }
        return transferableAmount;
    }

    @LuaFunction(mainThread=true)
    public final int importItem(IArguments arguments) throws LuaException {
        IItemHandler inventory;
        ItemStack stack = ItemUtil.getItemStackRS(arguments.getTable(0), RefinedStorage.getItems(this.getNetwork()));
        Direction direction = this.validateSide(arguments.getString(1));
        TileEntity targetEntity = ((RsBridgeTile)((TileEntityPeripheralOwner)this.owner).tileEntity).func_145831_w().func_175625_s(((RsBridgeTile)((TileEntityPeripheralOwner)this.owner).tileEntity).func_174877_v().func_177972_a(direction));
        IItemHandler iItemHandler = inventory = targetEntity != null ? (IItemHandler)targetEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.func_176734_d()).resolve().orElse(null) : null;
        if (inventory == null) {
            throw new LuaException("No valid inventory at " + arguments.getString(1));
        }
        int amount = stack.func_190916_E();
        int transferableAmount = 0;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack insertedStack;
            if (!inventory.getStackInSlot(i).func_77969_a(stack)) continue;
            if (inventory.getStackInSlot(i).func_190916_E() >= amount) {
                insertedStack = this.getNetwork().insertItem(stack, amount, Action.PERFORM);
                inventory.extractItem(i, amount - insertedStack.func_190916_E(), false);
                transferableAmount += amount - insertedStack.func_190916_E();
                break;
            }
            amount -= inventory.getStackInSlot(i).func_190916_E();
            insertedStack = this.getNetwork().insertItem(stack, inventory.getStackInSlot(i).func_190916_E(), Action.PERFORM);
            inventory.extractItem(i, inventory.getStackInSlot(i).func_190916_E() - insertedStack.func_190916_E(), false);
            transferableAmount += inventory.getStackInSlot(i).func_190916_E() - insertedStack.func_190916_E();
        }
        return transferableAmount;
    }

    @LuaFunction(mainThread=true)
    public final int exportItemToPeripheral(IComputerAccess computer, IArguments arguments) throws LuaException {
        IItemHandler inventory;
        ItemStack stack = ItemUtil.getItemStackRS(arguments.getTable(0), RefinedStorage.getItems(this.getNetwork()));
        IPeripheral chest = computer.getAvailablePeripheral(arguments.getString(1));
        if (chest == null) {
            throw new LuaException("No valid inventory block for " + arguments.getString(1));
        }
        TileEntity targetEntity = (TileEntity)chest.getTarget();
        IItemHandler iItemHandler = inventory = targetEntity != null ? (IItemHandler)targetEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).resolve().orElse(null) : null;
        if (inventory == null) {
            throw new LuaException("No valid inventory for " + arguments.getString(1));
        }
        ItemStack extracted = this.getNetwork().extractItem(stack, stack.func_190916_E(), 1, Action.SIMULATE);
        if (extracted.func_190926_b()) {
            return 0;
        }
        int transferableAmount = extracted.func_190916_E();
        ItemStack remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)extracted, (boolean)true);
        if (!remaining.func_190926_b()) {
            transferableAmount -= remaining.func_190916_E();
        }
        if (!(remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)(extracted = this.getNetwork().extractItem(stack, transferableAmount, 1, Action.PERFORM)), (boolean)false)).func_190926_b()) {
            this.getNetwork().insertItem(remaining, remaining.func_190916_E(), Action.PERFORM);
        }
        return transferableAmount;
    }

    @LuaFunction(mainThread=true)
    public final int importItemFromPeripheral(IComputerAccess computer, IArguments arguments) throws LuaException {
        IItemHandler inventory;
        ItemStack stack = ItemUtil.getItemStackRS(arguments.getTable(0), RefinedStorage.getItems(this.getNetwork()));
        IPeripheral chest = computer.getAvailablePeripheral(arguments.getString(1));
        int count = stack.func_190916_E();
        if (chest == null) {
            throw new LuaException("No inventory block for " + arguments.getString(1));
        }
        TileEntity targetEntity = (TileEntity)chest.getTarget();
        IItemHandler iItemHandler = inventory = targetEntity != null ? (IItemHandler)targetEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).resolve().orElse(null) : null;
        if (inventory == null) {
            throw new LuaException("No valid inventory for " + arguments.getString(1));
        }
        int amount = count;
        int transferableAmount = 0;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack insertedStack;
            if (!inventory.getStackInSlot(i).func_77969_a(stack)) continue;
            if (inventory.getStackInSlot(i).func_190916_E() >= amount) {
                insertedStack = this.getNetwork().insertItem(stack, amount, Action.PERFORM);
                inventory.extractItem(i, amount - insertedStack.func_190916_E(), false);
                transferableAmount += amount - insertedStack.func_190916_E();
                break;
            }
            amount = count - inventory.getStackInSlot(i).func_190916_E();
            insertedStack = this.getNetwork().insertItem(stack, inventory.getStackInSlot(i).func_190916_E(), Action.PERFORM);
            inventory.extractItem(i, inventory.getStackInSlot(i).func_190916_E() - insertedStack.func_190916_E(), false);
            transferableAmount += inventory.getStackInSlot(i).func_190916_E() - insertedStack.func_190916_E();
        }
        return transferableAmount;
    }

    @LuaFunction(mainThread=true)
    public final Object getItem(IArguments arguments) throws LuaException {
        return RefinedStorage.getItem(this.getNetwork(), ItemUtil.getItemStackRS(arguments.getTable(0), RefinedStorage.getItems(this.getNetwork())));
    }

    @LuaFunction(mainThread=true)
    public final boolean craftItem(IArguments arguments) throws LuaException {
        ItemStack stack = ItemUtil.getItemStackRS(arguments.getTable(0), RefinedStorage.getItems(this.getNetwork()));
        if (stack == null) {
            throw new LuaException("The item " + arguments.getTable(0).get("name") + "is not craftable");
        }
        ICalculationResult result = this.getNetwork().getCraftingManager().create(stack, stack.func_190916_E());
        CalculationResultType type = result.getType();
        if (result.getType() == CalculationResultType.OK) {
            this.getNetwork().getCraftingManager().start(result.getTask());
        }
        return type == CalculationResultType.OK;
    }

    @LuaFunction(mainThread=true)
    public final boolean craftFluid(String fluid, int count) {
        ICalculationResult result = this.getNetwork().getCraftingManager().create(new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluid)), 0), count);
        CalculationResultType type = result.getType();
        if (result.getType() == CalculationResultType.OK) {
            this.getNetwork().getCraftingManager().start(result.getTask());
        }
        return type == CalculationResultType.OK;
    }

    @LuaFunction(mainThread=true)
    public final boolean isItemCrafting(String item) {
        ItemStack stack = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(item)));
        for (ICraftingTask task : this.getNetwork().getCraftingManager().getTasks()) {
            ItemStack taskStack = task.getRequested().getItem();
            if (!taskStack.func_77969_a(stack)) continue;
            return true;
        }
        return false;
    }

    @LuaFunction(mainThread=true)
    public final boolean isItemCraftable(IArguments arguments) throws LuaException {
        ItemStack stack = ItemUtil.getItemStackRS(arguments.getTable(0), RefinedStorage.getItems(this.getNetwork()));
        return RefinedStorage.isItemCraftable(this.getNetwork(), stack);
    }
}

