/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.mekanism;

import dan200.computercraft.api.lua.LuaFunction;
import de.srendi.advancedperipherals.lib.peripherals.TileEntityIntegrationPeripheral;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.common.capabilities.merged.MergedTank;
import mekanism.common.content.tank.TankMultiblockData;
import mekanism.common.tile.multiblock.TileEntityDynamicValve;
import net.minecraft.tileentity.TileEntity;

public class DynamicTankIntegration
extends TileEntityIntegrationPeripheral<TileEntityDynamicValve> {
    public DynamicTankIntegration(TileEntity entity) {
        super(entity);
    }

    @Nonnull
    public String getType() {
        return "dynamicTank";
    }

    @LuaFunction(mainThread=true)
    public final Map<String, Object> getStored() {
        HashMap<String, Object> result = new HashMap<String, Object>(3);
        switch (this.getTank().getCurrentType()) {
            case GAS: {
                result.put("name", ((Gas)this.getTank().getGasTank().getType()).getRegistryName().toString());
                result.put("amount", this.getTank().getGasTank().getStored());
                break;
            }
            case FLUID: {
                result.put("name", this.getTank().getFluidTank().getFluid().getFluid().getRegistryName().toString());
                result.put("amount", this.getTank().getFluidTank().getFluidAmount());
                break;
            }
            case SLURRY: {
                result.put("name", ((Slurry)this.getTank().getSlurryTank().getType()).getRegistryName().toString());
                result.put("amount", this.getTank().getSlurryTank().getStored());
                break;
            }
            case PIGMENT: {
                result.put("name", ((Pigment)this.getTank().getPigmentTank().getType()).getRegistryName().toString());
                result.put("amount", this.getTank().getPigmentTank().getStored());
                break;
            }
            case INFUSION: {
                result.put("name", ((InfuseType)this.getTank().getInfusionTank().getType()).getRegistryName().toString());
                result.put("amount", this.getTank().getInfusionTank().getStored());
                break;
            }
            case EMPTY: {
                result.put("name", "EMPTY");
                result.put("amount", 0);
            }
        }
        result.put("type", this.getTank().getCurrentType().toString());
        return result;
    }

    @LuaFunction(mainThread=true)
    public final long getCapacity() {
        return ((TankMultiblockData)((TileEntityDynamicValve)this.tileEntity).getMultiblock()).getTankCapacity();
    }

    @LuaFunction(mainThread=true)
    public final double getFilledPercentage() {
        switch (this.getTank().getCurrentType()) {
            case GAS: {
                return (double)this.getTank().getGasTank().getStored() / (double)this.getCapacity();
            }
            case FLUID: {
                return (double)this.getTank().getFluidTank().getFluidAmount() / (double)this.getCapacity();
            }
            case SLURRY: {
                return (double)this.getTank().getSlurryTank().getStored() / (double)this.getCapacity();
            }
            case PIGMENT: {
                return (double)this.getTank().getPigmentTank().getStored() / (double)this.getCapacity();
            }
            case INFUSION: {
                return (double)this.getTank().getInfusionTank().getStored() / (double)this.getCapacity();
            }
            case EMPTY: {
                return 0.0;
            }
        }
        return 0.0;
    }

    @LuaFunction(mainThread=true)
    public final long getNeeded() {
        switch (this.getTank().getCurrentType()) {
            case GAS: {
                return this.getTank().getGasTank().getNeeded();
            }
            case FLUID: {
                return this.getTank().getFluidTank().getNeeded();
            }
            case SLURRY: {
                return this.getTank().getSlurryTank().getNeeded();
            }
            case PIGMENT: {
                return this.getTank().getPigmentTank().getNeeded();
            }
            case INFUSION: {
                return this.getTank().getInfusionTank().getNeeded();
            }
            case EMPTY: {
                return this.getCapacity();
            }
        }
        return 0L;
    }

    @LuaFunction(mainThread=true)
    public final boolean isEmpty() {
        return ((TankMultiblockData)((TileEntityDynamicValve)this.tileEntity).getMultiblock()).isEmpty();
    }

    private MergedTank getTank() {
        return ((TankMultiblockData)((TileEntityDynamicValve)this.tileEntity).getMultiblock()).mergedTank;
    }
}

