/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.mekanismgenerators;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import de.srendi.advancedperipherals.lib.peripherals.TileEntityIntegrationPeripheral;
import java.util.HashMap;
import java.util.Map;
import mekanism.api.chemical.ChemicalStack;
import mekanism.generators.common.content.fission.FissionReactorMultiblockData;
import mekanism.generators.common.tile.fission.TileEntityFissionReactorLogicAdapter;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;

public class FissionIntegration
extends TileEntityIntegrationPeripheral<TileEntityFissionReactorLogicAdapter> {
    public FissionIntegration(TileEntity entity) {
        super(entity);
    }

    public String getType() {
        return "fissionReactor";
    }

    @LuaFunction(mainThread=true)
    public final Map<String, Object> getCoolant() {
        HashMap<String, Object> wrapped = new HashMap<String, Object>(2);
        if (this.getReactor().fluidCoolantTank.isEmpty() && !this.getReactor().gasCoolantTank.isEmpty()) {
            ChemicalStack stack = this.getReactor().gasCoolantTank.getStack();
            wrapped.put("name", stack.getType().getRegistryName() == null ? null : stack.getType().getRegistryName().toString());
            wrapped.put("amount", stack.getAmount());
            return wrapped;
        }
        FluidStack stack = this.getReactor().fluidCoolantTank.getFluid();
        wrapped.put("name", stack.getFluid().getRegistryName() == null ? null : stack.getFluid().getRegistryName().toString());
        wrapped.put("amount", stack.getAmount());
        return wrapped;
    }

    @LuaFunction(mainThread=true)
    public final long getCoolantCapacity() {
        if (this.getReactor().fluidCoolantTank.isEmpty() && !this.getReactor().gasCoolantTank.isEmpty()) {
            return this.getReactor().gasCoolantTank.getCapacity();
        }
        return this.getReactor().fluidCoolantTank.getCapacity();
    }

    @LuaFunction(mainThread=true)
    public final long getCoolantNeeded() {
        if (this.getReactor().fluidCoolantTank.isEmpty() && !this.getReactor().gasCoolantTank.isEmpty()) {
            return this.getReactor().gasCoolantTank.getNeeded();
        }
        return this.getReactor().fluidCoolantTank.getNeeded();
    }

    @LuaFunction(mainThread=true)
    public final double getCoolantFilledPercentage() {
        if (this.getReactor().fluidCoolantTank.isEmpty() && !this.getReactor().gasCoolantTank.isEmpty()) {
            return (double)this.getReactor().gasCoolantTank.getStored() / (double)this.getReactor().gasCoolantTank.getCapacity();
        }
        return (double)this.getReactor().fluidCoolantTank.getFluidAmount() / (double)this.getReactor().fluidCoolantTank.getCapacity();
    }

    @LuaFunction(mainThread=true)
    public final Map<String, Object> getHeatedCoolant() {
        ChemicalStack stack = this.getReactor().heatedCoolantTank.getStack();
        HashMap<String, Object> wrapped = new HashMap<String, Object>(2);
        wrapped.put("name", stack.getType().getRegistryName() == null ? null : stack.getType().getRegistryName().toString());
        wrapped.put("amount", stack.getAmount());
        return wrapped;
    }

    @LuaFunction(mainThread=true)
    public final long getHeatedCoolantCapacity() {
        return this.getReactor().heatedCoolantTank.getCapacity();
    }

    @LuaFunction(mainThread=true)
    public final long getHeatedCoolantNeeded() {
        return this.getReactor().heatedCoolantTank.getNeeded();
    }

    @LuaFunction(mainThread=true)
    public final double getHeatedCoolantFilledPercentage() {
        return (double)this.getReactor().heatedCoolantTank.getStored() / (double)this.getHeatedCoolantCapacity();
    }

    @LuaFunction(mainThread=true)
    public final long getFuel() {
        return this.getReactor().fuelTank.getStored();
    }

    @LuaFunction(mainThread=true)
    public final long getFuelCapacity() {
        return this.getReactor().fuelTank.getCapacity();
    }

    @LuaFunction(mainThread=true)
    public final long getFuelNeeded() {
        return this.getReactor().fuelTank.getNeeded();
    }

    @LuaFunction(mainThread=true)
    public final double getFuelFilledPercentage() {
        return (double)this.getFuel() / (double)this.getFuelCapacity();
    }

    @LuaFunction(mainThread=true)
    public final long getWaste() {
        return this.getReactor().wasteTank.getStored();
    }

    @LuaFunction(mainThread=true)
    public final long getWasteCapacity() {
        return this.getReactor().wasteTank.getCapacity();
    }

    @LuaFunction(mainThread=true)
    public final long getWasteNeeded() {
        return this.getReactor().wasteTank.getNeeded();
    }

    @LuaFunction(mainThread=true)
    public final double getWasteFilledPercentage() {
        return (double)this.getWaste() / (double)this.getWasteCapacity();
    }

    @LuaFunction(mainThread=true)
    public final boolean getStatus() {
        return this.getReactor().isActive();
    }

    @LuaFunction(mainThread=true)
    public final void scram() {
        this.getReactor().setActive(false);
    }

    @LuaFunction(mainThread=true)
    public final void activate() {
        this.getReactor().setActive(true);
    }

    @LuaFunction(mainThread=true)
    public final double getBurnRate() {
        return this.getReactor().rateLimit;
    }

    @LuaFunction(mainThread=true)
    public final void setBurnRate(double rate) throws LuaException {
        rate = (double)Math.round(rate * 100.0) / 100.0;
        int max = this.getMaxBurnRate();
        if (rate < 0.0 || rate > (double)max) {
            throw new LuaException("Burn Rate '" + rate + "' is out of range must be between 0 and " + max + ". (Inclusive)");
        }
        this.getReactor().rateLimit = Math.max(Math.min((double)this.getMaxBurnRate(), rate), 0.0);
    }

    @LuaFunction(mainThread=true)
    public final double getActualBurnRate() {
        return this.getReactor().lastBurnRate;
    }

    @LuaFunction(mainThread=true)
    public final int getMaxBurnRate() {
        return this.getReactor().fuelAssemblies;
    }

    @LuaFunction(mainThread=true)
    public final double getDamagePercent() {
        return Math.round(this.getReactor().reactorDamage);
    }

    @LuaFunction(mainThread=true)
    public final double getHeatingRate() {
        return this.getReactor().lastBoilRate;
    }

    @LuaFunction(mainThread=true)
    public final double getEnvironmentalLoss() {
        return this.getReactor().lastEnvironmentLoss;
    }

    @LuaFunction(mainThread=true)
    public final double getTemperature() {
        return this.getReactor().getTotalTemperature();
    }

    @LuaFunction(mainThread=true)
    public final double getHeatCapacity() {
        return this.getReactor().heatCapacitor.getHeatCapacity();
    }

    @LuaFunction(mainThread=true)
    public final int getFuelAssemblies() {
        return this.getReactor().fuelAssemblies;
    }

    @LuaFunction(mainThread=true)
    public final int getFuelSurfaceArea() {
        return this.getReactor().surfaceArea;
    }

    @LuaFunction(mainThread=true)
    public final double getBoilEfficiency() {
        return this.getReactor().getBoilEfficiency();
    }

    private FissionReactorMultiblockData getReactor() {
        return (FissionReactorMultiblockData)((TileEntityFissionReactorLogicAdapter)this.tileEntity).getMultiblock();
    }
}

