/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.minecolonies;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IVisitorData;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.managers.interfaces.IBuildingManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.workorders.IWorkOrder;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.research.IGlobalResearch;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.api.research.ILocalResearch;
import com.minecolonies.api.research.ILocalResearchTree;
import com.minecolonies.api.research.effects.IResearchEffect;
import com.minecolonies.api.research.util.ResearchState;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingStructureBuilder;
import com.minecolonies.coremod.colony.buildings.utils.BuildingBuilderResource;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildDecoration;
import de.srendi.advancedperipherals.common.util.LuaConverter;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class MineColonies {
    public static boolean hasAccess(Entity entity, IColony colony) {
        if (entity instanceof PlayerEntity && colony != null) {
            return colony.getPermissions().hasPermission((PlayerEntity)entity, Action.ACCESS_HUTS);
        }
        return false;
    }

    public static Object citizenToObject(ICitizenData citizen) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", citizen.getId());
        map.put("name", citizen.getName());
        map.put("bedPos", LuaConverter.posToObject(citizen.getBedPos()));
        map.put("children", citizen.getChildren());
        map.put("location", LuaConverter.posToObject(citizen.getLastPosition()));
        map.put("state", citizen.getStatus() == null ? "Idle" : citizen.getStatus().getTranslatedText());
        map.put("age", citizen.isChild() ? "child" : "adult");
        map.put("gender", citizen.isFemale() ? "female" : "male");
        map.put("saturation", citizen.getSaturation());
        map.put("happiness", citizen.getCitizenHappinessHandler().getHappiness(citizen.getColony()));
        map.put("skills", MineColonies.skillsToObject(citizen.getCitizenSkillHandler().getSkills()));
        map.put("work", citizen.getWorkBuilding() == null ? null : MineColonies.jobToObject(citizen.getWorkBuilding()));
        map.put("home", citizen.getHomeBuilding() == null ? null : MineColonies.homeToObject(citizen.getHomeBuilding()));
        map.put("betterFood", citizen.needsBetterFood());
        map.put("isAsleep", map.get("state").toString().toLowerCase().contains("sleeping"));
        map.put("isIdle", map.get("state").toString().toLowerCase().contains("idle"));
        citizen.getEntity().ifPresent(entity -> {
            map.put("health", Float.valueOf(entity.func_110143_aJ()));
            map.put("maxHealth", Float.valueOf(entity.func_110138_aP()));
            map.put("armor", entity.func_233637_b_(Attributes.field_233826_i_));
            map.put("toughness", entity.func_233637_b_(Attributes.field_233827_j_));
        });
        return map;
    }

    public static Object visitorToObject(IVisitorData visitor) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", visitor.getId());
        map.put("name", visitor.getName());
        map.put("location", LuaConverter.posToObject(visitor.getSittingPosition()));
        map.put("age", visitor.isChild() ? "child" : "adult");
        map.put("gender", visitor.isFemale() ? "female" : "male");
        map.put("saturation", visitor.getSaturation());
        map.put("happiness", visitor.getCitizenHappinessHandler().getHappiness(visitor.getColony()));
        map.put("skills", MineColonies.skillsToObject(visitor.getCitizenSkillHandler().getSkills()));
        map.put("recruitCost", visitor.getRecruitCost().func_77973_b().getRegistryName().toString());
        return map;
    }

    public static Object jobToObject(IBuilding work) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("location", LuaConverter.posToObject(work.getLocation().getInDimensionLocation()));
        map.put("type", work.getSchematicName());
        map.put("level", work.getBuildingLevel());
        map.put("name", work.getCustomBuildingName());
        return map;
    }

    public static Object homeToObject(IBuilding home) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("location", LuaConverter.posToObject(home.getLocation().getInDimensionLocation()));
        map.put("type", home.getSchematicName());
        map.put("level", home.getBuildingLevel());
        return map;
    }

    public static Object skillsToObject(Map<Skill, Tuple<Integer, Double>> skills) {
        HashMap map = new HashMap();
        for (Skill skill : skills.keySet()) {
            HashMap<String, Object> skillData = new HashMap<String, Object>();
            skillData.put("level", skills.get(skill).func_76341_a());
            skillData.put("xp", skills.get(skill).func_76340_b());
            map.put(skill.name(), skillData);
        }
        return map;
    }

    public static Object buildingToObject(IBuildingManager buildingManager, IBuilding building, BlockPos pos) {
        HashMap<String, Object> structureData = new HashMap<String, Object>();
        structureData.put("cornerA", building.getCorners().func_76341_a());
        structureData.put("cornerB", building.getCorners().func_76340_b());
        structureData.put("rotation", building.getRotation());
        structureData.put("mirror", building.isMirrored());
        ArrayList citizensData = new ArrayList();
        for (ICitizenData citizen : building.getAllAssignedCitizen()) {
            HashMap<String, Object> citizenData = new HashMap<String, Object>();
            citizenData.put("id", citizen.getId());
            citizenData.put("name", citizen.getName());
            citizensData.add(citizenData);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("location", LuaConverter.posToObject(pos));
        map.put("type", building.getSchematicName());
        map.put("style", building.getStyle());
        map.put("level", building.getBuildingLevel());
        map.put("maxLevel", building.getMaxBuildingLevel());
        map.put("name", building.getCustomBuildingName());
        map.put("built", building.isBuilt());
        map.put("isWorkingOn", building.hasWorkOrder());
        map.put("priority", building.getPickUpPriority());
        map.put("structure", structureData);
        map.put("citizens", citizensData);
        map.put("storageBlocks", building.getContainers().size());
        map.put("storageSlots", MineColonies.getStorageSize(building));
        map.put("guarded", buildingManager.hasGuardBuildingNear(building));
        return map;
    }

    public static int getStorageSize(IBuilding building) {
        LazyOptional capability = building.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        IItemHandler handler = capability.resolve().orElse(null);
        if (handler != null) {
            return handler.getSlots();
        }
        return 0;
    }

    public static int getAmountOfConstructionSites(IColony colony) {
        int constructionSites = 0;
        for (IBuilding building : colony.getBuildingManager().getBuildings().values()) {
            if (!building.hasWorkOrder()) continue;
            ++constructionSites;
        }
        return constructionSites;
    }

    public static Object workOrderToObject(IWorkOrder workOrder) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("builder", LuaConverter.posToObject(workOrder.getClaimedBy()));
        map.put("changed", workOrder.hasChanged());
        map.put("id", workOrder.getID());
        map.put("priority", workOrder.getPriority());
        map.put("isClaimed", workOrder.isClaimed());
        map.put("location", workOrder instanceof WorkOrderBuildDecoration ? LuaConverter.posToObject(((WorkOrderBuildDecoration)workOrder).getSchematicLocation()) : null);
        map.put("type", workOrder.getClass().getSimpleName());
        return map;
    }

    public static List<Object> getResearch(ResourceLocation branch, List<ResourceLocation> researches, IColony colony) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (researches != null) {
            for (ResourceLocation researchName : researches) {
                IGlobalResearchTree globalTree = IGlobalResearchTree.getInstance();
                ILocalResearchTree colonyTree = colony.getResearchManager().getResearchTree();
                IGlobalResearch research = globalTree.getResearch(branch, researchName);
                if (research == null) continue;
                ILocalResearch colonyResearch = colonyTree.getResearch(branch, researchName);
                ArrayList<String> effects = new ArrayList<String>();
                for (IResearchEffect researchEffect : research.getEffects()) {
                    effects.add(researchEffect.getDesc().toString());
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", researchName.toString());
                map.put("name", research.getName().getString());
                map.put("researchEffects", effects);
                map.put("status", colonyResearch == null ? ResearchState.NOT_STARTED : colonyResearch.getState());
                List<Object> childrenResearch = MineColonies.getResearch(branch, research.getChildren(), colony);
                if (!childrenResearch.isEmpty()) {
                    map.put("children", childrenResearch);
                }
                result.add(map);
            }
        }
        return result;
    }

    public static Object builderResourcesToObject(IColony colony, BlockPos pos) {
        IBuilding building = colony.getBuildingManager().getBuilding(pos);
        if (!(building instanceof AbstractBuildingStructureBuilder)) {
            return null;
        }
        AbstractBuildingStructureBuilder builderBuilding = (AbstractBuildingStructureBuilder)building;
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        builderBuilding.serializeToView(buffer);
        buffer.release();
        ArrayList resources = new ArrayList(builderBuilding.getNeededResources().values());
        resources.sort(new BuildingBuilderResource.ResourceComparator(new BuildingBuilderResource.RessourceAvailability[0]));
        ArrayList result = new ArrayList();
        for (BuildingBuilderResource resource : resources) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("item", resource.getItemStack().func_77946_l().func_77973_b().getRegistryName().toString());
            map.put("displayName", resource.getName());
            map.put("available", resource.getAvailable());
            map.put("delivering", resource.getAmountInDelivery());
            map.put("status", resource.getAvailabilityStatus().toString());
            map.put("needed", resource.getAmount());
            result.add(map);
        }
        return result;
    }
}

