/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.refinedstorage;

import com.refinedmods.refinedstorage.api.IRSAPI;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPattern;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.storage.IStorage;
import com.refinedmods.refinedstorage.api.storage.cache.IStorageCache;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.api.storage.externalstorage.IExternalStorage;
import com.refinedmods.refinedstorage.api.util.StackListEntry;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import dan200.computercraft.shared.util.NBTUtil;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.addons.refinedstorage.RefinedStorageNode;
import de.srendi.advancedperipherals.common.util.LuaConverter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.codec.binary.Hex;

public class RefinedStorage {
    public static RefinedStorage instance;
    private final IRSAPI api = API.instance();

    public RefinedStorage() {
        this.initiate();
    }

    private static INetworkNode read(CompoundNBT tag, NetworkNode node) {
        node.read(tag);
        return node;
    }

    public static Object listFluids(INetwork network) {
        ArrayList fluids = new ArrayList();
        RefinedStorage.getFluids(network).forEach(item -> fluids.add(RefinedStorage.getObjectFromFluid(item)));
        return fluids;
    }

    public static Object listItems(INetwork network) {
        ArrayList items = new ArrayList();
        RefinedStorage.getItems(network).forEach(item -> items.add(RefinedStorage.getObjectFromStack(item)));
        return items;
    }

    public static boolean isItemCraftable(INetwork network, ItemStack stack) {
        for (ItemStack craftableStack : RefinedStorage.getCraftableItems(network)) {
            if (!craftableStack.func_77969_a(stack)) continue;
            return true;
        }
        return false;
    }

    public static int getMaxItemDiskStorage(INetwork network) {
        int total = 0;
        boolean creative = false;
        for (IStorage store : network.getItemStorageCache().getStorages()) {
            if (!(store instanceof IStorageDisk)) continue;
            int cap = ((IStorageDisk)store).getCapacity();
            if (cap > 0) {
                total += cap;
                continue;
            }
            creative = true;
        }
        return creative ? -1 : total;
    }

    public static int getMaxFluidDiskStorage(INetwork network) {
        int total = 0;
        boolean creative = false;
        for (IStorage store : network.getFluidStorageCache().getStorages()) {
            if (!(store instanceof IStorageDisk)) continue;
            int cap = ((IStorageDisk)store).getCapacity();
            if (cap > 0) {
                total += cap;
                continue;
            }
            creative = true;
        }
        return creative ? -1 : total;
    }

    public static int getMaxItemExternalStorage(INetwork network) {
        int total = 0;
        for (IStorage store : network.getItemStorageCache().getStorages()) {
            if (!(store instanceof IExternalStorage)) continue;
            total = (int)((long)total + ((IExternalStorage)store).getCapacity());
        }
        return total;
    }

    public static int getMaxFluidExternalStorage(INetwork network) {
        int total = 0;
        for (IStorage store : network.getFluidStorageCache().getStorages()) {
            if (!(store instanceof IExternalStorage)) continue;
            total = (int)((long)total + ((IExternalStorage)store).getCapacity());
        }
        return total;
    }

    public static Object getObjectFromPattern(ICraftingPattern pattern) {
        if (pattern == null) {
            return null;
        }
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        NonNullList outputsList = pattern.getOutputs();
        ArrayList<Map<String, Object>> outputs = new ArrayList<Map<String, Object>>();
        for (ItemStack itemStack : outputsList) {
            outputs.add(RefinedStorage.getObjectFromStack(itemStack.func_77946_l()));
        }
        map.put("outputs", outputs);
        List inputList = pattern.getInputs();
        ArrayList inputs = new ArrayList();
        for (List singleInputList : inputList) {
            ArrayList<Map<String, Object>> inputs1 = new ArrayList<Map<String, Object>>();
            for (ItemStack stack : singleInputList) {
                inputs1.add(RefinedStorage.getObjectFromStack(stack.func_77946_l()));
            }
            inputs.add(inputs1);
        }
        NonNullList byproductsList = pattern.getByproducts();
        ArrayList<Map<String, Object>> byproducts = new ArrayList<Map<String, Object>>();
        for (ItemStack stack : byproductsList) {
            byproducts.add(RefinedStorage.getObjectFromStack(stack.func_77946_l()));
        }
        map.put("inputs", inputs);
        map.put("outputs", outputs);
        map.put("byproducts", byproducts);
        map.put("processing", Boolean.valueOf(pattern.isProcessing()));
        return map;
    }

    public static Map<String, Object> getObjectFromStack(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        CompoundNBT nbt = itemStack.func_196082_o();
        Set tags = itemStack.func_77973_b().getTags();
        map.put("fingerprint", RefinedStorage.getFingerpint(itemStack));
        map.put("name", itemStack.func_77973_b().getRegistryName().toString());
        map.put("amount", itemStack.func_190916_E());
        map.put("displayName", itemStack.func_151000_E().getString());
        map.put("nbt", nbt.isEmpty() ? null : NBTUtil.toLua((INBT)nbt));
        map.put("tags", tags.isEmpty() ? null : LuaConverter.tagsToList(itemStack.func_77973_b().getTags()));
        return map;
    }

    public static Map<String, Object> getObjectFromFluid(@Nullable FluidStack fluidStack) {
        if (fluidStack == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        Set tags = fluidStack.getFluid().getTags();
        map.put("name", fluidStack.getFluid().getRegistryName().toString());
        map.put("amount", fluidStack.getAmount());
        map.put("displayName", fluidStack.getDisplayName().getString());
        map.put("tags", tags.isEmpty() ? null : LuaConverter.tagsToList(fluidStack.getFluid().getTags()));
        return map;
    }

    public static Object getItem(INetwork network, ItemStack item) {
        for (ItemStack itemStack : RefinedStorage.getItems(network)) {
            if (!itemStack.func_77969_a(item) || !Objects.equals(itemStack.func_196082_o(), item.func_196082_o())) continue;
            return RefinedStorage.getObjectFromStack(itemStack);
        }
        return null;
    }

    public static List<ItemStack> getCraftableItems(INetwork network) {
        IStorageCache cache = network.getItemStorageCache();
        Collection craftableEntries = cache.getCraftablesList().getStacks();
        ArrayList<ItemStack> result = new ArrayList<ItemStack>(craftableEntries.size());
        for (StackListEntry entry : craftableEntries) {
            result.add((ItemStack)entry.getStack());
        }
        return result;
    }

    public static List<ItemStack> getItems(INetwork network) {
        IStorageCache cache = network.getItemStorageCache();
        Collection entries = cache.getList().getStacks();
        Collection craftableEntries = cache.getCraftablesList().getStacks();
        ArrayList<ItemStack> result = new ArrayList<ItemStack>(entries.size());
        for (StackListEntry entry : entries) {
            result.add(((ItemStack)entry.getStack()).func_77946_l());
        }
        for (StackListEntry entry : craftableEntries) {
            result.add(((ItemStack)entry.getStack()).func_77946_l());
        }
        return result;
    }

    public static List<FluidStack> getFluids(INetwork network) {
        IStorageCache cache = network.getFluidStorageCache();
        Collection entries = cache.getList().getStacks();
        ArrayList<FluidStack> result = new ArrayList<FluidStack>(entries.size());
        for (StackListEntry entry : entries) {
            result.add(((FluidStack)entry.getStack()).copy());
        }
        return result;
    }

    public static CompoundNBT findMatchingTag(ItemStack stack, String nbtHash, List<ItemStack> items) {
        for (ItemStack rsStack : items) {
            CompoundNBT tag;
            String hash;
            if (rsStack.func_190916_E() <= 0 || !rsStack.func_77973_b().equals(stack.func_77973_b()) || !nbtHash.equals(hash = NBTUtil.getNBTHash((CompoundNBT)(tag = rsStack.func_77978_p())))) continue;
            return tag.func_74737_b();
        }
        return null;
    }

    public static ItemStack findMatchingFingerprint(String fingerprint, List<ItemStack> items) {
        for (ItemStack rsStack : items) {
            if (rsStack.func_190916_E() <= 0 || !fingerprint.equals(RefinedStorage.getFingerpint(rsStack))) continue;
            return rsStack;
        }
        return ItemStack.field_190927_a;
    }

    public static String getFingerpint(ItemStack stack) {
        String fingerprint = stack.func_196082_o() + stack.func_77973_b().getRegistryName().toString() + stack.func_151000_E().getString();
        try {
            byte[] bytesOfHash = fingerprint.getBytes(StandardCharsets.UTF_8);
            MessageDigest md = MessageDigest.getInstance("MD5");
            return new String(Hex.encodeHex((byte[])md.digest(bytesOfHash)));
        }
        catch (NoSuchAlgorithmException ex) {
            AdvancedPeripherals.debug("Could not parse fingerprint.");
            ex.printStackTrace();
            return "";
        }
    }

    public void initiate() {
        this.api.getNetworkNodeRegistry().add(new ResourceLocation("advancedperipherals", "rs_bridge"), (tag, world, pos) -> RefinedStorage.read(tag, new RefinedStorageNode(world, pos)));
    }

    public IRSAPI getApi() {
        return this.api;
    }
}

