/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.argoggles;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.srendi.advancedperipherals.common.util.ItemUtil;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.registries.ForgeRegistries;

public class ARRenderHelper
extends AbstractGui {
    private static ARRenderHelper instance = new ARRenderHelper();

    public static void drawRightboundString(MatrixStack matrixStack, FontRenderer fontRenderer, String text, int x, int y, int color) {
        ARRenderHelper.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)fontRenderer, (String)text, (int)(x - fontRenderer.func_78256_a(text)), (int)y, (int)color);
    }

    public static ARRenderHelper getInstance() {
        return instance;
    }

    public static int fixAlpha(int color) {
        return (color & 0xFF000000) == 0 ? color | 0xFF000000 : color;
    }

    public void func_238465_a_(MatrixStack matrixStack, int minX, int maxX, int y, int color) {
        color = ARRenderHelper.fixAlpha(color);
        super.func_238465_a_(matrixStack, minX, maxX, y, color);
    }

    public void func_238473_b_(MatrixStack matrixStack, int x, int minY, int maxY, int color) {
        color = ARRenderHelper.fixAlpha(color);
        super.func_238473_b_(matrixStack, x, minY, maxY, color);
    }

    protected void func_238468_a_(MatrixStack matrixStack, int x1, int y1, int x2, int y2, int colorFrom, int colorTo) {
        colorFrom = ARRenderHelper.fixAlpha(colorFrom);
        colorTo = ARRenderHelper.fixAlpha(colorTo);
        super.func_238468_a_(matrixStack, x1, y1, x2, y2, colorFrom, colorTo);
    }

    public void drawCircle(MatrixStack matrixStack, int centerX, int centerY, float radius, int color) {
        color = ARRenderHelper.fixAlpha(color);
        int n_segments = 360;
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        float z = this.func_230927_p_();
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        bufferbuilder.func_181668_a(2, DefaultVertexFormats.field_181706_f);
        for (int i = 0; i < 360; ++i) {
            double angle = Math.PI * 2 * (double)i / 360.0;
            float xd = (float)((double)radius * Math.sin(angle));
            float yd = (float)((double)radius * Math.cos(angle));
            bufferbuilder.func_227888_a_(matrix, (float)centerX + xd, (float)centerY + yd, z).func_227885_a_(r, g, b, a).func_181675_d();
        }
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    public void fillCircle(MatrixStack matrixStack, int centerX, int centerY, float radius, int color) {
        color = ARRenderHelper.fixAlpha(color);
        float increment = 0.5f;
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        float z = this.func_230927_p_();
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        bufferbuilder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        for (float y = (float)centerY - radius; y < (float)centerY + radius; y += 0.5f) {
            float yd = (float)centerY - y;
            float xd = (float)Math.sqrt(Math.pow(radius, 2.0) - Math.pow(yd, 2.0));
            bufferbuilder.func_227888_a_(matrix, (float)centerX - xd, y, z).func_227885_a_(r, g, b, a).func_181675_d();
            bufferbuilder.func_227888_a_(matrix, (float)centerX + xd, y, z).func_227885_a_(r, g, b, a).func_181675_d();
        }
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    public void drawItemIcon(MatrixStack matrixStack, ItemRenderer itemRenderer, String item, int x, int y) {
        ItemStack stack = new ItemStack((IItemProvider)ItemUtil.getRegistryEntry(item, ForgeRegistries.ITEMS));
        itemRenderer.func_175042_a(stack, x, y);
    }
}

