/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.blocks.tileentity;

import de.srendi.advancedperipherals.common.addons.computercraft.peripheral.ARControllerPeripheral;
import de.srendi.advancedperipherals.common.argoggles.ARRenderAction;
import de.srendi.advancedperipherals.common.blocks.base.PeripheralTileEntity;
import de.srendi.advancedperipherals.common.setup.TileEntityTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntityType;
import org.jetbrains.annotations.NotNull;

public class ARControllerTile
extends PeripheralTileEntity<ARControllerPeripheral> {
    private static final String CANVAS = "canvas";
    private static final String VIRTUAL_SCREEN_SIZE = "virtual_screen_size";
    private Optional<int[]> virtualScreenSize = Optional.empty();
    private List<ARRenderAction> canvas = new ArrayList<ARRenderAction>();

    public ARControllerTile() {
        super((TileEntityType)TileEntityTypes.AR_CONTROLLER.get());
    }

    public void addToCanvas(ARRenderAction action) {
        if (this.canvas.contains(action)) {
            return;
        }
        this.canvas.add(action);
        this.blockChanged();
    }

    public void clearCanvas() {
        this.canvas.clear();
        this.blockChanged();
    }

    @Override
    @NotNull
    protected ARControllerPeripheral createPeripheral() {
        return new ARControllerPeripheral(this);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.deserializeNBT(nbt);
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.virtualScreenSize = nbt.func_74759_k(VIRTUAL_SCREEN_SIZE).length > 0 ? Optional.of(nbt.func_74759_k(VIRTUAL_SCREEN_SIZE)) : Optional.empty();
        ListNBT list = nbt.func_150295_c(CANVAS, 10);
        this.canvas.clear();
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT c = list.func_150305_b(i);
            ARRenderAction action = new ARRenderAction();
            action.deserializeNBT(c);
            this.canvas.add(action);
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        if (this.virtualScreenSize.isPresent()) {
            compound.func_74783_a(VIRTUAL_SCREEN_SIZE, this.virtualScreenSize.get());
        } else if (compound.func_74764_b(VIRTUAL_SCREEN_SIZE)) {
            compound.func_82580_o(VIRTUAL_SCREEN_SIZE);
        }
        ListNBT list = new ListNBT();
        for (ARRenderAction action : new ArrayList<ARRenderAction>(this.canvas)) {
            list.add((Object)action.serializeNBT());
        }
        compound.func_218657_a(CANVAS, (INBT)list);
        return super.func_189515_b(compound);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        this.func_189515_b(nbt);
        return nbt;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.deserializeNBT(state, tag);
        super.handleUpdateTag(state, tag);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, nbt);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT nbt = pkt.func_148857_g();
        this.deserializeNBT(nbt);
    }

    public boolean isRelativeMode() {
        return this.virtualScreenSize.isPresent();
    }

    public int[] getVirtualScreenSize() {
        if (this.virtualScreenSize.isPresent()) {
            return this.virtualScreenSize.get();
        }
        return null;
    }

    public void setRelativeMode(int virtualScreenWidth, int virtualScreenHeight) {
        this.virtualScreenSize = Optional.of(new int[]{virtualScreenWidth, virtualScreenHeight});
        this.blockChanged();
    }

    public void disableRelativeMode() {
        this.virtualScreenSize = Optional.empty();
        this.blockChanged();
    }

    private void blockChanged() {
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
    }

    public List<ARRenderAction> getCanvas() {
        ArrayList<ARRenderAction> list = new ArrayList<ARRenderAction>();
        for (ARRenderAction a : this.canvas) {
            ARRenderAction action = a.copyWithVirtualScreenSize(this.virtualScreenSize);
            list.add(action);
        }
        return list;
    }

    @Override
    public void markSettingsChanged() {
    }
}

