/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.events;

import com.google.common.collect.EvictingQueue;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.items.ARGogglesItem;
import de.srendi.advancedperipherals.common.util.Pair;
import de.srendi.advancedperipherals.network.MNetwork;
import de.srendi.advancedperipherals.network.messages.ClearHudCanvasMessage;
import java.util.function.Consumer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="advancedperipherals", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class Events {
    private static final String PLAYED_BEFORE = "ap_played_before";
    private static final int CHAT_QUEUE_MAX_SIZE = 50;
    public static final EvictingQueue<Pair<Long, ChatMessageObject>> messageQueue = EvictingQueue.create((int)50);
    public static long counter = 0L;

    @SubscribeEvent
    public static void onWorldJoin(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player;
        if (((Boolean)APConfig.WORLD_CONFIG.GIVE_PLAYER_BOOK_ON_JOIN.get()).booleanValue() && !Events.hasPlayedBefore(player = event.getPlayer())) {
            ItemStack book = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation("patchouli", "guide_book")));
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74778_a("patchouli:book", "advancedperipherals:manual");
            book.func_77982_d(nbt);
            player.func_191521_c(book);
        }
    }

    @SubscribeEvent
    public static void onChatBox(ServerChatEvent event) {
        if (((Boolean)APConfig.PERIPHERALS_CONFIG.ENABLE_CHAT_BOX.get()).booleanValue()) {
            String message = event.getMessage();
            boolean isHidden = false;
            if (message.startsWith("$")) {
                event.setCanceled(true);
                message = message.replace("$", "");
                isHidden = true;
            }
            Events.putChatMessage(Pair.of(counter, new ChatMessageObject(event.getUsername(), message, event.getPlayer().func_110124_au().toString(), isHidden)));
        }
    }

    @SubscribeEvent
    public static void onEquipmentChange(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (!(livingEntity instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)livingEntity;
        if (event.getFrom().func_77973_b() instanceof ARGogglesItem) {
            MNetwork.sendTo(new ClearHudCanvasMessage(), player);
        }
    }

    public static synchronized void putChatMessage(Pair<Long, ChatMessageObject> message) {
        messageQueue.add(message);
        ++counter;
    }

    public static synchronized long traverseChatMessages(long lastConsumedMessage, Consumer<ChatMessageObject> consumer) {
        for (Pair message : messageQueue) {
            if ((Long)message.getLeft() <= lastConsumedMessage) continue;
            consumer.accept((ChatMessageObject)message.getRight());
            lastConsumedMessage = (Long)message.getLeft();
        }
        return lastConsumedMessage;
    }

    private static boolean hasPlayedBefore(PlayerEntity player) {
        CompoundNBT tag = player.getPersistentData().func_74775_l("PlayerPersisted");
        if (tag.func_74767_n(PLAYED_BEFORE)) {
            return true;
        }
        tag.func_74757_a(PLAYED_BEFORE, true);
        player.getPersistentData().func_218657_a("PlayerPersisted", (INBT)tag);
        return false;
    }

    public static class ChatMessageObject {
        public String username;
        public String message;
        public String uuid;
        public boolean isHidden;

        public ChatMessageObject(String username, String message, String uuid, boolean isHidden) {
            this.username = username;
            this.message = message;
            this.uuid = uuid;
            this.isHidden = isHidden;
        }
    }
}

