/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util;

import de.srendi.advancedperipherals.common.blocks.tileentity.EnergyDetectorTile;
import java.util.Optional;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyStorageProxy
implements IEnergyStorage {
    private final EnergyDetectorTile energyDetectorTE;
    private int maxTransferRate;
    private int transferedInThisTick = 0;

    public EnergyStorageProxy(EnergyDetectorTile energyDetectorTE, int maxTransferRate) {
        this.energyDetectorTE = energyDetectorTE;
        this.maxTransferRate = maxTransferRate;
    }

    public boolean canReceive() {
        return true;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        Optional<IEnergyStorage> out = this.energyDetectorTE.getOutputStorage();
        return out.map(outStorage -> {
            int transferred = outStorage.receiveEnergy(Math.min(maxReceive, this.maxTransferRate), simulate);
            if (!simulate) {
                this.transferedInThisTick += transferred;
            }
            return transferred;
        }).orElse(0);
    }

    public int getEnergyStored() {
        Optional<IEnergyStorage> out = this.energyDetectorTE.getOutputStorage();
        return out.map(IEnergyStorage::getEnergyStored).orElse(0);
    }

    public int getMaxEnergyStored() {
        Optional<IEnergyStorage> out = this.energyDetectorTE.getOutputStorage();
        return out.map(IEnergyStorage::getMaxEnergyStored).orElse(0);
    }

    public boolean canExtract() {
        return false;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getMaxTransferRate() {
        return this.maxTransferRate;
    }

    public void setMaxTransferRate(int rate) {
        this.maxTransferRate = rate;
    }

    public void resetTransferedInThisTick() {
        this.transferedInThisTick = 0;
    }

    public int getTransferedInThisTick() {
        return this.transferedInThisTick;
    }
}

