/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util.fakeplayer;

import com.mojang.authlib.GameProfile;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.shared.util.WorldUtil;
import de.srendi.advancedperipherals.common.util.fakeplayer.APFakePlayer;
import java.util.WeakHashMap;
import java.util.function.Function;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public final class FakePlayerProviderTurtle {
    private static final WeakHashMap<ITurtleAccess, APFakePlayer> registeredPlayers = new WeakHashMap();

    private FakePlayerProviderTurtle() {
    }

    public static APFakePlayer getPlayer(ITurtleAccess turtle, GameProfile profile) {
        APFakePlayer fake = registeredPlayers.get(turtle);
        if (fake == null) {
            fake = new APFakePlayer((ServerWorld)turtle.getWorld(), null, profile);
            registeredPlayers.put(turtle, fake);
        }
        return fake;
    }

    public static void load(APFakePlayer player, ITurtleAccess turtle) {
        int i;
        float pitch;
        Direction direction = turtle.getDirection();
        player.func_70029_a(turtle.getWorld());
        BlockPos position = turtle.getPosition();
        float f = direction == Direction.UP ? -90.0f : (pitch = direction == Direction.DOWN ? 90.0f : 0.0f);
        float yaw = direction == Direction.SOUTH ? 0.0f : (direction == Direction.WEST ? 90.0f : (direction == Direction.NORTH ? 180.0f : -90.0f));
        Vector3i sideVec = direction.func_176730_m();
        Direction.Axis a = direction.func_176740_k();
        Direction.AxisDirection ad = direction.func_176743_c();
        double x = a == Direction.Axis.X && ad == Direction.AxisDirection.NEGATIVE ? -0.5 : 0.5 + (double)sideVec.func_177958_n() / 1.9;
        double y = 0.5 + (double)sideVec.func_177956_o() / 1.9;
        double z = a == Direction.Axis.Z && ad == Direction.AxisDirection.NEGATIVE ? -0.5 : 0.5 + (double)sideVec.func_177952_p() / 1.9;
        player.func_70012_b((double)position.func_177958_n() + x, (double)position.func_177956_o() + y, (double)position.func_177952_p() + z, yaw, pitch);
        player.field_71071_by.field_70461_c = 0;
        IItemHandlerModifiable turtleInventory = turtle.getItemHandler();
        int size = turtleInventory.getSlots();
        int largerSize = player.field_71071_by.func_70302_i_();
        player.field_71071_by.field_70461_c = turtle.getSelectedSlot();
        for (i = 0; i < size; ++i) {
            player.field_71071_by.func_70299_a(i, turtleInventory.getStackInSlot(i));
        }
        for (i = size; i < largerSize; ++i) {
            player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
        }
        ItemStack activeStack = player.func_184586_b(Hand.MAIN_HAND);
        if (!activeStack.func_190926_b()) {
            player.func_233645_dx_().func_233793_b_(activeStack.func_111283_C(EquipmentSlotType.MAINHAND));
        }
    }

    public static void unload(APFakePlayer player, ITurtleAccess turtle) {
        int i;
        player.field_71071_by.field_70461_c = 0;
        ItemStack activeStack = player.func_184586_b(Hand.MAIN_HAND);
        if (!activeStack.func_190926_b()) {
            player.func_233645_dx_().func_233785_a_(activeStack.func_111283_C(EquipmentSlotType.MAINHAND));
        }
        IItemHandlerModifiable turtleInventory = turtle.getItemHandler();
        int size = turtleInventory.getSlots();
        int largerSize = player.field_71071_by.func_70302_i_();
        player.field_71071_by.field_70461_c = turtle.getSelectedSlot();
        for (i = 0; i < size; ++i) {
            turtleInventory.setStackInSlot(i, player.field_71071_by.func_70301_a(i));
            player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
        }
        for (i = size; i < largerSize; ++i) {
            ItemStack remaining = player.field_71071_by.func_70301_a(i);
            if (!remaining.func_190926_b() && !(remaining = ItemHandlerHelper.insertItem((IItemHandler)turtleInventory, (ItemStack)remaining, (boolean)false)).func_190926_b()) {
                BlockPos position = turtle.getPosition();
                WorldUtil.dropItemStack((ItemStack)remaining, (World)turtle.getWorld(), (BlockPos)position, (Direction)turtle.getDirection().func_176734_d());
            }
            player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
        }
    }

    public static <T> T withPlayer(ITurtleAccess turtle, Function<APFakePlayer, T> function) {
        APFakePlayer player = FakePlayerProviderTurtle.getPlayer(turtle, turtle.getOwningPlayer());
        FakePlayerProviderTurtle.load(player, turtle);
        T result = function.apply(player);
        FakePlayerProviderTurtle.unload(player, turtle);
        return result;
    }
}

