/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.config.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.common.config.holder.ConfigKey;
import team.creative.creativecore.common.config.holder.ICreativeConfigHolder;
import team.creative.creativecore.common.config.sync.ConfigurationClientPacket;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.controls.GuiButton;
import team.creative.creativecore.common.gui.controls.GuiCheckBox;
import team.creative.creativecore.common.gui.controls.GuiLabel;
import team.creative.creativecore.common.gui.controls.GuiScrollBox;
import team.creative.creativecore.common.gui.controls.layout.GuiLeftRightBox;
import team.creative.creativecore.common.gui.dialog.DialogGuiLayer;
import team.creative.creativecore.common.gui.dialog.GuiDialogHandler;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.handler.GuiContainerHandler;
import team.creative.creativecore.common.util.text.TextBuilder;
import team.creative.creativecore.common.util.type.CheckTree;

public class ClientSyncGuiLayer
extends GuiLayer {
    public final CheckTree<ConfigKey> tree;
    public final ICreativeConfigHolder root;
    public CheckTree.CheckTreeEntry currentView;
    public boolean changed = false;
    public int nextAction;
    public boolean force;

    public ClientSyncGuiLayer(ICreativeConfigHolder holder) {
        super("client-sync", 300, 200);
        this.root = holder;
        this.registerEvent(GuiControlChangedEvent.class, x -> {
            this.changed = true;
            if (x.control instanceof GuiTreeCheckBox && !((GuiTreeCheckBox)x.control).value) {
                ((GuiTreeCheckBox)x.control).partial = ((GuiTreeCheckBox)x.control).entry.isChildEnabled();
            }
        });
        BiConsumer<ConfigKey, Boolean> setter = (x, y) -> {
            x.forceSynchronization = y;
        };
        Function<ConfigKey, Boolean> getter = x -> x.forceSynchronization;
        Function<ConfigKey, Collection> getChildren = x -> {
            if (x.getDefault() instanceof ICreativeConfigHolder) {
                ArrayList<ConfigKey> keys = new ArrayList<ConfigKey>();
                for (ConfigKey configKey : ((ICreativeConfigHolder)x.getDefault()).fields()) {
                    Object object;
                    if (!configKey.isWithoutForce(Dist.CLIENT) || (object = configKey.get()) instanceof ICreativeConfigHolder && ((ICreativeConfigHolder)object).isEmptyWithoutForce(Dist.CLIENT)) continue;
                    keys.add(configKey);
                }
                return keys;
            }
            return null;
        };
        ArrayList<ConfigKey> keys = new ArrayList<ConfigKey>();
        for (ConfigKey configKey : holder.fields()) {
            Object object;
            if (!configKey.isWithoutForce(Dist.CLIENT) || (object = configKey.get()) instanceof ICreativeConfigHolder && ((ICreativeConfigHolder)object).isEmptyWithoutForce(Dist.CLIENT)) continue;
            keys.add(configKey);
        }
        this.tree = new CheckTree<ConfigKey>(keys, setter, getter, getChildren);
        this.currentView = this.tree.root;
    }

    @Override
    public void create() {
        this.load(this.currentView);
    }

    public void save() {
        CreativeCore.NETWORK.sendToServer(new ConfigurationClientPacket(this.root, this.tree));
    }

    public void load(CheckTree.CheckTreeEntry entry) {
        if (!this.isEmpty()) {
            this.clear();
        }
        ICreativeConfigHolder holder = entry.content == null ? this.root : (ICreativeConfigHolder)((ConfigKey)entry.content).get();
        GuiLeftRightBox upperBox = new GuiLeftRightBox("upperBox", 0, 0);
        upperBox.add(new GuiLabel("path", 0, 0).setTitle((ITextComponent)new StringTextComponent("/" + String.join((CharSequence)"/", holder.path()))));
        if (entry.parent != null) {
            upperBox.addRight(new GuiButton("back", 170, 0, x -> this.load(entry.parent)).setTitle((ITextComponent)new TranslationTextComponent("gui.back")));
        }
        this.add(upperBox);
        this.currentView = entry;
        GuiScrollBox box = new GuiScrollBox("box", 0, 17, 286, 152);
        this.add(box);
        int offsetX = 20;
        int offsetY = 1;
        for (CheckTree.CheckTreeEntry key : this.currentView.children) {
            box.add(new GuiTreeCheckBox(key, 5, offsetY + 3));
            String caption = ClientSyncGuiLayer.translateOrDefault("config." + String.join((CharSequence)".", holder.path() + "." + ((ConfigKey)key.content).name + ".name"), ((ConfigKey)key.content).name);
            String comment = "config." + String.join((CharSequence)".", holder.path()) + "." + ((ConfigKey)key.content).name + ".comment";
            if (key.content != null && ((ConfigKey)key.content).get() instanceof ICreativeConfigHolder) {
                box.add(new GuiButton(caption, offsetX, offsetY, x -> this.load(key)).setTitle((ITextComponent)new StringTextComponent(caption)).setTooltip(new TextBuilder().translateIfCan(comment).build()));
                offsetY += 21;
                continue;
            }
            GuiLabel label = new GuiLabel(caption, offsetX, offsetY + 2).setTitle((ITextComponent)new StringTextComponent(caption));
            box.add(label.setTooltip(new TextBuilder().translateIfCan(comment).build()));
            offsetY += 16;
        }
        GuiLeftRightBox lowerBox = new GuiLeftRightBox("lowerBox", 0, 171);
        lowerBox.add(new GuiButton("cancel", 0, 180, x -> {
            this.nextAction = 0;
            this.closeTopLayer();
        }).setTitle((ITextComponent)new TranslationTextComponent("gui.cancel")));
        lowerBox.add(new GuiButton("config", 40, 180, x -> {
            this.nextAction = 1;
            this.closeTopLayer();
        }).setTitle((ITextComponent)new TranslationTextComponent("gui.config")));
        lowerBox.addRight(new GuiButton("save", 170, 180, x -> {
            this.nextAction = 0;
            this.force = true;
            this.save();
            this.closeTopLayer();
        }).setTitle((ITextComponent)new TranslationTextComponent("gui.save")));
        this.add(lowerBox);
        this.reinit();
    }

    @Override
    public void closeTopLayer() {
        if (this.force || !this.changed) {
            if (this.nextAction == 0) {
                super.closeTopLayer();
            } else if (this.nextAction == 1) {
                GuiContainerHandler.openGui(this.getPlayer(), "config");
            }
        } else {
            GuiDialogHandler.openDialog(this.getParent(), "savechanges", (x, y) -> {
                if (y == DialogGuiLayer.DialogButton.YES) {
                    this.save();
                }
                if (y != DialogGuiLayer.DialogButton.CANCEL) {
                    this.force = true;
                    this.closeTopLayer();
                }
            }, DialogGuiLayer.DialogButton.YES, DialogGuiLayer.DialogButton.NO, DialogGuiLayer.DialogButton.CANCEL);
        }
    }

    public static class GuiTreeCheckBox
    extends GuiCheckBox {
        public final CheckTree.CheckTreeEntry entry;

        public GuiTreeCheckBox(CheckTree.CheckTreeEntry entry, int x, int y) {
            super(((ConfigKey)entry.content).name, "", x, y, entry.isEnabled());
            this.entry = entry;
            if (!this.value) {
                this.partial = entry.isChildEnabled();
            }
        }

        @Override
        public boolean mouseClicked(double x, double y, int button) {
            GuiTreeCheckBox.playSound(SoundEvents.field_187909_gi);
            boolean bl = this.value = !this.value;
            if (this.value) {
                this.entry.enable();
            } else {
                this.entry.disable();
            }
            this.raiseEvent(new GuiControlChangedEvent(this));
            return true;
        }
    }
}

