/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.gui.event.GuiEvent;
import team.creative.creativecore.common.gui.event.GuiTooltipEvent;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.gui.style.GuiStyle;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.common.util.text.TextBuilder;

public abstract class GuiControl {
    private IGuiParent parent;
    public final String name;
    public boolean enabled = true;
    private int x;
    private int y;
    private int width;
    private int height;
    public boolean visible = true;
    private List<ITextComponent> customTooltip;

    public GuiControl(String name, int x, int y, int width, int height) {
        this.name = name;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public boolean isClient() {
        return this.parent.isClient();
    }

    public GuiControl setTooltip(List<ITextComponent> tooltip) {
        if (!tooltip.isEmpty()) {
            this.customTooltip = tooltip;
        }
        return this;
    }

    public GuiControl setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public void setParent(IGuiParent parent) {
        this.parent = parent;
    }

    public IGuiParent getParent() {
        return this.parent;
    }

    public int getContentWidth() {
        return this.width - this.getContentOffset() * 2;
    }

    public int getContentHeight() {
        return this.height - this.getContentOffset() * 2;
    }

    public int getControlOffsetX() {
        int offset = this.x;
        if (this.parent instanceof GuiControl) {
            offset += ((GuiControl)((Object)this.parent)).getControlOffsetX();
        }
        return offset;
    }

    public int getControlOffsetY() {
        int offset = this.y;
        if (this.parent instanceof GuiControl) {
            offset += ((GuiControl)((Object)this.parent)).getControlOffsetY();
        }
        return offset;
    }

    public String getNestedName() {
        if (this.getParent() instanceof GuiControl) {
            return ((GuiControl)((Object)this.getParent())).getNestedName() + "." + this.name;
        }
        return this.name;
    }

    public boolean hasLayer() {
        if (this.parent instanceof GuiControl) {
            return ((GuiControl)((Object)this.parent)).hasLayer();
        }
        return false;
    }

    public GuiLayer getLayer() {
        if (this.parent instanceof GuiControl) {
            return ((GuiControl)((Object)this.parent)).getLayer();
        }
        throw new RuntimeException("Invalid layer control");
    }

    public GuiStyle getStyle() {
        if (this.parent instanceof GuiControl) {
            return ((GuiControl)((Object)this.parent)).getStyle();
        }
        throw new RuntimeException("Invalid layer control");
    }

    public abstract void init();

    public abstract void closed();

    public abstract void tick();

    public boolean is(String ... name) {
        for (int i = 0; i < name.length; ++i) {
            if (!this.name.equalsIgnoreCase(name[i])) continue;
            return true;
        }
        return false;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void initiateLayoutUpdate() {
        if (this.getParent() != null) {
            this.getParent().initiateLayoutUpdate();
        }
    }

    public void updateLayout() {
    }

    public abstract void setWidthLayout(int var1);

    public abstract int getMinWidth();

    public abstract int getPreferredWidth();

    public int getMaxWidth() {
        return 0;
    }

    public abstract void setHeightLayout(int var1);

    public abstract int getMinHeight();

    public abstract int getPreferredHeight();

    public int getMaxHeight() {
        return 0;
    }

    public boolean testForDoubleClick(double x, double y) {
        return false;
    }

    public boolean isInteractable() {
        return this.enabled && this.visible;
    }

    public boolean isMouseOver(double x, double y) {
        return x >= (double)this.x && x < (double)(this.x + this.width) && y >= (double)this.y && y < (double)(this.y + this.height);
    }

    public void mouseMoved(double x, double y) {
    }

    public boolean mouseClicked(double x, double y, int button) {
        return false;
    }

    public boolean mouseDoubleClicked(double x, double y, int button) {
        return this.mouseClicked(x, y, button);
    }

    public void mouseReleased(double x, double y, int button) {
    }

    public void mouseDragged(double x, double y, int button, double dragX, double dragY, double time) {
    }

    public boolean mouseScrolled(double x, double y, double delta) {
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    public boolean charTyped(char codePoint, int modifiers) {
        return false;
    }

    public void looseFocus() {
    }

    public void raiseEvent(GuiEvent event) {
        if (this.parent != null) {
            this.parent.raiseEvent(event);
        }
    }

    public abstract ControlFormatting getControlFormatting();

    public int getContentOffset() {
        return this.getStyle().getContentOffset(this.getControlFormatting());
    }

    public GuiTooltipEvent getTooltipEvent(double x, double y) {
        String langTooltip;
        List<ITextComponent> toolTip = this.getTooltip();
        if (this.customTooltip != null) {
            if (toolTip == null) {
                toolTip = this.customTooltip;
            } else {
                toolTip.addAll(this.customTooltip);
            }
        }
        if (toolTip == null && (langTooltip = GuiControl.translateOrDefault(this.getNestedName() + ".tooltip", null)) != null) {
            toolTip = new TextBuilder(langTooltip).build();
        }
        if (toolTip != null) {
            return new GuiTooltipEvent(this, toolTip);
        }
        return null;
    }

    public List<ITextComponent> getTooltip() {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean canOverlap() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(MatrixStack matrix, Rect controlRect, Rect realRect, int mouseX, int mouseY) {
        RenderSystem.clear((int)256, (boolean)Minecraft.field_142025_a);
        Rect rectCopy = null;
        if (!this.enabled) {
            rectCopy = controlRect.copy();
        }
        GuiStyle style = this.getStyle();
        ControlFormatting formatting = this.getControlFormatting();
        style.get(formatting.border).render(matrix, 0.0, 0.0, controlRect.getWidth(), controlRect.getHeight());
        int borderWidth = style.getBorder(formatting.border);
        controlRect.shrink(borderWidth);
        style.get(formatting.face, this.enabled && realRect.inside(mouseX, mouseY)).render(matrix, (double)borderWidth, (double)borderWidth, controlRect.getWidth(), controlRect.getHeight());
        this.renderContent(matrix, formatting, borderWidth, controlRect, realRect, mouseX, mouseY);
        if (!this.enabled) {
            realRect.scissor();
            style.disabled.render(matrix, realRect, rectCopy);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderContent(MatrixStack matrix, ControlFormatting formatting, int borderWidth, Rect controlRect, Rect realRect, int mouseX, int mouseY) {
        controlRect.shrink(formatting.padding);
        matrix.func_227860_a_();
        matrix.func_227861_a_((double)(borderWidth + formatting.padding), (double)(borderWidth + formatting.padding), 0.0);
        this.renderContent(matrix, controlRect, controlRect.intersection(realRect), mouseX, mouseY);
        matrix.func_227865_b_();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderContent(MatrixStack matrix, Rect controlRect, Rect realRect, int mouseX, int mouseY) {
        this.renderContent(matrix, controlRect, mouseX, mouseY);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected abstract void renderContent(MatrixStack var1, Rect var2, int var3, int var4);

    public PlayerEntity getPlayer() {
        return this.parent.getPlayer();
    }

    public boolean isClientSide() {
        return this.getPlayer().field_70170_p.field_72995_K;
    }

    public void moveBehind(GuiControl reference) {
        this.parent.moveBehind(this, reference);
    }

    public void moveInFront(GuiControl reference) {
        this.parent.moveInFront(this, reference);
    }

    public void moveTop() {
        this.parent.moveTop(this);
    }

    public void moveBottom() {
        this.parent.moveBottom(this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String translate(String text, Object ... parameters) {
        return I18n.func_135052_a((String)text, (Object[])parameters);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String translateOrDefault(String text, String defaultText) {
        if (I18n.func_188566_a((String)text)) {
            return GuiControl.translate(text, new Object[0]);
        }
        return defaultText;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playSound(ISound sound) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a(sound);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playSound(SoundEvent event) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)event, (float)1.0f));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playSound(SoundEvent event, float volume, float pitch) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_194007_a((SoundEvent)event, (float)pitch, (float)volume));
    }
}

