/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.layout;

import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.controls.layout.GuiLayoutControl;

public class GuiVBox
extends GuiLayoutControl {
    public GuiVBox(String name, int x, int y, Align align, VAlign valign) {
        super(name, x, y, 1, 1, align, valign);
    }

    public GuiVBox(String name, int x, int y, Align align) {
        super(name, x, y, 1, 1, align, VAlign.TOP);
    }

    public GuiVBox(String name, int x, int y) {
        super(name, x, y, 1, 1, Align.LEFT, VAlign.TOP);
    }

    @Override
    public int getPreferredHeight() {
        if (this.valign != VAlign.TOP) {
            return Integer.MAX_VALUE;
        }
        int height = -this.spacing;
        for (GuiControl control : this) {
            height += control.getPreferredHeight() + this.spacing;
        }
        return height;
    }

    @Override
    public void updateLayout(int width, int height) {
        for (GuiControl control : this) {
            if (this.align == Align.STRETCH) {
                control.setWidthLayout(width);
                continue;
            }
            control.setWidthLayout(Math.min(control.getPreferredWidth(), width));
        }
        int availableHeight = height / this.size();
        int yOffset = 0;
        for (GuiControl control : this) {
            if (this.valign == VAlign.STRETCH) {
                control.setHeightLayout(availableHeight);
            } else {
                control.setHeightLayout(Math.min(control.getPreferredHeight(), availableHeight));
            }
            switch (this.align) {
                case LEFT: {
                    control.setX(0);
                    break;
                }
                case CENTER: {
                    control.setX(width / 2 - control.getWidth() / 2);
                    break;
                }
                case RIGHT: {
                    control.setX(width - control.getWidth());
                }
            }
            control.setY(yOffset);
            yOffset += control.getHeight() + this.spacing;
        }
        yOffset -= this.spacing;
        if (this.valign != VAlign.TOP && this.valign != VAlign.STRETCH) {
            int y = 0;
            for (GuiControl control : this) {
                switch (this.valign) {
                    case CENTER: {
                        control.setY(height / 2 - yOffset / 2 + y);
                        break;
                    }
                    case BOTTOM: {
                        control.setY(height - yOffset + y);
                    }
                }
                y += control.getHeight() + this.spacing;
            }
            this.setHeight(height);
        } else {
            this.setHeight(yOffset);
        }
        this.setWidth(width);
    }

    @Override
    public void setWidthLayout(int width) {
        for (GuiControl control : this) {
            if (this.align == Align.STRETCH) {
                control.setWidthLayout(width);
                continue;
            }
            control.setWidthLayout(Math.min(control.getPreferredWidth(), width));
        }
        this.setWidth(width);
    }

    @Override
    public void setHeightLayout(int height) {
        this.updateLayout(this.getWidth(), height);
    }
}

