/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.integration;

import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHelper;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.NativeUtil;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import team.creative.creativecore.common.gui.integration.IGuiIntegratedParent;

public class ScreenEventListener
implements IGuiEventListener {
    private static final Field eventTime = ObfuscationReflectionHelper.findField(MouseHelper.class, (String)"field_198045_j");
    public static final double DOUBLE_CLICK_TIME = 0.2;
    private final IGuiIntegratedParent gui;
    private final Screen screen;
    private int doubleClickButton = -1;
    private double time;
    private double x;
    private double y;
    private boolean released = false;

    public ScreenEventListener(IGuiIntegratedParent gui, Screen screen) {
        this.gui = gui;
        this.screen = screen;
    }

    public int getOffsetX() {
        return (this.screen.field_230708_k_ - this.gui.getTopLayer().getWidth()) / 2;
    }

    public int getOffsetY() {
        return (this.screen.field_230709_l_ - this.gui.getTopLayer().getHeight()) / 2;
    }

    public void tick() {
        if (this.doubleClickButton != -1 && NativeUtil.func_216394_b() - this.time > 0.2) {
            this.fireRemaingEvents();
        }
    }

    public double getEventTime() {
        try {
            return eventTime.getDouble(Minecraft.func_71410_x().field_71417_B);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    protected void fireRemaingEvents() {
        if (this.doubleClickButton != -1) {
            this.gui.getTopLayer().mouseClicked(this.x, this.y, this.doubleClickButton);
            if (this.released) {
                this.gui.getTopLayer().mouseReleased(this.x, this.y, this.doubleClickButton);
            }
            this.doubleClickButton = -1;
            this.released = false;
        }
    }

    public void func_212927_b(double x, double y) {
        this.gui.getTopLayer().mouseMoved(x - (double)this.getOffsetX(), y - (double)this.getOffsetY());
    }

    public boolean func_231044_a_(double x, double y, int button) {
        if (this.gui.getTopLayer().testForDoubleClick(x - (double)this.getOffsetX(), y - (double)this.getOffsetY())) {
            if (this.doubleClickButton == button) {
                this.released = false;
                this.doubleClickButton = -1;
                return this.gui.getTopLayer().mouseDoubleClicked(x - (double)this.getOffsetX(), y - (double)this.getOffsetY(), button);
            }
            this.fireRemaingEvents();
            this.doubleClickButton = button;
            this.time = this.getEventTime();
            this.x = x - (double)this.getOffsetX();
            this.y = y - (double)this.getOffsetY();
            return true;
        }
        this.fireRemaingEvents();
        return this.gui.getTopLayer().mouseClicked(x - (double)this.getOffsetX(), y - (double)this.getOffsetY(), button);
    }

    public boolean func_231048_c_(double x, double y, int button) {
        if (this.doubleClickButton == button) {
            this.released = true;
            return true;
        }
        this.fireRemaingEvents();
        this.gui.getTopLayer().mouseReleased(x - (double)this.getOffsetX(), y - (double)this.getOffsetY(), button);
        return true;
    }

    public boolean func_231045_a_(double x, double y, int button, double dragX, double dragY) {
        if (this.doubleClickButton == -1) {
            this.gui.getTopLayer().mouseDragged(x - (double)this.getOffsetX(), y - (double)this.getOffsetY(), button, dragX, dragY, this.getEventTime());
        }
        return true;
    }

    public boolean func_231043_a_(double x, double y, double delta) {
        return this.gui.getTopLayer().mouseScrolled(x - (double)this.getOffsetX(), y - (double)this.getOffsetY(), delta);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        return this.gui.getTopLayer().keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        return this.gui.getTopLayer().keyReleased(keyCode, scanCode, modifiers);
    }

    public boolean func_231042_a_(char codePoint, int modifiers) {
        return this.gui.getTopLayer().charTyped(codePoint, modifiers);
    }

    public boolean func_231049_c__(boolean focus) {
        return false;
    }

    public boolean func_231047_b_(double mouseX, double mouseY) {
        return true;
    }
}

